/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;

@WebObject(type="Document")
@Produces(value={"application/json+nxentity", "application/json+esentity", "application/json"})
public class JSONDocumentObject
extends DocumentObject {
    private static final String APPLICATION_JSON_NXENTITY = "application/json+nxentity";

    @GET
    public DocumentModel doGet() {
        return this.doc;
    }

    @PUT
    @Consumes(value={"application/json+nxentity", "application/json"})
    public DocumentModel doPut(DocumentModel doc) throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        doc = session.saveDocument(doc);
        session.save();
        return doc;
    }

    @POST
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doPost(DocumentModel inputDoc) throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        inputDoc.setPathInfo(this.doc.getPathAsString(), inputDoc.getPathAsString());
        inputDoc = session.createDocument(inputDoc);
        session.save();
        return Response.ok((Object)inputDoc).status(Response.Status.CREATED).build();
    }

    @DELETE
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doDeleteJson() throws ClientException {
        super.doDelete();
        return Response.noContent().build();
    }

    @Path(value="@search")
    public Object search() {
        return this.ctx.newAdapter((Resource)this, "search", new Object[0]);
    }

    public DocumentObject newDocument(String path) {
        try {
            PathRef pathRef = new PathRef(this.doc.getPath().append(path).toString());
            DocumentModel doc = this.ctx.getCoreSession().getDocument((DocumentRef)pathRef);
            return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentRef ref) {
        try {
            DocumentModel doc = this.ctx.getCoreSession().getDocument(ref);
            return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentModel doc) {
        try {
            return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

