/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.downloads.ConnectDownloadManagerImpl;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.registration.RegistrationHelper;
import org.nuxeo.connect.registration.response.TrialErrorResponse;
import org.nuxeo.connect.registration.response.TrialRegistrationResponse;
import org.nuxeo.connect.registration.response.TrialSuccessResponse;

public class ConnectGatewayComponent
implements ConnectRegistrationService {
    protected ConnectConnector connector = null;
    protected ConnectDownloadManager downloadManager = null;
    protected ConnectConnector testConnector = null;
    protected TechnicalInstanceIdentifier ctid = new TechnicalInstanceIdentifier();

    public ConnectConnector getTestConnector() {
        return this.testConnector;
    }

    public void setTestConnector(ConnectConnector testConnector) {
        this.testConnector = testConnector;
    }

    @Override
    public TechnicalInstanceIdentifier getCTID() {
        return this.ctid;
    }

    @Override
    public LogicalInstanceIdentifier getCLID() {
        try {
            return LogicalInstanceIdentifier.instance();
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            return null;
        }
    }

    @Override
    public void localRegisterInstance(String strCLID, String description) throws LogicalInstanceIdentifier.InvalidCLID, IOException {
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier(strCLID, description);
        CLID.save();
        this.connector = null;
    }

    @Override
    public boolean isInstanceRegistred() {
        return this.isInstanceRegistered();
    }

    @Override
    public boolean isInstanceRegistered() {
        return LogicalInstanceIdentifier.isRegistered();
    }

    @Override
    public ConnectConnector getConnector() {
        if (NuxeoConnectClient.isTestModeSet() && this.testConnector != null) {
            return this.testConnector;
        }
        if (this.connector == null) {
            this.connector = new ConnectHttpConnector();
        }
        return this.connector;
    }

    public ConnectDownloadManager getDownloadManager() {
        if (this.downloadManager == null) {
            this.downloadManager = new ConnectDownloadManagerImpl();
        }
        return this.downloadManager;
    }

    @Override
    public List<ConnectProject> getAvailableProjectsForRegistration(String login, String password) {
        return RegistrationHelper.getAvailableProjectsForRegistration(login, password);
    }

    @Override
    public void remoteRegisterInstance(String login, String password, String prjId, NuxeoClientInstanceType type, String description) throws IOException, LogicalInstanceIdentifier.InvalidCLID {
        String strCLID = RegistrationHelper.remoteRegisterInstance(login, password, prjId, type, description);
        if (strCLID != null) {
            this.localRegisterInstance(strCLID, description);
        }
    }

    @Override
    public void remoteTrialInstanceRegistration(Map<String, String> parameters) throws RegistrationException, IOException {
        TrialRegistrationResponse res;
        if (!parameters.containsKey("login")) {
            parameters.put("login", parameters.get("email"));
        }
        if ((res = RegistrationHelper.remoteTrialInstanceRegistration(parameters)).isError()) {
            throw new RegistrationException((TrialErrorResponse)res);
        }
        TrialSuccessResponse ss = (TrialSuccessResponse)res;
        try {
            this.localRegisterInstance(ss.getToken().get("CLID"), parameters.get("description"));
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            throw new RegistrationException(e);
        }
    }
}

