/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public abstract class MBeanServerConnectionWrapper
implements MBeanServer {
    protected abstract MBeanServerConnection getMBeanServerConnection() throws IOException;

    protected RuntimeException handleIOException(IOException x, String method) {
        UndeclaredThrowableException r = new UndeclaredThrowableException(x);
        return r;
    }

    private synchronized MBeanServerConnection connection() throws IOException {
        MBeanServerConnection c = this.getMBeanServerConnection();
        if (c == null) {
            throw new IOException("MBeanServerConnection unavailable");
        }
        return c;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.connection().addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "addNotificationListener");
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.connection().addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "addNotificationListener");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.connection().createMBean(className, name);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.connection().createMBean(className, name, params, signature);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.connection().createMBean(className, name, loaderName);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.connection().createMBean(className, name, loaderName, params, signature);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "createMBean");
        }
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().getAttribute(name, attribute);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getAttribute");
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().getAttributes(name, attributes);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getAttributes");
        }
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        throw new UnsupportedOperationException("getClassLoader");
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        throw new UnsupportedOperationException("getClassLoaderFor");
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        throw new UnsupportedOperationException("getClassLoaderRepository");
    }

    @Override
    public String getDefaultDomain() {
        try {
            return this.connection().getDefaultDomain();
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getDefaultDomain");
        }
    }

    @Override
    public String[] getDomains() {
        try {
            return this.connection().getDomains();
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getDomains");
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return this.connection().getMBeanCount();
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getMBeanCount");
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            return this.connection().getMBeanInfo(name);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getMBeanInfo");
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        try {
            return this.connection().getObjectInstance(name);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getObjectInstance");
        }
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.connection().invoke(name, operationName, params, signature);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "invoke");
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        try {
            return this.connection().isInstanceOf(name, className);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "isInstanceOf");
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        try {
            return this.connection().isRegistered(name);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "isRegistered");
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        try {
            return this.connection().queryMBeans(name, query);
        }
        catch (IOException x) {
            this.handleIOException(x, "queryMBeans");
            return new HashSet();
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        try {
            return this.connection().queryNames(name, query);
        }
        catch (IOException x) {
            this.handleIOException(x, "queryNames");
            return new HashSet();
        }
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("registerMBean");
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(name, listener);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(name, listener);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "removeNotificationListener");
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.connection().setAttribute(name, attribute);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "setAttribute");
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().setAttributes(name, attributes);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "setAttributes");
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.connection().unregisterMBean(name);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "unregisterMBean");
        }
    }
}

