/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.local.LocalException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.repository.RepositoryService");
    private static final Log log = LogFactory.getLog(RepositoryService.class);
    public static final String XP_REPOSITORY = "repository";
    private final Map<String, Repository> repositories = new HashMap<String, Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info((Object)"Shutting down repository manager");
        Map<String, Repository> map = this.repositories;
        synchronized (map) {
            for (Repository repository : this.repositories.values()) {
                repository.shutdown();
            }
            this.repositories.clear();
        }
    }

    public int getApplicationStartedOrder() {
        return 100;
    }

    public void start(ComponentContext context) {
        this.initRepositories();
    }

    public void stop(ComponentContext context) {
        TransactionHelper.runInTransaction(this::shutdown);
    }

    public void initRepositories() {
        TransactionHelper.runInTransaction(this::doInitRepositories);
    }

    protected void doInitRepositories() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        for (String name : repositoryManager.getRepositoryNames()) {
            this.openRepository(name);
        }
        RepositoryInitializationHandler handler = RepositoryInitializationHandler.getInstance();
        if (handler == null) {
            return;
        }
        for (String name : repositoryManager.getRepositoryNames()) {
            this.initializeRepository(handler, name);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    protected void openRepository(String name) {
        new UnrestrictedSessionRunner(name){

            public void run() {
            }
        }.runUnrestricted();
    }

    protected void initializeRepository(final RepositoryInitializationHandler handler, String name) {
        new UnrestrictedSessionRunner(name){

            public void run() {
                handler.initializeRepository(this.session);
            }
        }.runUnrestricted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String repositoryName) {
        Map<String, Repository> map = this.repositories;
        synchronized (map) {
            return this.doGetRepository(repositoryName);
        }
    }

    protected Repository doGetRepository(String repositoryName) {
        Repository repository = this.repositories.get(repositoryName);
        if (repository == null) {
            RepositoryFactory factory = this.getFactory(repositoryName);
            if (factory == null) {
                return null;
            }
            repository = (Repository)factory.call();
            this.repositories.put(repositoryName, repository);
        }
        return repository;
    }

    protected RepositoryFactory getFactory(String repositoryName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager == null) {
            return null;
        }
        org.nuxeo.ecm.core.api.repository.Repository repo = repositoryManager.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        RepositoryFactory repositoryFactory = (RepositoryFactory)repo.getRepositoryFactory();
        if (repositoryFactory == null) {
            throw new NullPointerException("Missing repositoryFactory for repository: " + repositoryName);
        }
        return repositoryFactory;
    }

    public List<String> getRepositoryNames() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        return repositoryManager.getRepositoryNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String repositoryName) {
        Map<String, Repository> map = this.repositories;
        synchronized (map) {
            Repository repository = this.doGetRepository(repositoryName);
            if (repository == null) {
                throw new LocalException("No such repository: " + repositoryName);
            }
            return repository.getSession();
        }
    }
}

