/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.EmailValidator;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.registration.RegistrationHelper;
import org.nuxeo.launcher.config.ConfigurationException;

public class ConnectRegistrationBroker {
    private static final Log log = LogFactory.getLog(ConnectRegistrationBroker.class);

    protected static ConnectRegistrationService registration() {
        return NuxeoConnectClient.getConnectRegistrationService();
    }

    public void registerTrial(Map<String, String> parameters) throws IOException, RegistrationException, ConfigurationException {
        try {
            ConnectRegistrationBroker.registration().remoteTrialInstanceRegistration(parameters);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            log.debug((Object)e, (Throwable)e);
            throw new ConfigurationException("Instance registration failed.", (Throwable)e);
        }
    }

    public void registerLocal(String strCLID, String description) throws IOException, ConfigurationException {
        try {
            ConnectRegistrationBroker.registration().localRegisterInstance(strCLID, description);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            log.debug((Object)e, (Throwable)e);
            throw new ConfigurationException("Instance registration failed.", (Throwable)e);
        }
    }

    public void registerRemote(String username, char[] password, String projectId, NuxeoClientInstanceType type, String description) throws IOException, ConfigurationException {
        String strCLID = RegistrationHelper.remoteRegisterInstance((String)username, (String)new String(password), (String)projectId, (NuxeoClientInstanceType)type, (String)description);
        this.registerLocal(strCLID, description);
    }

    public ConnectProject getProjectByName(String projectName, List<ConnectProject> availableProjects) {
        Stream projectStream = availableProjects.stream();
        Optional<ConnectProject> pkg = projectStream.filter(availProject -> projectName.equalsIgnoreCase(availProject.getSymbolicName())).findFirst();
        if (!pkg.isPresent()) {
            return null;
        }
        return pkg.get();
    }

    public List<ConnectProject> getAvailableProjects(String username, char[] password) throws ConfigurationException {
        List studioProjects = ConnectRegistrationBroker.registration().getAvailableProjectsForRegistration(username, new String(password));
        if (studioProjects.isEmpty()) {
            throw new ConfigurationException("Wrong login or password.");
        }
        return studioProjects;
    }

    public static enum TrialField {
        FIRST_NAME("firstName", "First name", input -> Pattern.matches("^(\\p{Alnum}+)([\\s-]\\p{Alnum}+)*", input), "Invalid first name: only letters (without accents), space, and hyphen '-' are accepted."),
        LAST_NAME("lastName", "Last name", input -> Pattern.matches("^(\\p{Alnum}+)([\\s-]\\p{Alnum}+)*", input), "Invalid last name: only letters (without accents), space, and hyphen '-' are accepted."),
        EMAIL("email", "Email", input -> EmailValidator.getInstance().isValid(input), "Invalid email address."),
        COMPANY("company", "Company", input -> Pattern.matches("^(\\p{Alnum}+)([\\s-]\\p{Alnum}+)*", input), "Invalid company name: only alphanumeric (without accents), space, and hyphen '-' are accepted."),
        PROJECT("connectreg:projectName", "Project name", input -> Pattern.matches("^(?:[-\\w]+|)$", input), "Project name can only contain alphanumeric characters and dashes."),
        TERMS_AND_CONDITIONS("termsAndConditions", "Terms and conditions", input -> true, "Unused message.");

        private String id;
        private String name;
        private Predicate<String> predicate;
        private String errorMessage;

        private TrialField(String id, String name, Predicate<String> predicate, String errorMessage) {
            this.id = id;
            this.name = name;
            this.predicate = predicate;
            this.errorMessage = errorMessage;
        }

        public String getId() {
            return this.id;
        }

        public String getPromptMessage() {
            return this.name + ": ";
        }

        public Predicate<String> getPredicate() {
            return this.predicate;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

