/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.DefaultContext;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WebEngineFilter
implements Filter {
    protected WebEngine engine;
    protected boolean isAutoTxEnabled;
    protected boolean isStatefull;
    protected static Log log = LogFactory.getLog(WebEngineFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.engine = (WebEngine)Framework.getLocalService(WebEngine.class);
    }

    public void destroy() {
        this.engine = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        new UnitOfWork((HttpServletRequest)request, (HttpServletResponse)response).doFilter(chain);
    }

    private static class UnitOfWork {
        private final boolean txStarted;
        private final boolean isStatic;
        private final String pathInfo;
        private final DefaultContext context;

        private UnitOfWork(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.pathInfo = StringUtils.isEmpty((CharSequence)req.getPathInfo()) ? "/" : req.getPathInfo();
            this.isStatic = req.getServletPath().contains("/skin") || this.pathInfo.contains("/skin/");
            this.txStarted = !this.isStatic && !TransactionHelper.isTransactionActive() && ServletHelper.startTransaction((HttpServletRequest)req);
            this.context = new DefaultContext(req, (HttpServletResponse)(this.txStarted ? new BufferingHttpServletResponse(resp) : resp));
            req.setAttribute(WebContext.class.getName(), (Object)this.context);
        }

        private void doFilter(FilterChain chain) throws ServletException, IOException {
            boolean completedAbruptly = true;
            try {
                this.preRequest();
                chain.doFilter((ServletRequest)this.context.getRequest(), (ServletResponse)this.context.getResponse());
                this.postRequest();
                completedAbruptly = false;
            }
            catch (IOException | RuntimeException | ServletException error) {
                this.context.getResponse().sendError(500, error.getMessage());
                throw error;
            }
            finally {
                this.cleanup(completedAbruptly);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("WebEngine Filter:");
            sb.append("\nPath Info:");
            sb.append(this.pathInfo);
            sb.append("\nStatic:");
            sb.append(this.isStatic);
            return sb.toString();
        }

        void cleanup(boolean completedAbruptly) throws IOException {
            this.context.getRequest().removeAttribute(WebContext.class.getName());
            if (!this.txStarted) {
                return;
            }
            if (completedAbruptly) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            try {
                TransactionHelper.commitOrRollbackTransaction();
            }
            catch (RuntimeException cause) {
                this.context.getResponse().sendError(500, cause.getMessage());
            }
            finally {
                ((BufferingHttpServletResponse)this.context.getResponse()).stopBuffering();
            }
        }

        void preRequest() {
            HttpServletRequest request = this.context.getRequest();
            if (request.getCharacterEncoding() == null) {
                try {
                    request.setCharacterEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        void postRequest() {
            HttpServletRequest request = this.context.getRequest();
            HttpServletResponse response = this.context.getResponse();
            if (null != request.getAttribute("org.nuxeo.webengine.DisableAutoHeaders")) {
                response.addHeader("Pragma", "no-cache");
                response.addHeader("Cache-Control", "no-cache");
                response.addHeader("Cache-Control", "no-store");
                response.addHeader("Cache-Control", "must-revalidate");
                response.addHeader("Expires", "0");
                response.setDateHeader("Expires", 0L);
            }
        }
    }
}

