/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import com.sun.jersey.server.spi.component.ResourceComponentConstructor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.model.Guard;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.TemplateNotFoundException;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.annotations.AnnotationManager;

public abstract class AbstractResourceType
implements ResourceType {
    protected final WebEngine engine;
    protected final Module owner;
    protected final ResourceComponentConstructor constructor;
    protected final String name;
    protected int visibility = 2;
    protected AbstractResourceType superType;
    protected volatile ClassProxy clazz;
    protected volatile org.nuxeo.ecm.webengine.security.Guard guard = org.nuxeo.ecm.webengine.security.Guard.DEFAULT;
    protected volatile Set<String> facets;
    protected volatile ConcurrentMap<String, ScriptFile> templateCache;

    protected AbstractResourceType(WebEngine engine, Module module, AbstractResourceType superType, String name, ClassProxy clazz, ResourceComponentConstructor constructor, int visibility) {
        this.engine = engine;
        this.owner = module;
        this.superType = superType;
        this.name = name;
        this.clazz = clazz;
        this.constructor = constructor;
        this.visibility = visibility;
        this.templateCache = new ConcurrentHashMap<String, ScriptFile>();
        AnnotationManager mgr = engine.getAnnotationManager();
        this.loadAnnotations(mgr);
    }

    public int getVisibility() {
        return this.visibility;
    }

    protected abstract void loadAnnotations(AnnotationManager var1);

    @Override
    public ResourceType getSuperType() {
        return this.superType;
    }

    public Module getOwnerModule() {
        return this.owner;
    }

    @Override
    public org.nuxeo.ecm.webengine.security.Guard getGuard() {
        return this.guard;
    }

    @Override
    public Set<String> getFacets() {
        return this.facets;
    }

    @Override
    public boolean hasFacet(String facet) {
        return this.facets != null && this.facets.contains(facet);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<Resource> getResourceClass() {
        return this.clazz.get();
    }

    @Override
    public <T extends Resource> T newInstance(Class<T> typeof, WebContext context) {
        try {
            return (T)((Resource)typeof.cast(this.constructor.construct(context.getServerHttpContext())));
        }
        catch (ReflectiveOperationException e) {
            throw WebException.wrap("Failed to instantiate web object: " + this.clazz, e);
        }
    }

    @Override
    public boolean isEnabled(Resource ctx) {
        return this.guard.check(ctx);
    }

    @Override
    public boolean isDerivedFrom(String type) {
        if (type.equals(this.name)) {
            return true;
        }
        if (this.superType != null) {
            return this.superType.isDerivedFrom(type);
        }
        return false;
    }

    @Override
    public void flushCache() {
        this.templateCache = new ConcurrentHashMap<String, ScriptFile>();
    }

    protected void loadGuardFromAnnoation(Class<?> c) {
        Guard ag = c.getAnnotation(Guard.class);
        if (ag != null) {
            String g = ag.value();
            if (g != null && g.length() > 0) {
                try {
                    this.guard = PermissionService.parse(g);
                }
                catch (ParseException e) {
                    throw WebException.wrap("Failed to parse guard: " + g + " on WebObject " + c.getName(), e);
                }
            }
            Class<?> gc = ag.type();
            if (gc != null) {
                try {
                    this.guard = (org.nuxeo.ecm.webengine.security.Guard)gc.newInstance();
                }
                catch (ReflectiveOperationException e) {
                    throw WebException.wrap("Failed to instantiate guard handler: " + gc.getName() + " on WebObject " + c.getName(), e);
                }
            }
        }
    }

    public String toString() {
        return this.name + " extends " + this.superType + " [" + this.getResourceClass().getName() + "]";
    }

    @Override
    public ScriptFile getView(Module module, String name) {
        ScriptFile file = this.findView(module, name);
        if (file == null) {
            throw new TemplateNotFoundException(this, name);
        }
        return file;
    }

    public ScriptFile findView(Module module, String name) {
        AbstractResourceType t;
        ScriptFile file = (ScriptFile)this.templateCache.get(name);
        if (file != null) {
            return file;
        }
        file = this.findSkinTemplate(module, name);
        if (file == null) {
            file = this.findTypeTemplate(module, name);
        }
        if (file == null && (t = (AbstractResourceType)this.getSuperType()) != null) {
            file = t.findView(module, name);
        }
        if (file != null) {
            this.templateCache.put(name, file);
        }
        return file;
    }

    protected ScriptFile findSkinTemplate(Module module, String name) {
        return module.getFile("views" + File.separatorChar + this.name + File.separatorChar + name);
    }

    protected ScriptFile findTypeTemplate(Module module, String name) {
        String path = this.resolveResourcePath(this.clazz.getClassName(), name);
        URL url = this.clazz.get().getResource(path);
        if (url != null) {
            if (!"file".equals(url.getProtocol())) {
                return null;
            }
            try {
                return new ScriptFile(new File(url.toURI()));
            }
            catch (IOException | URISyntaxException e) {
                throw WebException.wrap("Failed to convert URL to URI: " + url, e);
            }
        }
        return null;
    }

    protected String resolveResourcePath(String className, String fileName) {
        String path = className;
        int p = path.lastIndexOf(46);
        if (p > -1) {
            path = path.substring(0, p);
            path = path.replace('.', '/');
            return '/' + path + '/' + fileName;
        }
        return '/' + fileName;
    }
}

