/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import com.sun.jersey.server.spi.component.ResourceComponentConstructor;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.model.AdapterType;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.AbstractResourceType;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.annotations.AnnotationManager;

public class AdapterTypeImpl
extends AbstractResourceType
implements AdapterType {
    protected String targetType;
    protected String[] targetFacets;
    protected final String adapterName;

    public AdapterTypeImpl(WebEngine engine, ModuleImpl module, ResourceTypeImpl superType, String name, String adapterName, ClassProxy clazz, ResourceComponentConstructor constructor, int visibility) {
        super(engine, module, superType, name, clazz, constructor, visibility);
        this.adapterName = adapterName;
    }

    @Override
    public String getAdapterName() {
        return this.adapterName;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public String[] getTargetFacets() {
        return this.targetFacets;
    }

    @Override
    public boolean acceptResource(Resource resource) {
        if (this.acceptType(resource.getType()) && this.targetFacets != null && this.targetFacets.length > 0) {
            String[] facets;
            for (String f : facets = this.targetFacets) {
                if (resource.hasFacet(f)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean acceptType(ResourceType type) {
        if (this.targetType == null || this.targetType == "*") {
            return true;
        }
        return type.isDerivedFrom(this.targetType);
    }

    @Override
    protected void loadAnnotations(AnnotationManager annoMgr) {
        Class<?> c = this.clazz.get();
        WebAdapter ws = c.getAnnotation(WebAdapter.class);
        if (ws == null) {
            return;
        }
        String g = ws.guard();
        if (g != null && g.length() > 0) {
            try {
                this.guard = PermissionService.parse(g);
            }
            catch (ParseException e) {
                throw WebException.wrap("Failed to parse guard: " + g + " on WebObject " + c.getName(), e);
            }
        } else {
            this.loadGuardFromAnnoation(c);
        }
        String[] facets = ws.facets();
        if (facets != null && facets.length > 0) {
            this.facets = new HashSet<String>(Arrays.asList(facets));
        }
        this.targetType = ws.targetType();
        String[] targetFacets = ws.targetFacets();
        if (targetFacets != null && targetFacets.length > 0) {
            this.targetFacets = targetFacets;
        }
    }
}

