/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBReferenceDescriptor;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;

@XObject(value="directory")
public class MongoDBDirectoryDescriptor
extends BaseDirectoryDescriptor {
    @XNode(value="serverUrl")
    public String serverUrl;
    @XNode(value="databaseName")
    public String databaseName;
    @XNodeList(value="references/reference", type=MongoDBReferenceDescriptor[].class, componentType=MongoDBReferenceDescriptor.class)
    public MongoDBReferenceDescriptor[] mongodbReferences;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public MongoDBReferenceDescriptor[] getMongoDBReferences() {
        return this.mongodbReferences;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof MongoDBDirectoryDescriptor) {
            this.merge((MongoDBDirectoryDescriptor)other);
        }
    }

    protected void merge(MongoDBDirectoryDescriptor other) {
        if (other.serverUrl != null) {
            this.serverUrl = other.serverUrl;
        }
        if (other.databaseName != null) {
            this.databaseName = other.databaseName;
        }
        if (other.mongodbReferences != null && this.mongodbReferences.length != 0) {
            this.mongodbReferences = other.mongodbReferences;
        }
    }

    public MongoDBDirectoryDescriptor clone() {
        MongoDBDirectoryDescriptor clone = (MongoDBDirectoryDescriptor)super.clone();
        if (this.mongodbReferences != null) {
            clone.mongodbReferences = new MongoDBReferenceDescriptor[this.mongodbReferences.length];
            for (int i = 0; i < this.mongodbReferences.length; ++i) {
                clone.mongodbReferences[i] = this.mongodbReferences[i].clone();
            }
        }
        return clone;
    }

    public MongoDBDirectory newDirectory() {
        return new MongoDBDirectory(this);
    }
}

