/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.directory.mongodb.MongoDBConnectionHelper;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBDirectoryDescriptor;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.directory.mongodb.MongoDBSerializationHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;

public class MongoDBSession
extends BaseSession {
    protected MongoClient client;
    protected String dbName;
    protected String countersCollectionName;

    public MongoDBSession(MongoDBDirectory directory) {
        super((Directory)directory, MongoDBReference.class);
        MongoDBDirectoryDescriptor desc = directory.getDescriptor();
        this.client = MongoDBConnectionHelper.newMongoClient(desc.getServerUrl());
        this.dbName = desc.getDatabaseName();
        this.countersCollectionName = directory.getCountersCollectionName();
    }

    public MongoDBDirectory getDirectory() {
        return (MongoDBDirectory)this.directory;
    }

    protected DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        String id;
        Map newDocMap = fieldMap.entrySet().stream().filter(entry -> this.getDirectory().getReferences((String)entry.getKey()) == null).collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
        String idFieldName = ((Field)this.schemaFieldMap.get(this.getIdField())).getName().getPrefixedName();
        if (this.autoincrementId) {
            Document filter = MongoDBSerializationHelper.fieldMapToBson("_id", this.directoryName);
            Bson update = Updates.inc((String)"seq", (Number)1L);
            FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
            Long longId = ((Document)this.getCollection(this.countersCollectionName).findOneAndUpdate((Bson)filter, update, options)).getLong((Object)"seq");
            fieldMap.put(idFieldName, longId);
            newDocMap.put(idFieldName, longId);
            id = String.valueOf(longId);
        } else {
            id = String.valueOf(fieldMap.get(idFieldName));
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
        }
        try {
            Document bson = MongoDBSerializationHelper.fieldMapToBson(newDocMap);
            String password = (String)newDocMap.get(this.getPasswordField());
            if (password != null && !PasswordHelper.isHashed((String)password)) {
                password = PasswordHelper.hashPassword((String)password, (String)this.passwordHashAlgorithm);
                bson.append(this.getPasswordField(), (Object)password);
            }
            this.getCollection().insertOne((Object)bson);
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
        return MongoDBSession.createEntryModel(null, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) throws DirectoryException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        for (String fieldName : this.schemaFieldMap.keySet()) {
            if (fieldName.equals(this.getIdField())) continue;
            Property prop = docModel.getPropertyObject(this.schemaName, fieldName);
            if (fieldName.equals(this.getPasswordField()) && StringUtils.isEmpty((String)((String)((Object)prop.getValue())))) continue;
            if (prop != null && prop.isDirty()) {
                Object value = prop.getValue();
                if (fieldName.equals(this.getPasswordField())) {
                    value = PasswordHelper.hashPassword((String)((String)value), (String)this.passwordHashAlgorithm);
                }
                if (value instanceof Calendar) {
                    value = ((Calendar)value).getTime();
                }
                fieldMap.put(prop.getName(), value);
            }
            if (!this.getDirectory().isReference(fieldName)) continue;
            referenceFieldList.add(fieldName);
        }
        String idFieldName = ((Field)this.schemaFieldMap.get(this.getIdField())).getName().getPrefixedName();
        String id = docModel.getId();
        Document bson = MongoDBSerializationHelper.fieldMapToBson(idFieldName, this.autoincrementId ? Long.valueOf(id) : id);
        List updates = fieldMap.entrySet().stream().map(e -> Updates.set((String)((String)e.getKey()), e.getValue())).collect(Collectors.toList());
        if (!updates.isEmpty()) {
            try {
                UpdateResult result = this.getCollection().updateOne((Bson)bson, Updates.combine(updates));
                if (!result.wasAcknowledged()) {
                    throw new DirectoryException("Error while updating the entry, the request has not been acknowledged by the server");
                }
                if (result.getMatchedCount() == 0L) {
                    throw new DirectoryException(String.format("Error while updating the entry, no document was found with the id %s", id));
                }
            }
            catch (MongoWriteException e2) {
                throw new DirectoryException((Throwable)e2);
            }
        }
        return referenceFieldList;
    }

    public void deleteEntryWithoutReferences(String id) throws DirectoryException {
        try {
            String idFieldName = ((Field)this.schemaFieldMap.get(this.getIdField())).getName().getPrefixedName();
            DeleteResult result = this.getCollection().deleteOne((Bson)MongoDBSerializationHelper.fieldMapToBson(idFieldName, this.autoincrementId ? Long.valueOf(id) : id));
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while deleting the entry, the request has not been acknowledged by the server");
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, fetchReferences, -1, 0);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        filter.remove(this.getPasswordField());
        Document bson = this.buildQuery(filter, fulltext);
        DocumentModelListImpl entries = new DocumentModelListImpl();
        FindIterable results = this.getCollection().find((Bson)bson).skip(offset);
        if (limit > 0) {
            results.limit(limit);
        }
        for (Document resultDoc : results) {
            Map<String, Object> fieldMap = MongoDBSerializationHelper.bsonToFieldMap(resultDoc);
            if (!this.readAllColumns) {
                fieldMap.remove(this.getPasswordField());
            }
            DocumentModel doc = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                for (Reference reference : this.directory.getReferences()) {
                    List<String> targetIds;
                    if (reference instanceof MongoDBReference) {
                        MongoDBReference mongoReference = (MongoDBReference)reference;
                        targetIds = mongoReference.getTargetIdsForSource(doc.getId(), this);
                    } else {
                        targetIds = reference.getTargetIdsForSource(doc.getId());
                    }
                    targetIds = new ArrayList<String>(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                }
                for (Map.Entry entry : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    List targetIds = (List)entry.getValue();
                    try {
                        doc.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            entries.add((Object)doc);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List)entries, orderBy);
        }
        return entries;
    }

    protected Document buildQuery(Map<String, Serializable> fieldMap, Set<String> fulltext) {
        Document bson = new Document();
        for (Map.Entry<String, Serializable> entry : fieldMap.entrySet()) {
            Field field = this.schemaFieldMap.entrySet().stream().filter(e -> ((Field)e.getValue()).getName().getPrefixedName().equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
            Serializable v = entry.getValue();
            Object value = field != null ? MongoDBSerializationHelper.valueToBson(v, field.getType()) : MongoDBSerializationHelper.valueToBson(v);
            String key = entry.getKey();
            if (fulltext != null && fulltext.contains(key)) {
                String val = String.valueOf(value);
                switch (this.substringMatchType) {
                    case subany: {
                        this.addField(bson, key, Pattern.compile(val, 2));
                        break;
                    }
                    case subinitial: {
                        this.addField(bson, key, Pattern.compile('^' + val, 2));
                        break;
                    }
                    case subfinal: {
                        this.addField(bson, key, Pattern.compile(val + '$', 2));
                    }
                }
                continue;
            }
            this.addField(bson, key, value);
        }
        return bson;
    }

    protected void addField(Document bson, String key, Object value) {
        String keyFieldName = key;
        Field field = (Field)this.schemaFieldMap.get(key);
        if (field != null) {
            keyFieldName = field.getName().getPrefixedName();
        }
        bson.put(keyFieldName, value);
    }

    public void close() throws DirectoryException {
        this.client.close();
        this.getDirectory().removeSession((Session)this);
    }

    public boolean authenticate(String username, String password) throws DirectoryException {
        Document user = (Document)this.getCollection().find((Bson)MongoDBSerializationHelper.fieldMapToBson(this.getIdField(), username)).first();
        if (user == null) {
            return false;
        }
        String storedPassword = user.getString((Object)this.getPasswordField());
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean isAuthenticating() {
        return this.schemaFieldMap.containsKey(this.getPasswordField());
    }

    public boolean hasEntry(String id) {
        return this.getCollection().count((Bson)MongoDBSerializationHelper.fieldMapToBson(this.getIdField(), id)) > 0L;
    }

    public MongoCollection<Document> getCollection(String collection) {
        return MongoDBConnectionHelper.getCollection(this.client, this.dbName, collection);
    }

    public MongoCollection<Document> getCollection() {
        return this.getCollection(this.directoryName);
    }

    public boolean hasCollection(String collection) {
        return MongoDBConnectionHelper.hasCollection(this.client, this.dbName, collection);
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String idFieldName = ((Field)this.schemaFieldMap.get(this.getIdField())).getName().getPrefixedName();
        if (!fieldMap.containsKey(idFieldName)) {
            idFieldName = this.getIdField();
        }
        String id = String.valueOf(fieldMap.get(idFieldName));
        return MongoDBSession.createEntryModel(null, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
    }
}

