/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;

@Supports(value={"application/json"})
public abstract class AbstractJsonWriter<EntityType>
implements Writer<EntityType> {
    @Inject
    protected RenderingContext ctx;
    @Inject
    protected MarshallerRegistry registry;

    @Override
    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    @Override
    public void write(EntityType entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        JsonGenerator jg = this.getGenerator(out, true);
        this.write(entity, jg);
        jg.flush();
    }

    public abstract void write(EntityType var1, JsonGenerator var2) throws IOException;

    protected void writeEntityField(String fieldName, Object entity, JsonGenerator jg) throws IOException {
        jg.writeFieldName(fieldName);
        this.writeEntity(entity, jg);
    }

    protected void writeEntity(Object entity, JsonGenerator jg) throws IOException {
        this.writeEntity(entity, new OutputStreamWithJsonWriter(jg));
    }

    protected <ObjectType> void writeEntity(ObjectType entity, OutputStream out) throws IOException {
        Class<?> clazz = entity.getClass();
        Writer<?> writer = this.registry.getWriter(this.ctx, clazz, MediaType.APPLICATION_JSON_TYPE);
        if (writer == null) {
            throw new MarshallingException("Unable to get a writer for Java type " + entity.getClass() + " and mimetype " + MediaType.APPLICATION_JSON_TYPE);
        }
        writer.write(entity, entity.getClass(), entity.getClass(), MediaType.APPLICATION_JSON_TYPE, out);
    }

    protected JsonGenerator getGenerator(OutputStream out, boolean getCurrentIfAvailable) throws IOException {
        if (getCurrentIfAvailable && out instanceof OutputStreamWithJsonWriter) {
            OutputStreamWithJsonWriter casted = (OutputStreamWithJsonWriter)out;
            return casted.getJsonGenerator();
        }
        return JsonFactoryProvider.get().createJsonGenerator(out);
    }
}

