/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.api.QuickFilter;

public abstract class DefaultListJsonWriter<EntityType>
extends AbstractJsonWriter<List<EntityType>> {
    private final String entityType;
    private final Class<EntityType> elClazz;
    private final Type elGenericType;

    public DefaultListJsonWriter(String entityType, Class<EntityType> elClazz) {
        this.entityType = entityType;
        this.elClazz = elClazz;
        this.elGenericType = elClazz;
    }

    public DefaultListJsonWriter(String entityType, Class<EntityType> elClazz, Type elGenericType) {
        this.entityType = entityType;
        this.elClazz = elClazz;
        this.elGenericType = elGenericType;
    }

    @Override
    public void write(List<EntityType> list, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        this.ctx.setParameterValues("ENTITY_TYPE", this.entityType);
        jg.writeStringField("entity-type", this.entityType);
        this.writePaginationInfos(list, jg);
        Writer<EntityType> documentWriter = this.registry.getWriter(this.ctx, this.elClazz, this.elGenericType, MediaType.APPLICATION_JSON_TYPE);
        jg.writeArrayFieldStart("entries");
        for (EntityType entity : list) {
            documentWriter.write(entity, this.elClazz, this.elClazz, MediaType.APPLICATION_JSON_TYPE, new OutputStreamWithJsonWriter(jg));
        }
        jg.writeEndArray();
        this.extend(list, jg);
        jg.writeEndObject();
    }

    private void writePaginationInfos(List<EntityType> list, JsonGenerator jg) throws IOException {
        if (list instanceof Paginable) {
            Map<String, Aggregate<Bucket>> aggregates;
            Paginable paginable = (Paginable)list;
            jg.writeBooleanField("isPaginable", true);
            jg.writeNumberField("resultsCount", paginable.getResultsCount());
            jg.writeNumberField("pageSize", paginable.getPageSize());
            jg.writeNumberField("maxPageSize", paginable.getMaxPageSize());
            jg.writeNumberField("currentPageSize", paginable.getCurrentPageSize());
            jg.writeNumberField("currentPageIndex", paginable.getCurrentPageIndex());
            jg.writeNumberField("numberOfPages", paginable.getNumberOfPages());
            jg.writeBooleanField("isPreviousPageAvailable", paginable.isPreviousPageAvailable());
            jg.writeBooleanField("isNextPageAvailable", paginable.isNextPageAvailable());
            jg.writeBooleanField("isLastPageAvailable", paginable.isLastPageAvailable());
            jg.writeBooleanField("isSortable", paginable.isSortable());
            jg.writeBooleanField("hasError", paginable.hasError());
            jg.writeStringField("errorMessage", paginable.getErrorMessage());
            if (paginable instanceof DocumentModelList) {
                jg.writeNumberField("totalSize", ((DocumentModelList)paginable).totalSize());
            }
            jg.writeNumberField("pageIndex", paginable.getCurrentPageIndex());
            jg.writeNumberField("pageCount", paginable.getNumberOfPages());
            if (paginable.hasAggregateSupport() && (aggregates = paginable.getAggregates()) != null && !paginable.getAggregates().isEmpty()) {
                jg.writeObjectFieldStart("aggregations");
                for (Map.Entry<String, Aggregate<Bucket>> e : aggregates.entrySet()) {
                    this.writeEntityField(e.getKey(), e.getValue(), jg);
                }
                jg.writeEndObject();
            }
            List<QuickFilter> qfs = paginable.getActiveQuickFilters();
            List<QuickFilter> aqfs = paginable.getAvailableQuickFilters();
            if (aqfs != null && !aqfs.isEmpty()) {
                jg.writeArrayFieldStart("quickFilters");
                for (QuickFilter aqf : aqfs) {
                    jg.writeStartObject();
                    jg.writeStringField("name", aqf.getName());
                    jg.writeBooleanField("active", qfs.contains(aqf));
                    jg.writeEndObject();
                }
                jg.writeEndArray();
            }
        }
    }

    protected void extend(List<EntityType> list, JsonGenerator jg) throws IOException {
    }
}

