/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentPropertyJsonWriter
extends AbstractJsonWriter<Property> {
    private static final Log log = LogFactory.getLog(DocumentPropertyJsonWriter.class);

    @Override
    public void write(Property prop, JsonGenerator jg) throws IOException {
        this.writeProperty(jg, prop);
        jg.flush();
    }

    protected void writeProperty(JsonGenerator jg, Property prop) throws IOException {
        if (prop.isScalar()) {
            this.writeScalarProperty(jg, prop);
        } else if (prop.isList()) {
            this.writeListProperty(jg, prop);
        } else if (prop.isPhantom()) {
            jg.writeNull();
        } else if (prop instanceof BlobProperty) {
            this.writeBlobProperty(jg, prop);
        } else {
            this.writeComplexProperty(jg, prop);
        }
    }

    protected void writeScalarProperty(JsonGenerator jg, Property prop) throws IOException {
        Type type = prop.getType();
        Serializable value = prop.getValue();
        if (!this.fetchProperty(jg, prop.getType().getObjectResolver(), value, prop.getXPath())) {
            this.writeScalarPropertyValue(jg, (Type)((SimpleType)type).getPrimitiveType(), value);
        }
    }

    private void writeScalarPropertyValue(JsonGenerator jg, Type type, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else if (type instanceof BooleanType) {
            jg.writeBoolean(((Boolean)value).booleanValue());
        } else if (type instanceof LongType) {
            jg.writeNumber(((Long)value).longValue());
        } else if (type instanceof DoubleType) {
            jg.writeNumber(((Double)value).doubleValue());
        } else if (type instanceof IntegerType) {
            jg.writeNumber(((Integer)value).intValue());
        } else if (type instanceof BinaryType) {
            jg.writeBinary((byte[])value);
        } else {
            jg.writeString(type.encode(value));
        }
    }

    protected boolean fetchProperty(JsonGenerator jg, ObjectResolver resolver, Object value, String path) throws IOException {
        if (value == null) {
            return false;
        }
        boolean fetched = false;
        if (resolver != null) {
            Object object;
            String genericPropertyPath = path.replaceAll("/[0-9]*/", "/*/");
            Set<String> fetchElements = this.ctx.getFetched("document");
            boolean fetch = false;
            for (String fetchElement : fetchElements) {
                if (!"properties".equals(fetchElement) && !path.startsWith(fetchElement) && !genericPropertyPath.startsWith(fetchElement)) continue;
                fetch = true;
                break;
            }
            if (fetch && (object = resolver.fetch(value)) != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.writeEntity(object, baos);
                    jg.writeRawValue(baos.toString());
                    fetched = true;
                }
                catch (MarshallingException e) {
                    log.error((Object)("Unable to marshall as json the entity referenced by the property " + path), (Throwable)((Object)e));
                }
            }
        }
        return fetched;
    }

    protected void writeListProperty(JsonGenerator jg, Property prop) throws IOException {
        jg.writeStartArray();
        if (prop instanceof ArrayProperty) {
            Object[] ar = (Object[])prop.getValue();
            if (ar == null) {
                jg.writeEndArray();
                return;
            }
            Type itemType = ((ListType)prop.getType()).getFieldType();
            ObjectResolver resolver = itemType.getObjectResolver();
            String path = prop.getXPath();
            for (Object o : ar) {
                if (this.fetchProperty(jg, resolver, o, path)) continue;
                this.writeScalarPropertyValue(jg, (Type)((SimpleType)itemType).getPrimitiveType(), o);
            }
        } else {
            ListProperty listp = (ListProperty)prop;
            for (Property p : listp.getChildren()) {
                this.writeProperty(jg, p);
            }
        }
        jg.writeEndArray();
    }

    protected void writeComplexProperty(JsonGenerator jg, Property prop) throws IOException {
        jg.writeStartObject();
        for (Property p : prop.getChildren()) {
            jg.writeFieldName(p.getName());
            this.writeProperty(jg, p);
        }
        jg.writeEndObject();
    }

    protected void writeBlobProperty(JsonGenerator jg, Property prop) throws IOException {
        Blob blob = (Blob)prop.getValue();
        if (blob == null) {
            jg.writeNull();
            return;
        }
        jg.writeStartObject();
        String v = blob.getFilename();
        if (v == null) {
            jg.writeNullField("name");
        } else {
            jg.writeStringField("name", v);
        }
        v = blob.getMimeType();
        if (v == null) {
            jg.writeNullField("mime-type");
        } else {
            jg.writeStringField("mime-type", v);
        }
        v = blob.getEncoding();
        if (v == null) {
            jg.writeNullField("encoding");
        } else {
            jg.writeStringField("encoding", v);
        }
        v = blob.getDigestAlgorithm();
        if (v == null) {
            jg.writeNullField("digestAlgorithm");
        } else {
            jg.writeStringField("digestAlgorithm", v);
        }
        v = blob.getDigest();
        if (v == null) {
            jg.writeNullField("digest");
        } else {
            jg.writeStringField("digest", v);
        }
        jg.writeStringField("length", Long.toString(blob.getLength()));
        String blobUrl = this.getBlobUrl(prop);
        if (blobUrl == null) {
            blobUrl = "";
        }
        jg.writeStringField("data", blobUrl);
        jg.writeEndObject();
    }

    private String getBlobUrl(Property prop) {
        DocumentModel doc = (DocumentModel)this.ctx.getParameter("document");
        if (doc == null) {
            return "";
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String xpath = prop.getXPath();
        if (!xpath.contains(":")) {
            xpath = prop.getSchema().getName() + ":" + xpath;
        }
        String filename = ((Blob)prop.getValue()).getFilename();
        return this.ctx.getBaseUrl() + downloadService.getDownloadUrl(doc, xpath, filename);
    }
}

