/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class CoreInstance {
    private static final CoreInstance INSTANCE = new CoreInstance();

    private CoreInstance() {
    }

    public static CoreInstance getInstance() {
        return INSTANCE;
    }

    public static CoreSession openCoreSession(String repositoryName) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal((String)null));
    }

    public static CoreSession openCoreSession(String repositoryName, String username) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(username));
    }

    public static CoreSession openCoreSessionSystem(String repositoryName) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal("system"));
    }

    public static CoreSession openCoreSessionSystem(String repositoryName, String originatingUsername) {
        NuxeoPrincipal principal = CoreInstance.getPrincipal("system");
        principal.setOriginatingUser(originatingUsername);
        return CoreInstance.openCoreSession(repositoryName, principal);
    }

    public static CoreSession openCoreSession(String repositoryName, Map<String, Serializable> context) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(context));
    }

    public static CoreSession openCoreSession(String repositoryName, Principal principal) {
        if (principal instanceof NuxeoPrincipal) {
            return CoreInstance.openCoreSession(repositoryName, (NuxeoPrincipal)principal);
        }
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(principal.getName()));
    }

    public static CoreSession openCoreSession(String repositoryName, NuxeoPrincipal principal) {
        if (repositoryName == null) {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            repositoryName = repositoryManager.getDefaultRepository().getName();
        }
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).createCoreSession(repositoryName, principal);
    }

    public CoreSession getSession(String sessionId) {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSession(sessionId);
    }

    public static void closeCoreSession(CoreSession session) {
        ((CoreSessionService)Framework.getService(CoreSessionService.class)).releaseCoreSession(session);
    }

    protected static NuxeoPrincipal getPrincipal(Map<String, Serializable> map) {
        if (map == null) {
            return CoreInstance.getPrincipal((String)null);
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)map.get("principal");
        if (principal == null) {
            principal = CoreInstance.getPrincipal((String)((Object)map.get("username")));
        }
        return principal;
    }

    protected static NuxeoPrincipal getPrincipal(String username) {
        if (username != null) {
            if ("system".equals(username)) {
                return new SystemPrincipal(null);
            }
            return new UserPrincipal(username, new ArrayList<String>(), false, false);
        }
        LoginStack.Entry entry = ClientLoginModule.getCurrentLogin();
        if (entry != null) {
            Principal p = entry.getPrincipal();
            if (p instanceof NuxeoPrincipal) {
                return (NuxeoPrincipal)p;
            }
            if (LoginComponent.isSystemLogin((Object)p)) {
                return new SystemPrincipal(p.getName());
            }
            throw new RuntimeException("Unsupported principal: " + p.getClass());
        }
        if (Framework.isTestModeSet()) {
            return new SystemPrincipal(null);
        }
        throw new NuxeoException("Cannot create a CoreSession outside a security context,  login() missing.");
    }

    @Deprecated
    public int getNumberOfSessions() {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getNumberOfOpenCoreSessions();
    }

    @Deprecated
    public Collection<CoreSessionService.CoreSessionRegistrationInfo> getRegistrationInfos() {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSessionRegistrationInfos();
    }

    protected static String getCurrentPrincipalName() {
        NuxeoPrincipal p = ClientLoginModule.getCurrentPrincipal();
        return p == null ? null : p.getName();
    }

    public static <R> R doPrivileged(String repositoryName, final Function<CoreSession, R> function) {
        final MutableObject result = new MutableObject();
        new UnrestrictedSessionRunner(repositoryName, CoreInstance.getCurrentPrincipalName()){

            @Override
            public void run() {
                result.setValue(function.apply(this.session));
            }
        }.runUnrestricted();
        return (R)result.getValue();
    }

    public static <R> R doPrivileged(CoreSession session, final Function<CoreSession, R> function) {
        final MutableObject result = new MutableObject();
        new UnrestrictedSessionRunner(session){

            @Override
            public void run() {
                result.setValue(function.apply(this.session));
            }
        }.runUnrestricted();
        return (R)result.getValue();
    }

    public static void doPrivileged(String repositoryName, final Consumer<CoreSession> consumer) {
        new UnrestrictedSessionRunner(repositoryName, CoreInstance.getCurrentPrincipalName()){

            @Override
            public void run() {
                consumer.accept(this.session);
            }
        }.runUnrestricted();
    }

    public static void doPrivileged(CoreSession session, final Consumer<CoreSession> consumer) {
        new UnrestrictedSessionRunner(session){

            @Override
            public void run() {
                consumer.accept(this.session);
            }
        }.runUnrestricted();
    }
}

