/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class UserPrincipal
implements NuxeoPrincipal,
Serializable {
    private static final long serialVersionUID = 2013321088068583749L;
    protected boolean anonymous;
    protected boolean administrator;
    protected String userName;
    protected List<String> groups;
    protected List<String> roles;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String company;
    protected transient String password;
    protected DocumentModel model;
    protected String originatingUser;

    public UserPrincipal(String username, List<String> groups, boolean anonymous, boolean administrator) {
        this.userName = username;
        List emptyGroups = Collections.emptyList();
        this.groups = groups == null ? emptyGroups : groups;
        this.anonymous = anonymous;
        this.administrator = administrator;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public void setName(String name) {
        this.userName = name;
    }

    @Override
    public String getName() {
        return this.userName;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getAllGroups() {
        return this.groups;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPrincipalId() {
        return null;
    }

    @Override
    public void setPrincipalId(String principalId) {
    }

    @Override
    public DocumentModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(DocumentModel model) {
        this.model = model;
    }

    @Override
    public boolean isMemberOf(String group) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserPrincipal)) {
            return false;
        }
        UserPrincipal that = (UserPrincipal)o;
        if (this.company == null ? that.company != null : !this.company.equals(that.company)) {
            return false;
        }
        if (this.firstName == null ? that.firstName != null : !this.firstName.equals(that.firstName)) {
            return false;
        }
        if (this.groups == null ? that.groups != null : !this.groups.equals(that.groups)) {
            return false;
        }
        if (this.lastName == null ? that.lastName != null : !this.lastName.equals(that.lastName)) {
            return false;
        }
        if (this.password == null ? that.password != null : !this.password.equals(that.password)) {
            return false;
        }
        if (this.roles == null ? that.roles != null : !this.roles.equals(that.roles)) {
            return false;
        }
        return !(this.userName == null ? that.userName != null : !this.userName.equals(that.userName));
    }

    @Override
    public int hashCode() {
        int result = this.userName == null ? 0 : this.userName.hashCode();
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.company == null ? 0 : this.company.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    @Override
    public boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public String getTenantId() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getOriginatingUser() {
        return this.originatingUser;
    }

    @Override
    public void setOriginatingUser(String originatingUser) {
        this.originatingUser = originatingUser;
    }

    @Override
    public String getActingUser() {
        return this.getOriginatingUser() == null ? this.getName() : this.getOriginatingUser();
    }

    @Override
    public boolean isTransient() {
        String name = this.getName();
        return name != null && name.startsWith("transient/");
    }
}

