/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.operations;

import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.platform.tag.TagService;

@Operation(id="Services.UntagDocument", category="Services", label="Untag Document", description="Untag document from one or several 'tags'.", since="7.1", addToStudio=true)
public class UntagDocument {
    public static final String ID = "Services.UntagDocument";
    @Context
    protected TagService tagService;
    @Context
    protected CoreSession session;
    @Param(name="tags", required=true, description="Labels or tags separated by comma.")
    protected StringList tags;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel document) throws OperationException {
        if (this.tags != null) {
            for (String tag : this.tags) {
                try {
                    this.tagService.untag(this.session, document.getId(), tag, null);
                }
                catch (DocumentSecurityException e) {
                    throw new OperationException("Unable to remove tag '" + tag + "' on document '" + document.getId() + "'.", (Throwable)e);
                }
            }
        }
        return document;
    }
}

