/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.AbstractType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.FieldImpl;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public class ListTypeImpl
extends AbstractType
implements ListType {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_VALUE_SEPARATOR = " ";
    protected final Type type;
    protected final Field field;
    protected String defaultValue;
    protected int minOccurs;
    protected int maxOccurs;
    protected boolean isArray = false;

    public ListTypeImpl(String schema, String name, Type type, String fieldName, String defaultValue, int flags, Set<Constraint> constraints, int minOccurs, int maxOccurs) {
        super(null, schema, name);
        if (fieldName == null) {
            this.isArray = true;
            fieldName = "item";
        }
        this.type = type;
        Set<Constraint> computedConstraints = this.isArray ? type.getConstraints() : constraints;
        this.field = new FieldImpl(QName.valueOf(fieldName), this, type, defaultValue, flags, computedConstraints);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.defaultValue = defaultValue;
    }

    public ListTypeImpl(String schema, String name, Type type, String fieldName, String defaultValue, int minOccurs, int maxOccurs) {
        this(schema, name, type, fieldName, defaultValue, 0, new HashSet<Constraint>(), minOccurs, maxOccurs);
    }

    public ListTypeImpl(String schema, String name, Type type) {
        this(schema, name, type, null, null, 0, -1);
    }

    @Override
    public void setLimits(int minOccurs, int maxOccurs) {
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getFieldName() {
        return this.field.getName().getLocalName();
    }

    @Override
    public Type getFieldType() {
        return this.field.getType();
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getDefaultValue() {
        return this.type.decode(this.defaultValue);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getMinCount() {
        return this.minOccurs;
    }

    @Override
    public int getMaxCount() {
        return this.maxOccurs;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public Object decode(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String[] split = string.split(DEFAULT_VALUE_SEPARATOR);
        ArrayList<Object> decoded = new ArrayList<Object>(split.length);
        Class klass = null;
        for (String s : split) {
            Object o = this.type.decode(s);
            if (klass == null && o != null) {
                klass = o.getClass();
            }
            decoded.add(o);
        }
        if (klass == null) {
            klass = Object.class;
        }
        Object[] array = (Object[])Array.newInstance(klass, decoded.size());
        return decoded.toArray(array);
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return this.validateCollection((Collection)object);
        }
        if (object.getClass().isArray()) {
            return this.validateArray((Object[])object);
        }
        return false;
    }

    protected boolean validateArray(Object[] array) {
        return true;
    }

    protected boolean validateCollection(Collection col) {
        return true;
    }

    @Override
    public Object newInstance() {
        String defaultValue = this.defaultValue;
        if (defaultValue != null) {
            return defaultValue;
        }
        return new ArrayList();
    }

    @Override
    public Object convert(Object object) throws TypeException {
        if (object instanceof List) {
            List list = (List)object;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Object value = list.get(i);
                list.set(i, this.type.convert(value));
            }
            return object;
        }
        throw new TypeException("Incompatible object: " + object.getClass() + " for type " + this.getName());
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean isScalarList() {
        return this.field.getType().isSimpleType();
    }
}

