/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public final class ConstraintUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    private ConstraintUtils() {
    }

    public static SimpleDateFormat formatter() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static Long objectToTimeMillis(Object object) {
        Long timeValue = null;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            timeValue = ((Date)object).getTime();
        } else if (object instanceof Calendar) {
            timeValue = ((Calendar)object).getTimeInMillis();
        } else if (object instanceof Number) {
            timeValue = ((Number)object).longValue();
        } else {
            SimpleDateFormat dateParser = ConstraintUtils.formatter();
            try {
                timeValue = dateParser.parse(object.toString()).getTime();
            }
            catch (ParseException e) {
                return null;
            }
        }
        return timeValue;
    }

    public static BigDecimal objectToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return new BigDecimal(object.toString());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Long objectToPostiveLong(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Long result = Long.parseLong(object.toString());
            if (result >= 0L) {
                return result;
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static <T extends Constraint> T getConstraint(Collection<Constraint> constraints, Class<T> constraintClass) {
        for (Constraint constraint : constraints) {
            if (!constraint.getClass().equals(constraintClass)) continue;
            return (T)constraint;
        }
        return null;
    }
}

