/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditMigrationWork;
import org.nuxeo.elasticsearch.audit.ESExtendedInfo;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONWriter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class ESAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    public static final String SEQ_NAME = "audit";
    public static final String MIGRATION_FLAG_PROP = "audit.elasticsearch.migration";
    public static final String MIGRATION_BATCH_SIZE_PROP = "audit.elasticsearch.migration.batchSize";
    public static final String MIGRATION_DONE_EVENT = "sqlToElasticsearchMigrationDone";
    public static final int MIGRATION_DEFAULT_BACTH_SIZE = 1000;
    protected Client esClient;
    protected static final Log log = LogFactory.getLog(ESAuditBackend.class);
    protected BaseLogEntryProvider provider = new BaseLogEntryProvider(){

        public int removeEntries(String eventId, String pathPattern) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void addLogEntry(LogEntry logEntry) {
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            entries.add(logEntry);
            ESAuditBackend.this.addLogEntries(entries);
        }

        public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public List<LogEntry> getLogEntriesFor(String uuid) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }
    };

    public ESAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        super(component, config);
    }

    protected Client getClient() {
        log.info((Object)"Activate Elasticsearch backend for Audit");
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        Client client = esa.getClient();
        this.ensureUIDSequencer(client);
        return client;
    }

    protected boolean isMigrationDone() {
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List entries = reader.queryLogs(new String[]{MIGRATION_DONE_EVENT}, null);
        return !entries.isEmpty();
    }

    public int getApplicationStartedOrder() {
        int elasticOrder = ((DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.elasticsearch.ElasticSearchComponent")).getApplicationStartedOrder();
        int uidgenOrder = ((DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.uidgen.UIDGeneratorService")).getApplicationStartedOrder();
        return Integer.max(elasticOrder, uidgenOrder) + 1;
    }

    public void onApplicationStarted() {
        this.esClient = this.getClient();
        if (Boolean.parseBoolean(Framework.getProperty((String)MIGRATION_FLAG_PROP))) {
            if (!this.isMigrationDone()) {
                log.info((Object)String.format("Property %s is true and migration is not done yet, processing audit migration from SQL to Elasticsearch index", MIGRATION_FLAG_PROP));
                ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
                esa.dropAndInitIndex(this.getESIndexName());
                int batchSize = 1000;
                String batchSizeProp = Framework.getProperty((String)MIGRATION_BATCH_SIZE_PROP);
                if (batchSizeProp != null) {
                    batchSize = Integer.parseInt(batchSizeProp);
                }
                this.migrate(batchSize);
            } else {
                log.warn((Object)String.format("Property %s is true but migration is already done, please set this property to false", MIGRATION_FLAG_PROP));
            }
        } else {
            log.debug((Object)String.format("Property %s is false, not processing any migration", MIGRATION_FLAG_PROP));
        }
    }

    public void onApplicationStopped() {
        if (this.esClient == null) {
            return;
        }
        try {
            this.esClient.close();
        }
        finally {
            this.esClient = null;
        }
    }

    public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
        TermQueryBuilder docFilter = QueryBuilders.termQuery((String)"docUUID", (String)uuid);
        TermQueryBuilder repoFilter = QueryBuilders.termQuery((String)"repositoryId", (String)repositoryId);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must((QueryBuilder)docFilter);
        filter = QueryBuilders.boolQuery().must((QueryBuilder)repoFilter);
        return this.getLogEntries((QueryBuilder)filter, false);
    }

    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        TermQueryBuilder filter;
        TermQueryBuilder docFilter = QueryBuilders.termQuery((String)"docUUID", (String)uuid);
        if (MapUtils.isEmpty(filterMap)) {
            filter = docFilter;
        } else {
            filter = QueryBuilders.boolQuery().must((QueryBuilder)docFilter);
            for (String key : filterMap.keySet()) {
                FilterMapEntry entry = filterMap.get(key);
                ((BoolQueryBuilder)filter).must((QueryBuilder)QueryBuilders.termQuery((String)entry.getColumnName(), (Object)entry.getObject()));
            }
        }
        return this.getLogEntries((QueryBuilder)filter, doDefaultSort);
    }

    protected List<LogEntry> getLogEntries(QueryBuilder filter, boolean doDefaultSort) {
        SearchRequestBuilder builder = this.getSearchRequestBuilder(this.esClient);
        if (doDefaultSort) {
            builder.addSort("eventDate", SortOrder.DESC);
        }
        TimeValue keepAlive = TimeValue.timeValueMinutes((long)1L);
        builder.setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)filter)).setScroll(keepAlive).setSize(100);
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.get();
        this.logSearchResponse(searchResponse);
        List<LogEntry> logEntries = this.buildLogEntries(searchResponse);
        while (searchResponse.getHits().getHits().length > 0 && (long)logEntries.size() < searchResponse.getHits().getTotalHits()) {
            logEntries.addAll(this.buildLogEntries(searchResponse));
            searchResponse = this.runNextScroll(searchResponse.getScrollId(), keepAlive);
        }
        return logEntries;
    }

    SearchResponse runNextScroll(String scrollId, TimeValue keepAlive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Scroll request: -XGET 'localhost:9200/_search/scroll' -d '{\"scroll\": \"%s\", \"scroll_id\": \"%s\" }'", keepAlive, scrollId));
        }
        SearchResponse response = (SearchResponse)this.esClient.prepareSearchScroll(scrollId).setScroll(keepAlive).execute().actionGet();
        this.logSearchResponse(response);
        return response;
    }

    protected List<LogEntry> buildLogEntries(SearchResponse searchResponse) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(searchResponse.getHits().getHits().length);
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read(hit.getSourceAsString()));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    protected SearchRequestBuilder getSearchRequestBuilder(Client esClient) {
        return esClient.prepareSearch(new String[]{this.getESIndexName()}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
    }

    public LogEntry getLogEntryByID(long id) {
        GetResponse ret = (GetResponse)this.esClient.prepareGet(this.getESIndexName(), "entry", String.valueOf(id)).get();
        if (!ret.isExists()) {
            return null;
        }
        try {
            return AuditEntryJSONReader.read(ret.getSourceAsString());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read Entry for id " + id, e);
        }
    }

    public SearchRequestBuilder buildQuery(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            query = this.expandQueryVariables(query, params);
        }
        SearchRequestBuilder builder = this.getSearchRequestBuilder(this.esClient);
        builder.setQuery(query);
        return builder;
    }

    public String expandQueryVariables(String query, Object[] params) {
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", "\\${param" + i + "}");
            qParams.put("param" + i, params[i]);
        }
        return this.expandQueryVariables(query, qParams);
    }

    public String expandQueryVariables(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            TextTemplate tmpl = new TextTemplate();
            for (String key : params.keySet()) {
                Object val = params.get(key);
                if (val == null) continue;
                if (val instanceof Calendar) {
                    tmpl.setVariable(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime(val)));
                    continue;
                }
                if (val instanceof Date) {
                    tmpl.setVariable(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime(val)));
                    continue;
                }
                tmpl.setVariable(key, val.toString());
            }
            query = tmpl.processText(query);
        }
        return query;
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        SearchRequestBuilder builder = this.buildQuery(query, params);
        if (pageNb > 0) {
            builder.setFrom(pageNb * pageSize);
        }
        if (pageSize > 0) {
            builder.setSize(pageSize);
        }
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.get();
        this.logSearchResponse(searchResponse);
        return this.buildLogEntries(searchResponse);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        SearchRequestBuilder builder = this.getSearchRequestBuilder(this.esClient);
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventIds[0]));
            } else {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventId", (String[])eventIds));
            }
        }
        if (categories != null && categories.length > 0) {
            if (categories.length == 1) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)categories[0]));
            } else {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"category", (String[])categories));
            }
        }
        if (path != null) {
            filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"docPath", (String)path));
        }
        if (limit != null) {
            filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventDate").lt((Object)limit));
        }
        builder.setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)filterBuilder));
        if (pageNb > 0) {
            builder.setFrom(pageNb * pageSize);
        }
        if (pageSize > 0) {
            builder.setSize(pageSize);
        }
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.get();
        this.logSearchResponse(searchResponse);
        return this.buildLogEntries(searchResponse);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        Date limit = null;
        if (dateRange != null) {
            try {
                limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
            }
            catch (AuditQueryException aqe) {
                aqe.addInfo("Wrong date range query. Query was " + dateRange);
                throw aqe;
            }
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public void addLogEntries(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.esClient.prepareBulk();
        JsonFactory factory = new JsonFactory();
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        try {
            for (LogEntry entry : entries) {
                entry.setId((long)seq.getNext(SEQ_NAME));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Indexing log entry: %s", entry));
                }
                BytesStreamOutput out = new BytesStreamOutput();
                JsonGenerator jsonGen = factory.createJsonGenerator((OutputStream)out);
                XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)out);
                AuditEntryJSONWriter.asJSON(jsonGen, entry);
                bulkRequest.add(this.esClient.prepareIndex(this.getESIndexName(), "entry", String.valueOf(entry.getId())).setSource(builder));
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                for (BulkItemResponse response : bulkResponse.getItems()) {
                    if (!response.isFailed()) continue;
                    log.error((Object)("Unable to index audit entry " + response.getItemId() + " :" + response.getFailureMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Error while indexing Audit entries", (Throwable)e);
        }
    }

    public Long getEventsCount(String eventId) {
        SearchResponse res = (SearchResponse)this.esClient.prepareSearch(new String[]{this.getESIndexName()}).setTypes(new String[]{"entry"}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventId))).setSize(0).get();
        return res.getHits().getTotalHits();
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.syncLogCreationEntries(this.provider, repoId, path, recurs);
    }

    protected QueryBuilder buildFilter(PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        if (searchDocumentModel == null) {
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        int nbFilters = 0;
        for (PredicateDefinition predicate : predicates) {
            PredicateFieldDefinition[] fieldDef = predicate.getValues();
            Object[] val = new Object[fieldDef.length];
            for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                val[fidx] = fieldDef[fidx].getXpath() != null ? searchDocumentModel.getPropertyValue(fieldDef[fidx].getXpath()) : searchDocumentModel.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
            }
            if (!this.isNonNullParam(val)) continue;
            ++nbFilters;
            String op = predicate.getOperator();
            if (op.equalsIgnoreCase("IN")) {
                String[] values = null;
                if (val[0] instanceof Iterable) {
                    ArrayList<String> l = new ArrayList<String>();
                    Iterable vals = (Iterable)val[0];
                    for (Object v : vals) {
                        if (v == null) continue;
                        l.add(v.toString());
                    }
                    values = l.toArray(new String[l.size()]);
                } else if (val[0] instanceof Object[]) {
                    values = (String[])val[0];
                }
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)predicate.getParameter(), values));
                continue;
            }
            if (op.equalsIgnoreCase("BETWEEN")) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gt(val[0]));
                if (val.length <= 1) continue;
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lt(val[1]));
                continue;
            }
            if (">".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gt(val[0]));
                continue;
            }
            if (">=".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).gte(val[0]));
                continue;
            }
            if ("<".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lt(val[0]));
                continue;
            }
            if ("<=".equals(op)) {
                filterBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)predicate.getParameter()).lte(val[0]));
                continue;
            }
            filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)predicate.getParameter(), (Object)val[0]));
        }
        if (nbFilters == 0) {
            return QueryBuilders.matchAllQuery();
        }
        return filterBuilder;
    }

    public SearchRequestBuilder buildSearchQuery(String fixedPart, PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        SearchRequestBuilder builder = this.getSearchRequestBuilder(this.esClient);
        WrapperQueryBuilder queryBuilder = QueryBuilders.wrapperQuery((String)fixedPart);
        QueryBuilder filterBuilder = this.buildFilter(predicates, searchDocumentModel);
        builder.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(filterBuilder));
        return builder;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public String migrate(int batchSize) {
        String MIGRATION_WORK_ID = "AuditMigration";
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        Work.State migrationState = wm.getWorkState("AuditMigration");
        if (migrationState != null) {
            return "Migration already scheduled : " + migrationState.toString();
        }
        ESAuditMigrationWork migrationWork = new ESAuditMigrationWork("AuditMigration", batchSize);
        wm.schedule((Work)migrationWork);
        return "Migration work started : AuditMigration";
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequestBuilder request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getESIndexName(), "entry", request.toString()));
        }
    }

    protected void ensureUIDSequencer(Client esClient) {
        boolean auditIndexExists = ((IndicesExistsResponse)esClient.admin().indices().prepareExists(new String[]{this.getESIndexName()}).execute().actionGet()).isExists();
        if (!auditIndexExists) {
            return;
        }
        SearchRequestBuilder builder = this.getSearchRequestBuilder(esClient);
        builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AbstractAggregationBuilder)AggregationBuilders.max((String)"maxAgg").field("id"));
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        Max agg = (Max)searchResponse.getAggregations().get("maxAgg");
        int maxLogEntryId = (int)agg.getValue();
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        seq.init();
        int nextSequenceId = seq.getNext(SEQ_NAME);
        if (nextSequenceId < maxLogEntryId) {
            log.info((Object)String.format("Next UID returned by %s sequence is %d, initializing sequence to %d", SEQ_NAME, nextSequenceId, maxLogEntryId));
            seq.initSequence(SEQ_NAME, maxLogEntryId);
        }
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return new ESExtendedInfo(value);
    }

    protected String getESIndexName() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getIndexNameForType("entry");
    }
}

