/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.automation.scripting.internals.AutomationScriptingServiceImpl;
import org.nuxeo.automation.scripting.internals.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.ScriptingOperationImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;

public class ScriptingOperationTypeImpl
implements OperationType {
    protected final AutomationScriptingServiceImpl scripting;
    protected final AutomationService automation;
    protected final ScriptingOperationDescriptor desc;
    protected final InvokableMethod method = this.runMethod();

    public ScriptingOperationTypeImpl(AutomationScriptingServiceImpl scripting, AutomationService automation, ScriptingOperationDescriptor desc) {
        this.scripting = scripting;
        this.automation = automation;
        this.desc = desc;
    }

    public String getContributingComponent() {
        return "org.nuxeo.automation.scripting.internals.AutomationScriptingComponent";
    }

    public OperationDocumentation getDocumentation() {
        OperationDocumentation doc = new OperationDocumentation(this.getId());
        doc.label = this.getId();
        doc.category = this.desc.getCategory();
        doc.description = this.desc.getDescription();
        doc.params = this.desc.getParams();
        doc.signature = new String[]{this.desc.getInputType(), this.desc.getOutputType()};
        doc.aliases = this.desc.getAliases();
        return doc;
    }

    public String getId() {
        return this.desc.getId();
    }

    public String[] getAliases() {
        return this.desc.getAliases();
    }

    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        HashMap<String, Object> params = new HashMap<String, Object>(args);
        this.scripting.paramsInjector.inject(params, ctx, this.desc);
        return new ScriptingOperationImpl(this.desc.source, ctx, params);
    }

    public Class<?> getType() {
        return ScriptingOperationImpl.class;
    }

    public AutomationService getService() {
        return this.automation;
    }

    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return new InvokableMethod[]{this.method};
    }

    public List<InvokableMethod> getMethods() {
        return Collections.singletonList(this.method);
    }

    protected InvokableMethod runMethod() {
        try {
            return new InvokableMethod((OperationType)this, ScriptingOperationImpl.class.getMethod("run", new Class[0]));
        }
        catch (ReflectiveOperationException cause) {
            throw new Error("Cannot reference run method of " + ScriptingOperationImpl.class);
        }
    }
}

