/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.management;

import java.util.List;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.storage.sql.management.SQLRepositoryStatusMBean;
import org.nuxeo.runtime.api.Framework;

public class SQLRepositoryStatus
implements SQLRepositoryStatusMBean {
    protected static List<RepositoryManagement> getRepositories() {
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
        return sqlRepositoryService.getRepositories();
    }

    @Override
    public String listActiveSessions() {
        StringBuilder buf = new StringBuilder();
        buf.append("Actives sessions for SQL repositories:<br />");
        for (RepositoryManagement repository : SQLRepositoryStatus.getRepositories()) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.getActiveSessionsCount());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public int getActiveSessionsCount() {
        int count = 0;
        for (RepositoryManagement repository : SQLRepositoryStatus.getRepositories()) {
            count += repository.getActiveSessionsCount();
        }
        return count;
    }

    @Override
    public String clearCaches() {
        StringBuilder buf = new StringBuilder();
        buf.append("Cleared cached objects for SQL repositories:<br />");
        for (RepositoryManagement repository : SQLRepositoryStatus.getRepositories()) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.clearCaches());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public long getCachesSize() {
        long size = 0L;
        for (RepositoryManagement repository : SQLRepositoryStatus.getRepositories()) {
            size += repository.getCacheSize();
        }
        return size;
    }

    @Override
    public String listRemoteSessions() {
        StringBuilder buf = new StringBuilder();
        buf.append("Actives remote session for SQL repositories:<br />");
        for (RepositoryManagement repository : SQLRepositoryStatus.getRepositories()) {
            buf.append("<b>").append(repository.getName()).append("</b>");
            buf.append("<br/>");
        }
        return buf.toString();
    }

    @Override
    public BinaryManagerStatus gcBinaries(boolean delete) {
        return ((DocumentBlobManager)Framework.getService(DocumentBlobManager.class)).garbageCollectBinaries(delete);
    }

    @Override
    public boolean isBinariesGCInProgress() {
        return ((DocumentBlobManager)Framework.getService(DocumentBlobManager.class)).isBinariesGarbageCollectionInProgress();
    }
}

