/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.image;

import com.levigo.jbig2.image.FilterType;

abstract class Filter {
    final boolean cardinal;
    double support;
    double blur;

    public static String nameByType(FilterType filterType) {
        if (filterType == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        return filterType.name();
    }

    public static FilterType typeByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return FilterType.valueOf(string);
    }

    public static Filter byType(FilterType filterType) {
        switch (filterType) {
            case Bessel: {
                return new Bessel();
            }
            case Blackman: {
                return new Blackman();
            }
            case Box: {
                return new Box();
            }
            case Catrom: {
                return new Catrom();
            }
            case Cubic: {
                return new Cubic();
            }
            case Gaussian: {
                return new Gaussian();
            }
            case Hamming: {
                return new Hamming();
            }
            case Hanning: {
                return new Hanning();
            }
            case Hermite: {
                return new Hermite();
            }
            case Lanczos: {
                return new Lanczos();
            }
            case Mitchell: {
                return new Mitchell();
            }
            case Point: {
                return new Point();
            }
            case Quadratic: {
                return new Quadratic();
            }
            case Sinc: {
                return new Sinc();
            }
            case Triangle: {
                return new Triangle();
            }
        }
        throw new IllegalArgumentException("No filter for given type.");
    }

    protected Filter() {
        this(true, 1.0, 1.0);
    }

    protected Filter(boolean bl, double d, double d2) {
        this.cardinal = bl;
        this.support = d;
        this.blur = d2;
    }

    public double fWindowed(double d) {
        return d < -this.support || d > this.support ? 0.0 : this.f(d);
    }

    public abstract double f(double var1);

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public double getSupport() {
        return this.support;
    }

    public void setSupport(double d) {
        this.support = d;
    }

    public double getBlur() {
        return this.blur;
    }

    public void setBlur(double d) {
        this.blur = d;
    }

    public static final class Triangle
    extends Filter {
        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 1.0) {
                return 1.0 - d;
            }
            return 0.0;
        }
    }

    public static final class Sinc
    extends Filter {
        public Sinc() {
            super(true, 4.0, 1.0);
        }

        public double f(double d) {
            if ((d *= Math.PI) != 0.0) {
                return Math.sin(d) / d;
            }
            return 1.0;
        }
    }

    public static final class Quadratic
    extends Filter {
        public Quadratic() {
            super(false, 1.5, 1.0);
        }

        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 0.5) {
                return 0.75 - d * d;
            }
            if (d < 1.5) {
                return 0.5 * (d -= 1.5) * d;
            }
            return 0.0;
        }
    }

    public static final class Mitchell
    extends Filter {
        public Mitchell() {
            super(false, 2.0, 1.0);
        }

        public double f(double d) {
            double d2 = 0.3333333333333333;
            double d3 = 0.3333333333333333;
            if (d < 0.0) {
                d = -d;
            }
            if (d < 1.0) {
                d = (12.0 - 9.0 * d2 - 6.0 * d3) * (d * d * d) + (-18.0 + 12.0 * d2 + 6.0 * d3) * d * d + (6.0 - 2.0 * d2);
                return d / 6.0;
            }
            if (d < 2.0) {
                d = (-1.0 * d2 - 6.0 * d3) * (d * d * d) + (6.0 * d2 + 30.0 * d3) * d * d + (-12.0 * d2 - 48.0 * d3) * d + (8.0 * d2 + 24.0 * d3);
                return d / 6.0;
            }
            return 0.0;
        }
    }

    public static final class Lanczos
    extends Filter {
        public Lanczos() {
            super(true, 3.0, 1.0);
        }

        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 3.0) {
                return (float)(this.sinc(d) * this.sinc(d / 3.0));
            }
            return 0.0;
        }

        private double sinc(double d) {
            if (d != 0.0) {
                return Math.sin(d *= Math.PI) / d;
            }
            return 1.0;
        }
    }

    public static final class Hermite
    extends Filter {
        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 1.0) {
                return (2.0 * d - 3.0) * d * d + 1.0;
            }
            return 0.0;
        }
    }

    public static final class Hanning
    extends Filter {
        public double f(double d) {
            return 0.5 + 0.5 * Math.cos(Math.PI * d);
        }
    }

    public static final class Hamming
    extends Filter {
        public double f(double d) {
            return 0.54 + 0.46 * Math.cos(Math.PI * d);
        }
    }

    public static final class Gaussian
    extends Filter {
        public Gaussian() {
            super(false, 1.25, 1.0);
        }

        public double f(double d) {
            return Math.exp(-2.0 * d * d) * Math.sqrt(0.6366197723675814);
        }
    }

    public static final class Cubic
    extends Filter {
        public Cubic() {
            super(false, 2.0, 1.0);
        }

        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 1.0) {
                return 0.5 * d * d * d - d * d + 0.6666666666666666;
            }
            if (d < 2.0) {
                d = 2.0 - d;
                return 0.16666666666666666 * d * d * d;
            }
            return 0.0;
        }
    }

    public static final class Catrom
    extends Filter {
        public Catrom() {
            super(true, 2.0, 1.0);
        }

        public double f(double d) {
            if (d < 0.0) {
                d = -d;
            }
            if (d < 1.0) {
                return 0.5 * (2.0 + d * d * (-5.0 + d * 3.0));
            }
            if (d < 2.0) {
                return 0.5 * (4.0 + d * (-8.0 + d * (5.0 - d)));
            }
            return 0.0;
        }
    }

    public static final class Point
    extends Box {
        public Point() {
            super(0.0);
        }

        public double fWindowed(double d) {
            return super.f(d);
        }
    }

    public static class Box
    extends Filter {
        public Box() {
            super(true, 0.5, 1.0);
        }

        public Box(double d) {
            super(true, d, 1.0);
        }

        public double f(double d) {
            if (d >= -0.5 && d < 0.5) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public static final class Blackman
    extends Filter {
        public double f(double d) {
            return 0.42 + 0.5 * Math.cos(Math.PI * d) + 0.08 * Math.cos(Math.PI * 2 * d);
        }
    }

    public static final class Bessel
    extends Filter {
        public Bessel() {
            super(false, 3.2383, 1.0);
        }

        private double J1(double d) {
            double[] dArray = new double[]{5.811993540016061E20, -6.672106568924916E19, 2.3164335806340024E18, -3.588817569910106E16, 2.9087952638347756E14, -1.3229834803321265E12, 3.4132341823017006E9, -4695753.530642996, 2701.1227108923235};
            double[] dArray2 = new double[]{1.1623987080032122E21, 1.185770712190321E19, 6.092061398917522E16, 2.0816612213076075E14, 5.2437102621676495E11, 1.013863514358674E9, 1501793.5949985855, 1606.9315734814877, 1.0};
            double d2 = dArray[8];
            double d3 = dArray2[8];
            for (int i = 7; i >= 0; --i) {
                d2 = d2 * d * d + dArray[i];
                d3 = d3 * d * d + dArray2[i];
            }
            return d2 / d3;
        }

        private double P1(double d) {
            double[] dArray = new double[]{35224.66491336798, 62758.84524716128, 31353.963110915956, 4985.4832060594335, 211.15291828539623, 1.2571716929145342};
            double[] dArray2 = new double[]{35224.66491336798, 62694.34695935605, 31240.406381904104, 4930.396490181089, 203.07751891347593, 1.0};
            double d2 = dArray[5];
            double d3 = dArray2[5];
            for (int i = 4; i >= 0; --i) {
                d2 = d2 * (8.0 / d) * (8.0 / d) + dArray[i];
                d3 = d3 * (8.0 / d) * (8.0 / d) + dArray2[i];
            }
            return d2 / d3;
        }

        private double Q1(double d) {
            double[] dArray = new double[]{351.17519143035526, 721.0391804904475, 425.98730116544425, 83.18989576738508, 4.568171629551227, 0.03532840052740124};
            double[] dArray2 = new double[]{7491.737417180912, 15414.177339265098, 9152.231701516992, 1811.1867005523513, 103.81875854621337, 1.0};
            double d2 = dArray[5];
            double d3 = dArray2[5];
            for (int i = 4; i >= 0; --i) {
                d2 = d2 * (8.0 / d) * (8.0 / d) + dArray[i];
                d3 = d3 * (8.0 / d) * (8.0 / d) + dArray2[i];
            }
            return d2 / d3;
        }

        private double BesselOrderOne(double d) {
            if (d == 0.0) {
                return 0.0;
            }
            double d2 = d;
            if (d < 0.0) {
                d = -d;
            }
            if (d < 8.0) {
                return d2 * this.J1(d);
            }
            double d3 = Math.sqrt(2.0 / (Math.PI * d)) * (this.P1(d) * (1.0 / Math.sqrt(2.0) * (Math.sin(d) - Math.cos(d))) - 8.0 / d * this.Q1(d) * (-1.0 / Math.sqrt(2.0) * (Math.sin(d) + Math.cos(d))));
            if (d2 < 0.0) {
                d3 = -d3;
            }
            return d3;
        }

        public double f(double d) {
            if (d == 0.0) {
                return 0.7853981633974483;
            }
            return this.BesselOrderOne(Math.PI * d) / (2.0 * d);
        }
    }
}

