/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.image;

import com.levigo.jbig2.image.Weighttab;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

abstract class Scanline {
    int y;
    protected final int length;

    protected Scanline(int n) {
        this.length = n;
    }

    protected final int getWidth() {
        return this.length;
    }

    protected abstract void clear();

    protected abstract void fetch(int var1, int var2);

    protected abstract void filter(int[] var1, int[] var2, Weighttab[] var3, Scanline var4);

    protected abstract void accumulate(int var1, Scanline var2);

    protected abstract void shift(int[] var1);

    protected abstract void store(int var1, int var2);

    protected static final class ByteBiLevelPackedScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;

        protected ByteBiLevelPackedScanline(Raster raster, WritableRaster writableRaster, int n) {
            super(n);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.data = new int[n];
        }

        protected void accumulate(int n, Scanline scanline) {
            ByteBiLevelPackedScanline byteBiLevelPackedScanline = (ByteBiLevelPackedScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = byteBiLevelPackedScanline.data;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = i;
                nArray2[n2] = nArray2[n2] + n * nArray[i];
            }
        }

        protected void clear() {
            int[] nArray = this.data;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
        }

        protected void fetch(int n, int n2) {
            this.srcRaster.getPixels(n, n2, this.length, 1, this.data);
            for (int i = 0; i < this.length; ++i) {
                if (this.data[i] == 0) continue;
                this.data[i] = 255;
            }
        }

        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            ByteBiLevelPackedScanline byteBiLevelPackedScanline = (ByteBiLevelPackedScanline)scanline;
            int n = scanline.length;
            int n2 = 1 << nArray2[0] - 1;
            int[] nArray3 = this.data;
            int[] nArray4 = byteBiLevelPackedScanline.data;
            int n3 = nArray[0];
            int n4 = nArray2[0];
            if (n3 != 0) {
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    int n6;
                    Weighttab weighttab = weighttabArray[i];
                    int n7 = weighttab.weights.length;
                    int n8 = n2;
                    int n9 = weighttab.i0;
                    for (n6 = 0; n6 < n7 && n9 < nArray3.length; ++n6) {
                        n8 += weighttab.weights[n6] * (nArray3[n9++] >> n3);
                    }
                    n6 = n8 >> n4;
                    nArray4[n5++] = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                }
            } else {
                int n10 = 0;
                for (int i = 0; i < n; ++i) {
                    Weighttab weighttab = weighttabArray[i];
                    int n11 = weighttab.weights.length;
                    int n12 = n2;
                    int n13 = weighttab.i0;
                    for (int j = 0; j < n11 && n13 < nArray3.length; ++j) {
                        n12 += weighttab.weights[j] * nArray3[n13++];
                    }
                    nArray4[n10++] = n12 >> n4;
                }
            }
        }

        protected void shift(int[] nArray) {
            int n = nArray[0];
            int n2 = 1 << n - 1;
            int[] nArray2 = this.data;
            for (int i = 0; i < nArray2.length; ++i) {
                int n3 = nArray2[i] + n2 >> n;
                nArray2[i] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
            }
        }

        protected void store(int n, int n2) {
            this.dstRaster.setPixels(n, n2, this.length, 1, this.data);
        }
    }

    protected static final class GenericRasterScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int componentCount;
        private final int[][] data;
        private final SampleModel srcSM;
        private final SampleModel dstSM;
        private final int[] channelMask;
        private final int[] tmp;
        private final ScanlineFilter inputFilter;

        protected GenericRasterScanline(Raster raster, WritableRaster writableRaster, int n, int[] nArray, ScanlineFilter scanlineFilter) {
            super(n);
            int n2;
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.inputFilter = scanlineFilter;
            this.srcSM = this.srcRaster.getSampleModel();
            this.dstSM = this.dstRaster.getSampleModel();
            this.componentCount = this.srcSM.getNumBands();
            if (this.componentCount != this.dstSM.getNumBands()) {
                throw new IllegalArgumentException("weird: src raster num bands != dst raster num bands");
            }
            this.tmp = new int[this.componentCount];
            this.data = new int[this.componentCount][];
            for (n2 = 0; n2 < this.data.length; ++n2) {
                this.data[n2] = new int[n];
            }
            this.channelMask = new int[this.componentCount];
            for (n2 = 0; n2 < this.componentCount; ++n2) {
                this.channelMask[n2] = (1 << nArray[n2]) - 1;
            }
        }

        protected void accumulate(int n, Scanline scanline) {
            GenericRasterScanline genericRasterScanline = (GenericRasterScanline)scanline;
            int n2 = genericRasterScanline.data[0].length;
            for (int i = 0; i < this.componentCount; ++i) {
                int[] nArray = this.data[i];
                int[] nArray2 = genericRasterScanline.data[i];
                for (int j = 0; j < n2; ++j) {
                    int n3 = j;
                    nArray2[n3] = nArray2[n3] + n * nArray[j];
                }
            }
        }

        protected void clear() {
            for (int i = 0; i < this.componentCount; ++i) {
                int[] nArray = this.data[i];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray[j] = 0;
                }
            }
        }

        protected void fetch(int n, int n2) {
            for (int i = 0; i < this.componentCount; ++i) {
                this.srcRaster.getSamples(n, n2, this.length, 1, i, this.data[i]);
                if (null == this.inputFilter) continue;
                this.inputFilter.filter(n, n2, i, this.data[i], this.length);
            }
        }

        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            int n;
            int n2;
            GenericRasterScanline genericRasterScanline = (GenericRasterScanline)scanline;
            int n3 = scanline.length;
            int[] nArray3 = this.tmp;
            for (n2 = 0; n2 < this.componentCount; ++n2) {
                nArray3[n2] = 1 << nArray2[n2] - 1;
            }
            n2 = this.data[0].length;
            boolean bl = false;
            for (n = 0; n < this.componentCount && !bl; bl |= nArray[n] != 0, ++n) {
            }
            if (bl) {
                for (n = 0; n < this.componentCount; ++n) {
                    int[] nArray4 = this.data[n];
                    int[] nArray5 = genericRasterScanline.data[n];
                    int n4 = this.channelMask[n];
                    for (int i = 0; i < n3; ++i) {
                        Weighttab weighttab = weighttabArray[i];
                        int n5 = weighttab.weights.length;
                        int n6 = nArray3[n];
                        int n7 = 0;
                        for (int j = weighttab.i0; n7 < n5 && j < n2; ++n7, ++j) {
                            n6 += weighttab.weights[n7] * (nArray4[j] >> nArray[n]);
                        }
                        n7 = n6 >> nArray2[n];
                        nArray5[i] = n7 < 0 ? 0 : (n7 > n4 ? n4 : n7);
                    }
                }
            } else {
                for (n = 0; n < this.componentCount; ++n) {
                    int[] nArray6 = this.data[n];
                    int[] nArray7 = genericRasterScanline.data[n];
                    for (int i = 0; i < n3; ++i) {
                        Weighttab weighttab = weighttabArray[i];
                        int n8 = weighttab.weights.length;
                        int n9 = nArray3[n];
                        int n10 = 0;
                        for (int j = weighttab.i0; n10 < n8 && j < n2; ++n10, ++j) {
                            n9 += weighttab.weights[n10] * nArray6[j];
                        }
                        nArray7[i] = n9 >> nArray2[n];
                    }
                }
            }
        }

        protected void shift(int[] nArray) {
            int[] nArray2 = this.tmp;
            for (int i = 0; i < this.componentCount; ++i) {
                nArray2[i] = 1 << nArray[i] - 1;
            }
            int[][] nArray3 = this.data;
            int n = nArray3[0].length;
            for (int i = 0; i < this.componentCount; ++i) {
                int[] nArray4 = this.data[i];
                int n2 = this.channelMask[i];
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray4[j] + nArray2[i] >> nArray[i];
                    nArray4[j] = n3 < 0 ? 0 : (n3 > n2 ? n2 : n3);
                }
            }
        }

        protected void store(int n, int n2) {
            int n3 = this.length;
            for (int i = 0; i < this.componentCount; ++i) {
                this.dstRaster.setSamples(n, n2, n3, 1, i, this.data[i]);
            }
        }
    }

    protected static final class IntegerSinglePixelPackedScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;
        private final int[] bitMasks;
        private final int[] bitOffsets;
        private final int componentCount;
        private final SinglePixelPackedSampleModel srcSM;
        private final int[] tmp;

        protected IntegerSinglePixelPackedScanline(Raster raster, WritableRaster writableRaster, int n) {
            super(n);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.srcSM = (SinglePixelPackedSampleModel)this.srcRaster.getSampleModel();
            this.bitMasks = this.srcSM.getBitMasks();
            this.bitOffsets = this.srcSM.getBitOffsets();
            this.componentCount = this.bitMasks.length;
            if (this.componentCount != this.bitOffsets.length || this.bitOffsets.length != this.srcSM.getNumBands()) {
                throw new IllegalArgumentException("weird: getBitMasks().length != getBitOffsets().length");
            }
            this.tmp = new int[this.componentCount];
            this.data = new int[this.componentCount * n];
        }

        protected void accumulate(int n, Scanline scanline) {
            IntegerSinglePixelPackedScanline integerSinglePixelPackedScanline = (IntegerSinglePixelPackedScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = integerSinglePixelPackedScanline.data;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = i;
                nArray2[n2] = nArray2[n2] + n * nArray[i];
            }
        }

        protected void clear() {
            int[] nArray = this.data;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
        }

        protected void fetch(int n, int n2) {
            this.srcRaster.getPixels(n, n2, this.length, 1, this.data);
        }

        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            int n;
            IntegerSinglePixelPackedScanline integerSinglePixelPackedScanline = (IntegerSinglePixelPackedScanline)scanline;
            int n2 = scanline.length;
            int[] nArray3 = this.tmp;
            for (int i = 0; i < this.componentCount; ++i) {
                nArray3[i] = 1 << nArray2[i] - 1;
            }
            int[] nArray4 = this.data;
            int[] nArray5 = integerSinglePixelPackedScanline.data;
            boolean bl = false;
            for (n = 0; n < this.componentCount && !bl; bl |= nArray[n] != 0, ++n) {
            }
            if (bl) {
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    Weighttab weighttab = weighttabArray[i];
                    int n3 = weighttab.weights.length;
                    for (int j = 0; j < this.componentCount; ++j) {
                        int n4 = nArray3[j];
                        int n5 = 0;
                        for (int k = weighttab.i0 * this.componentCount + j; n5 < n3 && k < nArray4.length; ++n5, k += this.componentCount) {
                            n4 += weighttab.weights[n5] * (nArray4[k] >> nArray[j]);
                        }
                        n5 = n4 >> nArray2[j];
                        nArray5[n++] = n5 < 0 ? 0 : (n5 > 255 ? 255 : n5);
                    }
                }
            } else {
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    Weighttab weighttab = weighttabArray[i];
                    int n6 = weighttab.weights.length;
                    for (int j = 0; j < this.componentCount; ++j) {
                        int n7 = nArray3[j];
                        int n8 = 0;
                        for (int k = weighttab.i0 * this.componentCount + j; n8 < n6 && k < nArray4.length; ++n8, k += this.componentCount) {
                            n7 += weighttab.weights[n8] * nArray4[k];
                        }
                        nArray5[n++] = n7 >> nArray2[j];
                    }
                }
            }
        }

        protected void shift(int[] nArray) {
            int[] nArray2 = this.tmp;
            for (int i = 0; i < this.componentCount; ++i) {
                nArray2[i] = 1 << nArray[i] - 1;
            }
            int[] nArray3 = this.data;
            int n = 0;
            while (n < nArray3.length) {
                int n2 = 0;
                while (n2 < this.componentCount) {
                    int n3 = nArray3[n] + nArray2[n2] >> nArray[n2];
                    nArray3[n] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
                    ++n2;
                    ++n;
                }
            }
        }

        protected void store(int n, int n2) {
            this.dstRaster.setPixels(n, n2, this.length, 1, this.data);
        }
    }

    protected static final class ByteBGRScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;

        protected ByteBGRScanline(Raster raster, WritableRaster writableRaster, int n) {
            super(n);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.data = new int[3 * n];
        }

        protected void accumulate(int n, Scanline scanline) {
            ByteBGRScanline byteBGRScanline = (ByteBGRScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = byteBGRScanline.data;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = i;
                nArray2[n2] = nArray2[n2] + n * nArray[i];
            }
        }

        protected void clear() {
            int[] nArray = this.data;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
        }

        protected void fetch(int n, int n2) {
            this.srcRaster.getPixels(n, n2, this.length, 1, this.data);
        }

        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            ByteBGRScanline byteBGRScanline = (ByteBGRScanline)scanline;
            int n = scanline.length;
            int[] nArray3 = new int[]{1 << nArray2[0] - 1, 1 << nArray2[1] - 1, 1 << nArray2[2] - 1};
            int[] nArray4 = this.data;
            int[] nArray5 = byteBGRScanline.data;
            if (nArray[0] != 0 || nArray[1] != 0 || nArray[2] != 0) {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    int n3;
                    Weighttab weighttab = weighttabArray[i];
                    int n4 = weighttab.weights.length;
                    int n5 = nArray3[0];
                    int n6 = nArray3[1];
                    int n7 = nArray3[2];
                    int n8 = weighttab.i0 * 3;
                    for (n3 = 0; n3 < n4 && n8 < nArray4.length; ++n3) {
                        int n9 = weighttab.weights[n3];
                        n5 += n9 * (nArray4[n8++] >> nArray[0]);
                        n6 += n9 * (nArray4[n8++] >> nArray[1]);
                        n7 += n9 * (nArray4[n8++] >> nArray[2]);
                    }
                    n3 = n5 >> nArray2[0];
                    nArray5[n2++] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
                    n3 = n6 >> nArray2[1];
                    nArray5[n2++] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
                    n3 = n7 >> nArray2[2];
                    nArray5[n2++] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
                }
            } else {
                int n10 = 0;
                for (int i = 0; i < n; ++i) {
                    Weighttab weighttab = weighttabArray[i];
                    int n11 = weighttab.weights.length;
                    int n12 = nArray3[0];
                    int n13 = nArray3[1];
                    int n14 = nArray3[2];
                    int n15 = weighttab.i0 * 3;
                    for (int j = 0; j < n11 && n15 < nArray4.length; ++j) {
                        int n16 = weighttab.weights[j];
                        n12 += n16 * nArray4[n15++];
                        n13 += n16 * nArray4[n15++];
                        n14 += n16 * nArray4[n15++];
                    }
                    nArray5[n10++] = n12 >> nArray2[0];
                    nArray5[n10++] = n13 >> nArray2[1];
                    nArray5[n10++] = n14 >> nArray2[2];
                }
            }
        }

        protected void shift(int[] nArray) {
            int[] nArray2 = new int[]{1 << nArray[0] - 1, 1 << nArray[1] - 1, 1 << nArray[2] - 1};
            int[] nArray3 = this.data;
            int n = 0;
            while (n < nArray3.length) {
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = nArray3[n] + nArray2[n2] >> nArray[n2];
                    nArray3[n] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
                    ++n2;
                    ++n;
                }
            }
        }

        protected void store(int n, int n2) {
            this.dstRaster.setPixels(n, n2, this.length, 1, this.data);
        }
    }

    public static interface ScanlineFilter {
        public void filter(int var1, int var2, int var3, Object var4, int var5);
    }
}

