/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.connect.tools.report.ReportWriter;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class ReportConfiguration
extends SimpleContributionRegistry<Contribution>
implements Iterable<Contribution> {
    public String getContributionId(Contribution contrib) {
        return contrib.name;
    }

    public boolean isSupportingMerge() {
        return true;
    }

    public void merge(Contribution src, Contribution dst) {
        dst.writer = src.writer;
        dst.enabled = src.enabled;
    }

    public Contribution clone(Contribution orig) {
        Contribution clone = new Contribution();
        clone.name = orig.name;
        clone.writer = orig.writer;
        clone.enabled = orig.enabled;
        return clone;
    }

    @Override
    public Iterator<Contribution> iterator() {
        return new FilteredIterator(Filter.enabled);
    }

    Iterator<Contribution> iterator(Set<String> names) {
        if (names.isEmpty()) {
            return this.iterator();
        }
        class OfNames
        implements Filter {
            final Set<String> names;

            OfNames(Set<String> names) {
                this.names = names;
            }

            @Override
            public boolean accept(Contribution contribution) {
                return enabled.accept(contribution) && this.names.contains(contribution.name);
            }
        }
        return new FilteredIterator(new OfNames(names));
    }

    @XObject(value="report")
    public static class Contribution {
        @XNode(value="@name")
        String name = "noop";
        @XNode(value="@enabled")
        boolean enabled = true;
        ReportWriter writer;

        @XNode(value="@oftype")
        public void oftype(Class<? extends ReportWriter> typeof) throws ReflectiveOperationException {
            this.writer = typeof.newInstance();
        }
    }

    class FilteredIterator
    implements Iterator<Contribution> {
        final Filter filter;
        final Iterator<Contribution> iterator;
        Contribution next;

        FilteredIterator(Filter filter) {
            this.iterator = ReportConfiguration.this.currentContribs.values().iterator();
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            return this.fetch();
        }

        boolean fetch() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.filter.accept(this.next)) continue;
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public Contribution next() {
            if (!this.fetch()) {
                throw new NoSuchElementException("no more reports");
            }
            try {
                Contribution contribution = this.next;
                return contribution;
            }
            finally {
                this.next = null;
            }
        }
    }

    static interface Filter {
        public static final Filter enabled = new Filter(){

            @Override
            public boolean accept(Contribution contribution) {
                return contribution.enabled;
            }
        };

        public boolean accept(Contribution var1);
    }
}

