/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.ImageIOUtil;
import org.apache.pdfbox.util.PageExtractor;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.runtime.api.Framework;

public class PDFPageExtractor {
    private Blob pdfBlob;
    private String password;

    public PDFPageExtractor(Blob inBlob) {
        this.pdfBlob = inBlob;
    }

    public PDFPageExtractor(DocumentModel inDoc, String inXPath) {
        if (StringUtils.isBlank((String)inXPath)) {
            inXPath = "file:content";
        }
        this.pdfBlob = (Blob)inDoc.getPropertyValue(inXPath);
    }

    public Blob extract(int inStartPage, int inEndPage) {
        return this.extract(inStartPage, inEndPage, null, null, null, null);
    }

    private String getFileName(Blob blob) {
        String originalName = blob.getFilename();
        if (StringUtils.isBlank((String)originalName)) {
            return "extracted";
        }
        int pos = originalName.toLowerCase().lastIndexOf(".pdf");
        if (pos > 0) {
            originalName = originalName.substring(0, pos);
        }
        return originalName;
    }

    public Blob extract(int inStartPage, int inEndPage, String inFileName, String inTitle, String inSubject, String inAuthor) throws NuxeoException {
        FileBlob result;
        PDDocument extracted = null;
        try (PDDocument pdfDoc = PDFUtils.load(this.pdfBlob, this.password);){
            PageExtractor pe = new PageExtractor(pdfDoc, inStartPage, inEndPage);
            extracted = pe.extract();
            PDFUtils.setInfos(extracted, inTitle, inSubject, inAuthor);
            result = PDFUtils.saveInTempFile(extracted);
            result.setMimeType("application/pdf");
            if (StringUtils.isBlank((String)inFileName)) {
                inFileName = this.getFileName(this.pdfBlob) + "-" + inStartPage + "-" + inEndPage + ".pdf";
            }
            result.setFilename(inFileName);
            extracted.close();
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException("Failed to extract the pages", e);
        }
        return result;
    }

    public BlobList getPagesAsImages(String inFileName) throws NuxeoException {
        ImageIO.scanForPlugins();
        BlobList results = new BlobList();
        if (StringUtils.isBlank((String)inFileName)) {
            inFileName = this.getFileName(this.pdfBlob) + ".pdf";
        }
        try (PDDocument pdfDoc = PDFUtils.load(this.pdfBlob, this.password);){
            List pages = pdfDoc.getDocumentCatalog().getAllPages();
            for (Object pageObject : pages) {
                PDPage page = (PDPage)pageObject;
                String resultFileName = inFileName + "-" + (pages.indexOf(page) + 1);
                BufferedImage bim = page.convertToImage(1, 300);
                File resultFile = Framework.createTempFile((String)resultFileName, (String)".png");
                FileOutputStream resultFileStream = new FileOutputStream(resultFile);
                ImageIOUtil.writeImage((BufferedImage)bim, (String)"png", (OutputStream)resultFileStream, (int)300);
                FileBlob result = new FileBlob(resultFile);
                result.setFilename(resultFileName + ".png");
                result.setMimeType("picture/png");
                results.add((Object)result);
                Framework.trackFile((File)resultFile, (Object)result);
            }
            pdfDoc.close();
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to extract the pages", (Throwable)e);
        }
        return results;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

