/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.runtime.api.Framework;

public class VCSLockManager
implements LockManager {
    private static final Log log = LogFactory.getLog(VCSLockManager.class);
    public static final int LOCK_RETRIES = 10;
    public static final long LOCK_SLEEP_DELAY = 1L;
    public static final long LOCK_SLEEP_INCREMENT = 50L;
    protected final RepositoryImpl repository;
    protected Mapper mapper;
    protected final boolean clusteringEnabled;
    protected final ReentrantLock serializationLock;
    protected static final Lock NULL_LOCK = new Lock(null, null);
    protected final boolean caching;
    protected final LRUCache<Serializable, Lock> lockCache;
    protected static final int CACHE_SIZE = 100;

    public VCSLockManager(String repositoryName) {
        SQLRepositoryService repositoryService = (SQLRepositoryService)((Object)Framework.getService(SQLRepositoryService.class));
        this.repository = repositoryService.getRepositoryImpl(repositoryName);
        this.clusteringEnabled = this.repository.getRepositoryDescriptor().getClusteringEnabled();
        this.serializationLock = new ReentrantLock();
        this.caching = !this.clusteringEnabled;
        this.lockCache = this.caching ? new LRUCache(100) : null;
    }

    protected Mapper getMapper() {
        if (this.mapper == null) {
            this.mapper = this.repository.newMapper(null, false);
        }
        return this.mapper;
    }

    protected Serializable idFromString(String id) {
        return this.repository.getModel().idFromString(id);
    }

    public void closeLockManager() {
        this.serializationLock.lock();
        try {
            if (this.mapper != null) {
                this.getMapper().close();
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(String id) {
        this.serializationLock.lock();
        try {
            Lock lock;
            if (this.caching && (lock = (Lock)this.lockCache.get(id)) != null) {
                Lock lock2 = lock == NULL_LOCK ? null : lock;
                return lock2;
            }
            lock = this.getMapper().getLock(this.idFromString(id));
            if (this.caching) {
                this.lockCache.put((Serializable)((Object)id), lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = lock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public Lock setLock(String id, Lock lock) {
        ArrayList<NuxeoException> suppressed = new ArrayList<NuxeoException>(0);
        long sleepDelay = 1L;
        for (int i = 0; i < 10; ++i) {
            if (i > 0) {
                log.debug((Object)("Retrying lock on " + id + ": try " + (i + 1)));
            }
            try {
                return this.setLockInternal(id, lock);
            }
            catch (NuxeoException e) {
                suppressed.add(e);
                if (this.shouldRetry((Exception)((Object)e))) {
                    try {
                        Thread.sleep(sleepDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interruptedException);
                    }
                    sleepDelay += 50L;
                    continue;
                }
                NuxeoException nuxeoException = new NuxeoException((Throwable)e);
                for (Throwable throwable : suppressed) {
                    nuxeoException.addSuppressed(throwable);
                }
                throw nuxeoException;
            }
        }
        LockException exception = new LockException("Failed to lock " + id + ", too much concurrency (tried " + 10 + " times)");
        for (Throwable throwable : suppressed) {
            exception.addSuppressed(throwable);
        }
        throw exception;
    }

    protected boolean shouldRetry(Exception e) {
        if (e instanceof ConcurrentUpdateException) {
            return true;
        }
        Throwable t = e.getCause();
        if (t instanceof BatchUpdateException && t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SQLException && this.shouldRetry((SQLException)t);
    }

    protected boolean shouldRetry(SQLException e) {
        String sqlState = e.getSQLState();
        if ("23000".equals(sqlState)) {
            return true;
        }
        if ("23001".equals(sqlState)) {
            return true;
        }
        if ("23505".equals(sqlState)) {
            return true;
        }
        return "S0003".equals(sqlState) || "S0005".equals(sqlState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock setLockInternal(String id, Lock lock) {
        this.serializationLock.lock();
        try {
            Lock oldLock;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) != null && oldLock != NULL_LOCK) {
                Lock lock2 = oldLock;
                return lock2;
            }
            oldLock = this.getMapper().setLock(this.idFromString(id), lock);
            if (this.caching && oldLock == null) {
                this.lockCache.put((Serializable)((Object)id), lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = oldLock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock removeLock(String id, String owner) {
        this.serializationLock.lock();
        try {
            Lock oldLock = null;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) == NULL_LOCK) {
                Lock lock = null;
                return lock;
            }
            if (oldLock != null && !LockManager.canLockBeRemoved((String)oldLock.getOwner(), (String)owner)) {
                oldLock = new Lock(oldLock, true);
            } else if (oldLock == null) {
                oldLock = this.getMapper().removeLock(this.idFromString(id), owner, false);
            } else {
                this.getMapper().removeLock(this.idFromString(id), owner, true);
            }
            if (this.caching) {
                if (oldLock != null && oldLock.getFailed()) {
                    this.lockCache.put((Serializable)((Object)id), new Lock(oldLock, false));
                } else {
                    this.lockCache.put((Serializable)((Object)id), NULL_LOCK);
                }
            }
            Lock lock = oldLock;
            return lock;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public void clearLockManagerCaches() {
        this.serializationLock.lock();
        try {
            if (this.caching) {
                this.lockCache.clear();
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.repository.getName() + ')';
    }

    protected static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int max;

        public LRUCache(int max) {
            super(max, 1.0f, true);
            this.max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.max;
        }
    }
}

