/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentProxy;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.runtime.api.Framework;

public class SQLSession
implements org.nuxeo.ecm.core.model.Session {
    protected final Log log = LogFactory.getLog(SQLSession.class);
    public static final String ALLOW_NEGATIVE_ACL_PROPERTY = "nuxeo.security.allowNegativeACL";
    public static final String COPY_FINDFREENAME_DISABLED_PROP = "nuxeo.vcs.copy.findFreeName.disabled";
    private final Repository repository;
    private final Session session;
    private Document root;
    private final boolean negativeAclAllowed;
    private final boolean copyFindFreeNameDisabled;
    private static final Pattern dotDigitsPattern = Pattern.compile("(.*)\\.[0-9]+$");
    protected static final Pattern ORDER_BY_PATH_ASC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s*$", 34);
    protected static final Pattern ORDER_BY_PATH_DESC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s+DESC\\s*$", 34);

    public SQLSession(Session session, Repository repository) {
        this.session = session;
        this.repository = repository;
        Node rootNode = session.getRootNode();
        this.root = this.newDocument(rootNode);
        this.negativeAclAllowed = Framework.isBooleanPropertyTrue((String)ALLOW_NEGATIVE_ACL_PROPERTY);
        this.copyFindFreeNameDisabled = Framework.isBooleanPropertyTrue((String)COPY_FINDFREENAME_DISABLED_PROP);
    }

    public Document getRootDocument() {
        return this.root;
    }

    public Document getNullDocument() {
        return new SQLDocumentLive(null, null, this, true);
    }

    public void close() {
        this.root = null;
        try {
            this.session.close();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        this.session.save();
    }

    public boolean isLive() {
        return this.session != null && this.session.isLive();
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    protected String idToString(Serializable id) {
        return this.session.getModel().idToString(id);
    }

    protected Serializable idFromString(String id) {
        return this.session.getModel().idFromString(id);
    }

    public ScrollResult scroll(String query, int batchSize, int keepAliveSeconds) {
        return this.session.scroll(query, batchSize, keepAliveSeconds);
    }

    public ScrollResult scroll(String scrollId) {
        return this.session.scroll(scrollId);
    }

    public Document getDocumentByUUID(String uuid) throws DocumentNotFoundException {
        Document doc = this.getDocumentById(this.idFromString(uuid));
        if (doc == null) {
            throw new DocumentNotFoundException(uuid);
        }
        return doc;
    }

    public Document resolvePath(String path) throws DocumentNotFoundException {
        Node node;
        Document doc;
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((doc = this.newDocument(node = this.session.getNodeByPath(path, this.session.getRootNode()))) == null) {
            throw new DocumentNotFoundException(path);
        }
        return doc;
    }

    protected void orderBefore(Node node, Node src, Node dest) {
        this.session.orderBefore(node, src, dest);
    }

    public Document move(Document source, Document parent, String name) {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        if (name == null) {
            name = source.getName();
        }
        Node result = this.session.move(((SQLDocument)source).getNode(), ((SQLDocument)parent).getNode(), name);
        return this.newDocument(result);
    }

    protected String findFreeName(Node parentNode, String name) {
        if (this.session.hasChildNode(parentNode, name, false)) {
            Matcher m = dotDigitsPattern.matcher(name);
            if (m.matches()) {
                name = m.group(1);
            }
            name = name + "." + System.nanoTime();
        }
        return name;
    }

    public Document copy(Document source, Document parent, String name) {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        if (name == null) {
            name = source.getName();
        }
        Node parentNode = ((SQLDocument)parent).getNode();
        if (!this.copyFindFreeNameDisabled) {
            name = this.findFreeName(parentNode, name);
        }
        Node copy = this.session.copy(((SQLDocument)source).getNode(), parentNode, name);
        return this.newDocument(copy);
    }

    public Document getVersion(String versionableId, VersionModel versionModel) {
        Serializable vid = this.idFromString(versionableId);
        Node versionNode = this.session.getVersionByLabel(vid, versionModel.getLabel());
        if (versionNode == null) {
            return null;
        }
        versionModel.setDescription(versionNode.getSimpleProperty("ecm:versionDescription").getString());
        versionModel.setCreated((Calendar)versionNode.getSimpleProperty("ecm:versionCreated").getValue());
        return this.newDocument(versionNode);
    }

    public Document createProxy(Document doc, Document folder) {
        Serializable versionableId;
        Node folderNode = ((SQLDocument)folder).getNode();
        Node targetNode = ((SQLDocument)doc).getNode();
        Serializable targetId = targetNode.getId();
        if (doc.isVersion()) {
            versionableId = targetNode.getSimpleProperty("ecm:versionableId").getValue();
        } else if (doc.isProxy()) {
            targetId = targetNode.getSimpleProperty("ecm:proxyTargetId").getValue();
            versionableId = targetNode.getSimpleProperty("ecm:proxyVersionableId").getValue();
        } else {
            versionableId = targetId;
        }
        String name = this.findFreeName(folderNode, doc.getName());
        Node proxy = this.session.addProxy(targetId, versionableId, folderNode, name, null);
        return this.newDocument(proxy);
    }

    public List<Document> getProxies(Document document, Document parent) {
        List<Node> proxyNodes = this.session.getProxies(((SQLDocument)document).getNode(), parent == null ? null : ((SQLDocument)parent).getNode());
        ArrayList<Document> proxies = new ArrayList<Document>(proxyNodes.size());
        for (Node proxyNode : proxyNodes) {
            proxies.add(this.newDocument(proxyNode));
        }
        return proxies;
    }

    public void setProxyTarget(Document proxy, Document target) {
        Node proxyNode = ((SQLDocument)proxy).getNode();
        Serializable targetId = this.idFromString(target.getUUID());
        this.session.setProxyTarget(proxyNode, targetId);
    }

    public Document importDocument(String uuid, Document parent, String name, String typeName, Map<String, Serializable> properties) {
        Node parentNode;
        boolean isProxy = typeName.equals("ecm:proxy");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        Long pos = null;
        if (!isProxy) {
            Serializable importLockCreatedProp;
            props.put("ecm:lifeCyclePolicy", properties.get("ecm:lifeCyclePolicy"));
            props.put("ecm:lifeCycleState", properties.get("ecm:lifeCycleState"));
            Serializable importLockOwnerProp = properties.get("ecm:lockOwner");
            if (importLockOwnerProp != null) {
                props.put("ecm:lockOwner", importLockOwnerProp);
            }
            if ((importLockCreatedProp = properties.get("ecm:lockCreated")) != null) {
                props.put("ecm:lockCreated", importLockCreatedProp);
            }
            props.put("ecm:majorVersion", properties.get("ecm:majorVersion"));
            props.put("ecm:minorVersion", properties.get("ecm:minorVersion"));
            props.put("ecm:isVersion", properties.get("ecm:isVersion"));
        }
        if (parent == null) {
            parentNode = null;
            props.put("ecm:versionableId", this.idFromString((String)((Object)properties.get("ecm:versionableId"))));
            props.put("ecm:versionCreated", properties.get("ecm:versionCreated"));
            props.put("ecm:versionLabel", properties.get("ecm:versionLabel"));
            props.put("ecm:versionDescription", properties.get("ecm:versionDescription"));
            props.put("ecm:isLatestVersion", properties.get("ecm:isLatestVersion"));
            props.put("ecm:isLatestMajorVersion", properties.get("ecm:isLatestMajorVersion"));
        } else {
            parentNode = ((SQLDocument)parent).getNode();
            if (isProxy) {
                props.put("ecm:proxyTargetId", this.idFromString((String)((Object)properties.get("ecm:proxyTargetId"))));
                props.put("ecm:proxyVersionableId", this.idFromString((String)((Object)properties.get("ecm:proxyVersionableId"))));
            } else {
                props.put("ecm:baseVersion", this.idFromString((String)((Object)properties.get("ecm:baseVersionId"))));
                props.put("ecm:isCheckedIn", properties.get("ecm:isCheckedIn"));
            }
        }
        return this.importChild(uuid, parentNode, name, pos, typeName, props);
    }

    public PartialList<Document> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        Matcher matcher = ORDER_BY_PATH_ASC.matcher(query);
        Boolean orderByPath = matcher.matches() ? Boolean.TRUE : ((matcher = ORDER_BY_PATH_DESC.matcher(query)).matches() ? Boolean.FALSE : null);
        long limit = 0L;
        long offset = 0L;
        if (orderByPath != null) {
            query = matcher.group(1);
            limit = queryFilter.getLimit();
            offset = queryFilter.getOffset();
            queryFilter = QueryFilter.withoutLimitOffset((QueryFilter)queryFilter);
        }
        PartialList<Serializable> pl = this.session.query(query, queryType, queryFilter, countUpTo);
        List<Document> list = this.getDocumentsById(pl.list);
        if (orderByPath != null) {
            Collections.sort(list, new PathComparator(orderByPath));
        }
        if (limit != 0L) {
            int size = list.size();
            list.subList(0, (int)(offset > (long)size ? (long)size : offset)).clear();
            size = list.size();
            if (limit < (long)size) {
                list.subList((int)limit, size).clear();
            }
        }
        return new PartialList(list, pl.totalSize);
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, Object[] params) {
        return this.session.queryAndFetch(query, queryType, queryFilter, distinctDocuments, params);
    }

    public PartialList<Map<String, Serializable>> queryProjection(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, long countUpTo, Object[] params) {
        return this.session.queryProjection(query, queryType, queryFilter, distinctDocuments, countUpTo, params);
    }

    private Document newDocument(Node node) {
        return this.newDocument(node, true);
    }

    private Document newDocument(Node node, boolean readonly) {
        SchemaManager schemaManager;
        DocumentType type;
        if (node == null) {
            return null;
        }
        Node targetNode = null;
        String typeName = node.getPrimaryType();
        if (node.isProxy()) {
            Serializable targetId = node.getSimpleProperty("ecm:proxyTargetId").getValue();
            if (targetId == null) {
                throw new DocumentNotFoundException("Proxy has null target");
            }
            targetNode = this.session.getNodeById(targetId);
            typeName = targetNode.getPrimaryType();
        }
        if ((type = (schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType(typeName)) == null) {
            throw new DocumentNotFoundException("Unknown document type: " + typeName);
        }
        if (node.isProxy()) {
            SQLDocumentLive proxy = new SQLDocumentLive(node, (ComplexType)type, this, false);
            Document target = this.newDocument(targetNode, readonly);
            return new SQLDocumentProxy(proxy, target);
        }
        if (node.isVersion()) {
            return new SQLDocumentVersion(node, (ComplexType)type, this, readonly);
        }
        return new SQLDocumentLive(node, (ComplexType)type, this, false);
    }

    protected Document getDocumentById(Serializable id) {
        Node node = this.session.getNodeById(id);
        return node == null ? null : this.newDocument(node);
    }

    protected List<Document> getDocumentsById(List<Serializable> ids) {
        ArrayList<Document> docs = new ArrayList<Document>(ids.size());
        List<Node> nodes = this.session.getNodesByIds(ids);
        for (int index = 0; index < ids.size(); ++index) {
            Document doc;
            Node eachNode = nodes.get(index);
            if (eachNode == null) {
                if (!this.log.isTraceEnabled()) continue;
                Serializable id = ids.get(index);
                this.log.trace((Object)("Cannot fetch document with id: " + id), new Throwable("debug stack trace"));
                continue;
            }
            try {
                doc = this.newDocument(eachNode);
            }
            catch (DocumentNotFoundException e) {
                continue;
            }
            docs.add(doc);
        }
        return docs;
    }

    protected Document getParent(Node node) {
        return this.newDocument(this.session.getParentNode(node));
    }

    protected String getPath(Node node) {
        return this.session.getPath(node);
    }

    protected Document getChild(Node node, String name) throws DocumentNotFoundException {
        Node childNode = this.session.getChildNode(node, name, false);
        Document doc = this.newDocument(childNode);
        if (doc == null) {
            throw new DocumentNotFoundException(name);
        }
        return doc;
    }

    protected Node getChildProperty(Node node, String name, String typeName) {
        return this.session.getChildNode(node, name, true);
    }

    protected Node getChildPropertyForWrite(Node node, String name, String typeName) {
        Node childNode = this.getChildProperty(node, name, typeName);
        if (childNode == null) {
            childNode = this.session.addChildNode(node, name, null, typeName, true);
        }
        return childNode;
    }

    protected List<Document> getChildren(Node node) {
        List<Node> nodes = this.session.getChildren(node, null, false);
        ArrayList<Document> children = new ArrayList<Document>(nodes.size());
        for (Node n : nodes) {
            try {
                children.add(this.newDocument(n));
            }
            catch (DocumentNotFoundException e) {}
        }
        return children;
    }

    protected boolean hasChild(Node node, String name) {
        return this.session.hasChildNode(node, name, false);
    }

    protected boolean hasChildren(Node node) {
        return this.session.hasChildren(node, false);
    }

    protected Document addChild(Node parent, String name, Long pos, String typeName) {
        return this.newDocument(this.session.addChildNode(parent, name, pos, typeName, false));
    }

    protected Node addChildProperty(Node parent, String name, Long pos, String typeName) {
        return this.session.addChildNode(parent, name, pos, typeName, true);
    }

    protected Document importChild(String uuid, Node parent, String name, Long pos, String typeName, Map<String, Serializable> props) {
        Serializable id = this.idFromString(uuid);
        Node node = this.session.addChildNode(id, parent, name, pos, typeName, false);
        for (Map.Entry<String, Serializable> entry : props.entrySet()) {
            node.setSimpleProperty(entry.getKey(), entry.getValue());
        }
        return this.newDocument(node, false);
    }

    protected boolean addMixinType(Node node, String mixin) {
        return this.session.addMixinType(node, mixin);
    }

    protected boolean removeMixinType(Node node, String mixin) {
        return this.session.removeMixinType(node, mixin);
    }

    protected List<Node> getComplexList(Node node, String name) {
        List<Node> nodes = this.session.getChildren(node, name, true);
        return nodes;
    }

    protected void remove(Node node) {
        this.session.removeNode(node);
    }

    protected void removeProperty(Node node) {
        this.session.removePropertyNode(node);
    }

    protected Document checkIn(Node node, String label, String checkinComment) {
        Node versionNode = this.session.checkIn(node, label, checkinComment);
        return versionNode == null ? null : this.newDocument(versionNode);
    }

    protected void checkOut(Node node) {
        this.session.checkOut(node);
    }

    protected void restore(Node node, Node version) {
        this.session.restore(node, version);
    }

    protected Document getVersionByLabel(String versionSeriesId, String label) {
        Serializable vid = this.idFromString(versionSeriesId);
        Node versionNode = this.session.getVersionByLabel(vid, label);
        return versionNode == null ? null : this.newDocument(versionNode);
    }

    protected List<Document> getVersions(String versionSeriesId) {
        Serializable vid = this.idFromString(versionSeriesId);
        List<Node> versionNodes = this.session.getVersions(vid);
        ArrayList<Document> versions = new ArrayList<Document>(versionNodes.size());
        for (Node versionNode : versionNodes) {
            versions.add(this.newDocument(versionNode));
        }
        return versions;
    }

    public Document getLastVersion(String versionSeriesId) {
        Serializable vid = this.idFromString(versionSeriesId);
        Node versionNode = this.session.getLastVersion(vid);
        if (versionNode == null) {
            return null;
        }
        return this.newDocument(versionNode);
    }

    protected Node getNodeById(Serializable id) {
        return this.session.getNodeById(id);
    }

    public LockManager getLockManager() {
        return this.session.getLockManager();
    }

    public boolean isNegativeAclAllowed() {
        return this.negativeAclAllowed;
    }

    public void setACP(Document doc, ACP acp, boolean overwrite) {
        Object[] aclrows;
        if (!overwrite && acp == null) {
            return;
        }
        this.checkNegativeAcl(acp);
        Node node = ((SQLDocument)doc).getNode();
        if (overwrite) {
            aclrows = acp == null ? null : SQLSession.acpToAclRows(acp);
        } else {
            aclrows = (ACLRow[])node.getCollectionProperty("ecm:acl").getValue();
            aclrows = SQLSession.updateAclRows((ACLRow[])aclrows, acp);
        }
        node.getCollectionProperty("ecm:acl").setValue(aclrows);
        this.session.requireReadAclsUpdate();
    }

    protected void checkNegativeAcl(ACP acp) {
        if (this.negativeAclAllowed) {
            return;
        }
        if (acp == null) {
            return;
        }
        for (ACL acl : acp.getACLs()) {
            if (acl.getName().equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                String permission;
                if (ace.isGranted() || (permission = ace.getPermission()).equals("Everything") && ace.getUsername().equals("Everyone") || permission.equals("Write")) continue;
                throw new IllegalArgumentException("Negative ACL not allowed: " + ace);
            }
        }
    }

    public ACP getMergedACP(Document doc) {
        Document base;
        Document document = base = doc.isVersion() ? doc.getSourceDocument() : doc;
        if (base == null) {
            return null;
        }
        ACP acp = this.getACP(base);
        if (doc.getParent() == null) {
            return acp;
        }
        ACL acl = null;
        if (acp == null || acp.getAccess("Everyone", "Everything") != Access.DENY) {
            acl = this.getInheritedACLs(doc);
        }
        if (acp == null) {
            if (acl == null) {
                return null;
            }
            acp = new ACPImpl();
        }
        if (acl != null) {
            acp.addACL(acl);
        }
        return acp;
    }

    protected ACP getACP(Document doc) {
        Node node = ((SQLDocument)doc).getNode();
        ACLRow[] aclrows = (ACLRow[])node.getCollectionProperty("ecm:acl").getValue();
        return SQLSession.aclRowsToACP(aclrows);
    }

    protected static ACP aclRowsToACP(ACLRow[] acls) {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = null;
        String name = null;
        for (ACLRow aclrow : acls) {
            String user;
            if (!aclrow.name.equals(name)) {
                if (acl != null) {
                    acp.addACL(acl);
                }
                name = aclrow.name;
                acl = new ACLImpl(name);
            }
            if ((user = aclrow.user) == null) {
                user = aclrow.group;
            }
            acl.add(ACE.builder((String)user, (String)aclrow.permission).isGranted(aclrow.grant).creator(aclrow.creator).begin(aclrow.begin).end(aclrow.end).build());
        }
        if (acl != null) {
            acp.addACL(acl);
        }
        return acp;
    }

    protected static ACLRow[] acpToAclRows(ACP acp) {
        LinkedList<ACLRow> aclrows = new LinkedList<ACLRow>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if (name.equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                SQLSession.addACLRow(aclrows, name, ace);
            }
        }
        ACLRow[] array = new ACLRow[aclrows.size()];
        return aclrows.toArray(array);
    }

    protected static ACLRow[] updateAclRows(ACLRow[] aclrows, ACP acp) {
        LinkedList<ACLRow> newaclrows = new LinkedList<ACLRow>();
        HashMap<String, ACLRow[]> aclmap = new HashMap<String, ACLRow[]>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if ("inherited".equals(name)) continue;
            aclmap.put(name, (ACLRow[])acl);
        }
        LinkedList<ACE> aces = Collections.emptyList();
        HashSet<String> aceKeys = null;
        String name = null;
        for (ACLRow aclrow : aclrows) {
            if (!aclrow.name.equals(name)) {
                for (ACE aCE : aces) {
                    SQLSession.addACLRow(newaclrows, name, aCE);
                }
                name = aclrow.name;
                ACL acl = (ACL)aclmap.remove(name);
                aces = acl == null ? Collections.emptyList() : new LinkedList<ACE>(Arrays.asList(acl.getACEs()));
                aceKeys = new HashSet<String>();
                for (ACE ace3 : aces) {
                    aceKeys.add(SQLSession.getACEkey(ace3));
                }
            }
            if (aceKeys.contains(SQLSession.getACLrowKey(aclrow))) continue;
            newaclrows.add(new ACLRow(newaclrows.size(), name, aclrow.grant, aclrow.permission, aclrow.user, aclrow.group, aclrow.creator, aclrow.begin, aclrow.end, aclrow.status));
        }
        for (ACE ace : aces) {
            SQLSession.addACLRow(newaclrows, name, ace);
        }
        for (ACL acl : aclmap.values()) {
            name = acl.getName();
            for (ACE aCE : acl.getACEs()) {
                SQLSession.addACLRow(newaclrows, name, aCE);
            }
        }
        ACLRow[] array = new ACLRow[newaclrows.size()];
        return newaclrows.toArray(array);
    }

    protected static String getACEkey(ACE ace) {
        return ace.getUsername() + '|' + ace.getPermission();
    }

    protected static String getACLrowKey(ACLRow aclrow) {
        String user = aclrow.user;
        if (user == null) {
            user = aclrow.group;
        }
        return user + '|' + aclrow.permission;
    }

    protected static void addACLRow(List<ACLRow> aclrows, String name, ACE ace) {
        String user = ace.getUsername();
        if (user == null) {
            return;
        }
        String group = null;
        aclrows.add(new ACLRow(aclrows.size(), name, ace.isGranted(), ace.getPermission(), user, group, ace.getCreator(), ace.getBegin(), ace.getEnd(), ace.getLongStatus()));
    }

    protected ACL getInheritedACLs(Document doc) {
        ACL merged = null;
        for (doc = doc.getParent(); doc != null; doc = doc.getParent()) {
            ACP acp = this.getACP(doc);
            if (acp == null) continue;
            ACL acl = acp.getMergedACLs("inherited");
            if (merged == null) {
                merged = acl;
            } else {
                merged.addAll((Collection)acl);
            }
            if (acp.getAccess("Everyone", "Everything") == Access.DENY) break;
        }
        return merged;
    }

    public Map<String, String> getBinaryFulltext(String id) {
        return this.session.getBinaryFulltext(this.idFromString(id));
    }

    public boolean isChangeTokenEnabled() {
        return this.session.isChangeTokenEnabled();
    }

    public void markUserChange(Serializable id) {
        this.session.markUserChange(id);
    }

    public static class PathComparator
    implements Comparator<Document> {
        private final int sign;

        public PathComparator(boolean asc) {
            this.sign = asc ? 1 : -1;
        }

        @Override
        public int compare(Document doc1, Document doc2) {
            String p1 = doc1.getPath();
            String p2 = doc2.getPath();
            if (p1 == null && p2 == null) {
                return this.sign * doc1.getUUID().compareTo(doc2.getUUID());
            }
            if (p1 == null) {
                return this.sign;
            }
            if (p2 == null) {
                return -1 * this.sign;
            }
            return this.sign * p1.compareTo(p2);
        }
    }
}

