/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperConnector;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;

public class JDBCBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(JDBCBackend.class);
    private RepositoryImpl repository;
    private Dialect dialect;
    private SQLInfo sqlInfo;
    private boolean firstMapper = true;
    private Boolean initialized;
    private ClusterInvalidator clusterInvalidator;
    private boolean isPooledDataSource;

    @Override
    public void initialize(RepositoryImpl repository) {
        this.repository = repository;
        String dataSourceName = this.getDataSourceName();
        try {
            DataSource ds = DataSourceHelper.getDataSource((String)dataSourceName);
            if (ds instanceof PooledDataSourceRegistry.PooledDataSource) {
                this.isPooledDataSource = true;
            }
        }
        catch (NamingException cause) {
            throw new NuxeoException("Cannot acquire datasource: " + dataSourceName, (Throwable)cause);
        }
        try {
            Connection connection = ConnectionHelper.getConnection((String)dataSourceName);
            Throwable throwable = null;
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot get connection from datasource: " + dataSourceName, (Throwable)cause);
        }
    }

    @Override
    public void initializeModelSetup(ModelSetup modelSetup) {
        String dataSourceName = this.getDataSourceName();
        try (Connection connection = ConnectionHelper.getConnection((String)dataSourceName);){
            this.dialect = Dialect.createDialect(connection, this.repository.getRepositoryDescriptor());
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot connect to database", (Throwable)cause);
        }
        modelSetup.materializeFulltextSyntheticColumn = this.dialect.getMaterializeFulltextSyntheticColumn();
        modelSetup.supportsArrayColumns = this.dialect.supportsArrayColumns();
        switch (this.dialect.getIdType()) {
            case VARCHAR: 
            case UUID: {
                modelSetup.idType = Model.IdType.STRING;
                break;
            }
            case SEQUENCE: {
                modelSetup.idType = Model.IdType.LONG;
                break;
            }
            default: {
                throw new AssertionError((Object)this.dialect.getIdType().toString());
            }
        }
    }

    protected String getDataSourceName() {
        RepositoryDescriptor repositoryDescriptor = this.repository.getRepositoryDescriptor();
        return JDBCConnection.getDataSourceName(repositoryDescriptor.name);
    }

    @Override
    public void initializeModel(Model model) {
        this.sqlInfo = new SQLInfo(model, this.dialect);
    }

    @Override
    public void setClusterInvalidator(ClusterInvalidator clusterInvalidator) {
        this.clusterInvalidator = clusterInvalidator;
    }

    @Override
    public Mapper newMapper(Model model, Session.PathResolver pathResolver, boolean useInvalidations) {
        boolean noSharing = !useInvalidations;
        RepositoryDescriptor repositoryDescriptor = this.repository.getRepositoryDescriptor();
        ClusterInvalidator cnh = useInvalidations ? this.clusterInvalidator : null;
        Mapper mapper = new JDBCMapper(model, pathResolver, this.sqlInfo, cnh, this.repository);
        if (this.isPooledDataSource) {
            mapper = JDBCMapperConnector.newConnector(mapper, noSharing);
        } else {
            mapper.connect(false);
        }
        String repositoryName = this.repository.getName();
        if (Boolean.FALSE.equals(this.initialized)) {
            throw new NuxeoException("Database initialization failed previously for: " + repositoryName);
        }
        if (this.firstMapper) {
            this.initialized = Boolean.FALSE;
            this.firstMapper = false;
            String ddlMode = repositoryDescriptor.getDDLMode();
            if (ddlMode == null) {
                String string = ddlMode = repositoryDescriptor.getNoDDL() ? "ignore" : "execute";
            }
            if (ddlMode.equals("ignore")) {
                log.info((Object)"Skipping database creation");
            } else {
                mapper.createDatabase(ddlMode);
            }
            if (log.isDebugEnabled()) {
                FulltextDescriptor fulltextDescriptor = repositoryDescriptor.getFulltextDescriptor();
                log.debug((Object)String.format("Database ready, fulltext: disabled=%b searchDisabled=%b.", fulltextDescriptor.getFulltextDisabled(), fulltextDescriptor.getFulltextSearchDisabled()));
            }
            this.initialized = Boolean.TRUE;
        }
        return mapper;
    }

    @Override
    public void shutdown() {
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.close();
        }
    }
}

