/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManager;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class PoolingRepositoryFactory
implements RepositoryFactory {
    protected final String repositoryName;
    private static final String[] CM_NAMES_PREFIXES = new String[]{"java:comp/NuxeoConnectionManager/", "java:comp/env/NuxeoConnectionManager/", "java:NuxeoConnectionManager/"};

    public PoolingRepositoryFactory(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Object call() {
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)((Object)Framework.getLocalService(SQLRepositoryService.class));
        RepositoryDescriptor descriptor = sqlRepositoryService.getRepositoryDescriptor(this.repositoryName);
        ManagedConnectionFactoryImpl managedConnectionFactory = new ManagedConnectionFactoryImpl();
        managedConnectionFactory.setName(descriptor.name);
        try {
            NuxeoConnectionManagerConfiguration pool = descriptor.pool;
            if (pool == null) {
                pool = new NuxeoConnectionManagerConfiguration();
                pool.setName("repository/" + this.repositoryName);
            }
            ConnectionManager connectionManager = PoolingRepositoryFactory.lookupConnectionManager(pool);
            return managedConnectionFactory.createConnectionFactory(connectionManager);
        }
        catch (NamingException | ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    protected static ConnectionManager lookupConnectionManager(NuxeoConnectionManagerConfiguration pool) throws NamingException {
        String name = pool.getName();
        NuxeoConnectionManager cm = NuxeoContainer.getConnectionManager((String)name);
        if (cm != null) {
            return cm;
        }
        InitialContext context = new InitialContext();
        for (String prefix : CM_NAMES_PREFIXES) {
            try {
                cm = (ConnectionManager)context.lookup(prefix + name);
                if (cm == null) continue;
                return cm;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return NuxeoContainer.initConnectionManager((NuxeoConnectionManagerConfiguration)pool);
    }
}

