/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordReader
extends Thread {
    private final AtomicBoolean stopRequested;
    private final Object startMutex = new Object();

    private PasswordReader() {
        this.stopRequested = new AtomicBoolean(false);
        this.setName("Password Reader Thread");
        this.setDaemon(true);
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readPassword() throws LDAPException {
        try {
            Method consoleMethod = System.class.getMethod("console", new Class[0]);
            Object consoleObject = consoleMethod.invoke(null, new Object[0]);
            Method readPasswordMethod = consoleObject.getClass().getMethod("readPassword", new Class[0]);
            char[] pwChars = (char[])readPasswordMethod.invoke(consoleObject, new Object[0]);
            ByteStringBuffer buffer = new ByteStringBuffer();
            buffer.append(pwChars);
            Arrays.fill(pwChars, '\u0000');
            byte[] pwBytes = buffer.toByteArray();
            buffer.clear(true);
            return pwBytes;
        }
        catch (Exception e) {
            Debug.debugException(e);
            PasswordReader r = new PasswordReader();
            try {
                int byteRead;
                Object consoleObject = r.startMutex;
                synchronized (consoleObject) {
                    r.start();
                    r.startMutex.wait();
                }
                ByteStringBuffer buffer = new ByteStringBuffer();
                while ((byteRead = System.in.read()) >= 0 && byteRead != 10) {
                    if (byteRead == 13) {
                        int nextCharacter = System.in.read();
                        if (nextCharacter < 0 || byteRead == 10) break;
                        buffer.append((byte)byteRead);
                        buffer.append((byte)nextCharacter);
                        continue;
                    }
                    buffer.append((byte)byteRead);
                }
                byte[] pwBytes = buffer.toByteArray();
                buffer.clear(true);
                byte[] byArray = pwBytes;
                {
                    Object var8_15 = null;
                    r.stopRequested.set(true);
                }
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    Object var8_16 = null;
                    r.stopRequested.set(true);
                    throw throwable;
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_PW_READER_FAILURE.get(StaticUtils.getExceptionMessage(e2)), e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.startMutex;
        synchronized (object) {
            this.startMutex.notifyAll();
        }
        while (!this.stopRequested.get()) {
            System.out.print("\b ");
            PasswordReader.yield();
        }
    }
}

