/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryIteratorCopy
extends QueryIteratorBase {
    List<Binding> elements = new ArrayList<Binding>();
    QueryIterator iterator;
    QueryIterator original;

    public QueryIteratorCopy(QueryIterator qIter) {
        while (qIter.hasNext()) {
            this.elements.add(qIter.nextBinding());
        }
        qIter.close();
        this.iterator = this.copy();
        this.original = qIter;
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.iterator.nextBinding();
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("QueryIteratorCopy");
        out.incIndent();
        this.original.output(out, sCxt);
        out.decIndent();
    }

    public List<Binding> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    public QueryIterator copy() {
        return new QueryIterPlainWrapper(this.elements.iterator());
    }

    @Override
    protected void closeIterator() {
        this.iterator.close();
    }

    @Override
    protected void requestCancel() {
        this.iterator.cancel();
    }

    @Override
    protected boolean hasNextBinding() {
        return this.iterator.hasNext();
    }
}

