/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoSecuredRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthPreFilter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth2Filter
implements NuxeoAuthPreFilter {
    private static final Log log = LogFactory.getLog(NuxeoOAuth2Filter.class);
    public static final String ACCESS_TOKEN_PARAM = "access_token";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER_AUTHENTICATION_SCHEME = "Bearer ";
    protected OAuth2TokenStore tokenStore = new OAuth2TokenStore("org.nuxeo.server.token.store");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String accessToken = this.getAccessToken(httpRequest);
        if (accessToken != null) {
            this.processAuthentication(accessToken, httpRequest, httpResponse, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAuthentication(String accessToken, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        NuxeoOAuth2Token token = (NuxeoOAuth2Token)TransactionHelper.runInTransaction(() -> this.tokenStore.getToken(accessToken));
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        if (token == null || token.isExpired() || !clientService.hasClient(token.getClientId())) {
            response.setStatus(401);
            return;
        }
        LoginContext loginContext = this.buildLoginContext(token);
        if (loginContext != null) {
            Principal principal = (Principal)loginContext.getSubject().getPrincipals().toArray()[0];
            try {
                chain.doFilter((ServletRequest)new NuxeoSecuredRequestWrapper(request, principal), (ServletResponse)response);
            }
            finally {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    log.warn((Object)"Error when logging out", (Throwable)e);
                }
            }
        }
    }

    protected String getAccessToken(HttpServletRequest request) {
        String accessToken = request.getParameter(ACCESS_TOKEN_PARAM);
        String authorization = request.getHeader(AUTHORIZATION_HEADER);
        return StringUtils.isNotBlank((String)accessToken) ? accessToken : (authorization != null && authorization.startsWith(BEARER_AUTHENTICATION_SCHEME) ? authorization.substring(BEARER_AUTHENTICATION_SCHEME.length()).trim() : null);
    }

    protected LoginContext buildLoginContext(NuxeoOAuth2Token token) {
        try {
            return NuxeoAuthenticationFilter.loginAs((String)token.getNuxeoLogin());
        }
        catch (LoginException e) {
            log.warn((Object)"Error while authenticate user");
            return null;
        }
    }
}

