/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.oauth2.OAuth2Error;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.request.AuthorizationRequest;
import org.nuxeo.ecm.platform.oauth2.request.TokenRequest;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth2Servlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ENDPOINT_AUTH = "authorize";
    public static final String ENDPOINT_TOKEN = "token";
    public static final String ENDPOINT_AUTH_SUBMIT = "authorize_submit";
    public static final String AUTHORIZATION_KEY = "authorization_key";
    public static final String ERROR_PARAM = "error";
    public static final String ERROR_DESCRIPTION_PARAM = "error_description";
    public static final String CLIENT_NAME = "client_name";
    public static final String GRANT_JSP_PAGE_PATH = "/oauth2Grant.jsp";
    public static final String GRANT_ACCESS_PARAM = "grant_access";
    public static final String ERROR_JSP_PAGE_PATH = "/oauth2error.jsp";
    public static final int ACCESS_TOKEN_EXPIRATION_TIME = 3600000;
    protected OAuth2TokenStore tokenStore = new OAuth2TokenStore("org.nuxeo.server.token.store");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(ENDPOINT_AUTH)) {
            this.doGetAuthorize(request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(ENDPOINT_AUTH_SUBMIT)) {
            this.doPostAuthorizeSubmit(request, response);
        } else if (pathInfo.endsWith(ENDPOINT_TOKEN)) {
            this.doPostToken(request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doGetAuthorize(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AuthorizationRequest authRequest = AuthorizationRequest.fromRequest(request);
        OAuth2Error error = authRequest.checkError();
        if (error != null) {
            this.handleError(error, request, response);
            return;
        }
        AuthorizationRequest.store(authRequest.getAuthorizationKey(), authRequest);
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        request.setAttribute(AUTHORIZATION_KEY, (Object)authRequest.getAuthorizationKey());
        request.setAttribute(CLIENT_NAME, (Object)clientService.getClient(authRequest.getClientId()).getName());
        String state = request.getParameter("state");
        if (StringUtils.isNotBlank((String)state)) {
            request.setAttribute("state", (Object)state);
        }
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(GRANT_JSP_PAGE_PATH);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPostAuthorizeSubmit(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String authKeyForm = request.getParameter(AUTHORIZATION_KEY);
        AuthorizationRequest authRequest = AuthorizationRequest.get(authKeyForm);
        if (authRequest == null) {
            this.handleError(OAuth2Error.invalidRequest(String.format("Invalid %s: %s.", AUTHORIZATION_KEY, authKeyForm)), request, response);
            return;
        }
        AuthorizationRequest.remove(authRequest.getAuthorizationKey());
        OAuth2Error error = authRequest.checkError();
        if (error != null) {
            this.handleError(error, request, response);
            return;
        }
        String redirectURI = authRequest.getRedirectURI();
        if (StringUtils.isBlank((String)redirectURI)) {
            redirectURI = ((OAuth2ClientService)Framework.getService(OAuth2ClientService.class)).getClient(authRequest.getClientId()).getRedirectURIs().get(0);
        }
        String state = request.getParameter("state");
        String grantAccess = request.getParameter(GRANT_ACCESS_PARAM);
        if (grantAccess == null) {
            error = OAuth2Error.accessDenied();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(ERROR_PARAM, error.getId());
            String errorDescription = error.getDescription();
            if (StringUtils.isNotBlank((String)errorDescription)) {
                params.put(ERROR_DESCRIPTION_PARAM, errorDescription);
            }
            if (StringUtils.isNotBlank((String)state)) {
                params.put("state", state);
            }
            this.sendRedirect(request, response, redirectURI, params);
            return;
        }
        String authorizationCode = authRequest.getAuthorizationCode();
        AuthorizationRequest.store(authorizationCode, authRequest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authorizationCode);
        if (StringUtils.isNotBlank((String)state)) {
            params.put("state", state);
        }
        this.sendRedirect(request, response, redirectURI, params);
    }

    protected void doPostToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TokenRequest tokenRequest = new TokenRequest(request);
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        if ("authorization_code".equals(tokenRequest.getGrantType())) {
            AuthorizationRequest authRequest = AuthorizationRequest.get(tokenRequest.getCode());
            OAuth2Error error = null;
            if (authRequest == null) {
                error = OAuth2Error.accessDenied();
            } else if (!authRequest.getClientId().equals(tokenRequest.getClientId())) {
                error = OAuth2Error.accessDenied();
            } else {
                OAuth2Client client = clientService.getClient(authRequest.getClientId());
                if (client == null || !client.isValidWith(tokenRequest.getClientId(), tokenRequest.getClientSecret())) {
                    error = OAuth2Error.unauthorizedClient();
                } else {
                    String authRequestRedirectURI = authRequest.getRedirectURI();
                    if (StringUtils.isNotBlank((String)authRequestRedirectURI) && !authRequestRedirectURI.equals(tokenRequest.getRedirectURI())) {
                        error = OAuth2Error.invalidRequest();
                    }
                }
            }
            if (authRequest != null) {
                AuthorizationRequest.remove(authRequest.getAuthorizationCode());
            }
            if (error != null) {
                this.handleJsonError(error, response);
                return;
            }
            NuxeoOAuth2Token token = new NuxeoOAuth2Token(3600000L, authRequest.getClientId());
            TransactionHelper.runInTransaction(() -> this.tokenStore.store(authRequest.getUsername(), token));
            this.handleTokenResponse(token, response);
        } else if ("refresh_token".equals(tokenRequest.getGrantType())) {
            OAuth2Error error = null;
            if (StringUtils.isBlank((String)tokenRequest.getClientId())) {
                error = OAuth2Error.accessDenied();
            } else if (!clientService.isValidClient(tokenRequest.getClientId(), tokenRequest.getClientSecret())) {
                error = OAuth2Error.accessDenied();
            }
            if (error != null) {
                this.handleJsonError(error, response);
                return;
            }
            NuxeoOAuth2Token refreshed = (NuxeoOAuth2Token)TransactionHelper.runInTransaction(() -> this.tokenStore.refresh(tokenRequest.getRefreshToken(), tokenRequest.getClientId()));
            if (refreshed == null) {
                this.handleJsonError(OAuth2Error.invalidRequest(), response);
            } else {
                this.handleTokenResponse(refreshed, response);
            }
        } else {
            this.handleJsonError(OAuth2Error.invalidGrant(), response);
        }
    }

    protected void handleTokenResponse(NuxeoOAuth2Token token, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "application/json");
        response.setStatus(200);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)response.getWriter(), token.toJsonObject());
    }

    protected void handleError(OAuth2Error error, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.getSession().invalidate();
        response.reset();
        response.setStatus(400);
        request.setAttribute(ERROR_PARAM, (Object)error);
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(ERROR_JSP_PAGE_PATH);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void handleJsonError(OAuth2Error error, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "application/json");
        response.setStatus(400);
        HashMap<String, String> object = new HashMap<String, String>();
        object.put(ERROR_PARAM, error.getId());
        if (StringUtils.isNotBlank((String)error.getDescription())) {
            object.put(ERROR_DESCRIPTION_PARAM, error.getDescription());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)response.getWriter(), object);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectURI, Map<String, String> params) throws IOException {
        request.getSession().invalidate();
        if (redirectURI == null) {
            response.sendError(400, "No redirect URI");
            return;
        }
        String url = URIUtils.addParametersToURIQuery((String)redirectURI, params);
        response.sendRedirect(url);
    }
}

