/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2;

public class OAuth2Error {
    public static final String INVALID_REQUEST = "invalid_request";
    public static final String INVALID_GRANT = "invalid_grant";
    public static final String UNAUTHORIZED_CLIENT = "unauthorized_client";
    public static final String ACCESS_DENIED = "access_denied";
    public static final String UNSUPPORTED_RESPONSE_TYPE = "unsupported_response_type";
    public static final String INVALID_SCOPE = "invalid_scope";
    public static final String SERVER_ERROR = "server_error";
    public static final String TEMPORARILY_UNAVAILABLE = "temporarily_unavailable";
    protected final String id;
    protected final String description;

    protected OAuth2Error(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static OAuth2Error invalidRequest(String description) {
        return new OAuth2Error(INVALID_REQUEST, description);
    }

    public static OAuth2Error invalidRequest() {
        return OAuth2Error.invalidRequest(null);
    }

    public static OAuth2Error invalidGrant(String description) {
        return new OAuth2Error(INVALID_GRANT, description);
    }

    public static OAuth2Error invalidGrant() {
        return OAuth2Error.invalidGrant(null);
    }

    public static OAuth2Error unauthorizedClient(String description) {
        return new OAuth2Error(UNAUTHORIZED_CLIENT, description);
    }

    public static OAuth2Error unauthorizedClient() {
        return OAuth2Error.unauthorizedClient(null);
    }

    public static OAuth2Error accessDenied(String description) {
        return new OAuth2Error(ACCESS_DENIED, description);
    }

    public static OAuth2Error accessDenied() {
        return OAuth2Error.accessDenied(null);
    }

    public static OAuth2Error unsupportedResponseType(String description) {
        return new OAuth2Error(UNSUPPORTED_RESPONSE_TYPE, description);
    }

    public static OAuth2Error unsupportedResponseType() {
        return OAuth2Error.unsupportedResponseType(null);
    }

    public static OAuth2Error invalidScope(String description) {
        return new OAuth2Error(INVALID_SCOPE, description);
    }

    public static OAuth2Error invalidScope() {
        return OAuth2Error.invalidScope(null);
    }

    public static OAuth2Error serverError(String description) {
        return new OAuth2Error(SERVER_ERROR, description);
    }

    public static OAuth2Error serverError() {
        return OAuth2Error.serverError(null);
    }

    public static OAuth2Error temporarilyUnavailable(String description) {
        return new OAuth2Error(TEMPORARILY_UNAVAILABLE, description);
    }

    public static OAuth2Error temporarilyUnavailable() {
        return OAuth2Error.temporarilyUnavailable(null);
    }
}

