/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.Collections;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ClientServiceImpl
extends DefaultComponent
implements OAuth2ClientService {
    @Override
    public boolean hasClient(String clientId) {
        OAuth2Client client = this.getClient(clientId);
        return client != null && client.isEnabled();
    }

    @Override
    public boolean isValidClient(String clientId, String clientSecret) {
        OAuth2Client client = this.getClient(clientId);
        return client != null && client.isValidWith(clientId, clientSecret);
    }

    @Override
    public OAuth2Client getClient(String clientId) {
        DocumentModel doc = this.getClientModel(clientId);
        if (doc == null) {
            return null;
        }
        return OAuth2Client.fromDocumentModel(doc);
    }

    protected DocumentModel getClientModel(String clientId) {
        DirectoryService service = (DirectoryService)Framework.getService(DirectoryService.class);
        return (DocumentModel)Framework.doPrivileged(() -> {
            try (Session session = service.open("oauth2Clients");){
                Map<String, String> filter = Collections.singletonMap("clientId", clientId);
                DocumentModelList docs = session.query(filter);
                if (docs.size() == 1) {
                    DocumentModel documentModel = (DocumentModel)docs.get(0);
                    return documentModel;
                }
                if (docs.size() > 1) {
                    throw new NuxeoException(String.format("More than one client registered for the '%s' id", clientId));
                }
            }
            return null;
        });
    }
}

