/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.platform.oauth2.OAuth2Error;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.request.OAuth2Request;
import org.nuxeo.runtime.api.Framework;

public class AuthorizationRequest
extends OAuth2Request {
    private static final Log log = LogFactory.getLog(AuthorizationRequest.class);
    public static final String MISSING_REQUIRED_FIELD_MESSAGE = "Missing required field \"%s\".";
    public static final String STORE_NAME = "authorizationRequestStore";
    protected String responseType;
    protected String scope;
    protected Date creationDate;
    protected String authorizationCode;
    protected String authorizationKey;
    protected String username;

    public static AuthorizationRequest fromRequest(HttpServletRequest request) {
        return new AuthorizationRequest(request);
    }

    public static AuthorizationRequest fromMap(Map<String, Serializable> map) {
        return new AuthorizationRequest(map);
    }

    public static void store(String key, AuthorizationRequest authorizationRequest) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        store.putParameters(key, authorizationRequest.toMap());
    }

    public static AuthorizationRequest get(String key) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        Map parameters = store.getParameters(key);
        if (parameters != null) {
            AuthorizationRequest authorizationRequest = AuthorizationRequest.fromMap(parameters);
            return authorizationRequest.isExpired() ? null : authorizationRequest;
        }
        return null;
    }

    public static void remove(String key) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        store.remove(key);
    }

    protected AuthorizationRequest(HttpServletRequest request) {
        super(request);
        this.responseType = request.getParameter("response_type");
        this.scope = request.getParameter("scope");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            this.username = principal.getName();
        }
        this.creationDate = new Date();
        this.authorizationKey = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
    }

    protected AuthorizationRequest(Map<String, Serializable> map) {
        this.clientId = (String)((Object)map.get("clientId"));
        this.redirectURI = (String)((Object)map.get("redirectURI"));
        this.responseType = (String)((Object)map.get("responseType"));
        this.scope = (String)((Object)map.get("scope"));
        this.creationDate = (Date)map.get("creationDate");
        this.authorizationCode = (String)((Object)map.get("authorizationCode"));
        this.authorizationKey = (String)((Object)map.get("authorizationKey"));
        this.username = (String)((Object)map.get("username"));
    }

    public OAuth2Error checkError() {
        List<String> clientRedirectURIs;
        if (StringUtils.isBlank((String)this.clientId)) {
            return OAuth2Error.invalidRequest(String.format(MISSING_REQUIRED_FIELD_MESSAGE, "client_id"));
        }
        if (StringUtils.isBlank((String)this.responseType)) {
            return OAuth2Error.invalidRequest(String.format(MISSING_REQUIRED_FIELD_MESSAGE, "response_type"));
        }
        if (!"code".equals(this.responseType)) {
            return OAuth2Error.unsupportedResponseType(String.format("Unknown %s: got \"%s\", expecting \"%s\".", "response_type", this.responseType, "code"));
        }
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        OAuth2Client client = clientService.getClient(this.clientId);
        if (client == null || !client.isEnabled()) {
            return OAuth2Error.unauthorizedClient(String.format("Invalid %s: %s.", "client_id", this.clientId));
        }
        String clientName = client.getName();
        if (StringUtils.isBlank((String)clientName)) {
            log.error((Object)String.format("No name set for OAuth2 client %s. It is a required field, please make sure you update this OAuth2 client.", client));
        }
        if (CollectionUtils.isEmpty(clientRedirectURIs = client.getRedirectURIs())) {
            log.error((Object)String.format("No redirect URI set for OAuth2 client %s, at least one is required. Please make sure you update this OAuth2 client.", client));
            return OAuth2Error.invalidRequest("No redirect URI configured for the app.");
        }
        String clientRedirectURI = null;
        if (StringUtils.isBlank((String)this.redirectURI)) {
            clientRedirectURI = clientRedirectURIs.get(0);
        } else {
            if (!clientRedirectURIs.contains(this.redirectURI)) {
                return OAuth2Error.invalidRequest(String.format("Invalid %s parameter: %s. It must exactly match one of the redirect URIs configured for the app.", "redirect_uri", this.redirectURI));
            }
            clientRedirectURI = this.redirectURI;
        }
        if (!OAuth2Client.isRedirectURIValid(clientRedirectURI)) {
            log.error((Object)String.format("The redirect URI %s set for OAuth2 client %s is invalid: it must not be empty and start with https for security reasons. Please make sure you update this OAuth2 client.", clientRedirectURI, client));
            return OAuth2Error.invalidRequest(String.format("Invalid redirect URI configured for the app: %s. It must not be empty and start with https for security reasons.", clientRedirectURI));
        }
        return null;
    }

    public boolean isExpired() {
        return new Date().getTime() - this.creationDate.getTime() > 600000L;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuthorizationCode() {
        if (StringUtils.isBlank((String)this.authorizationCode)) {
            this.authorizationCode = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        }
        return this.authorizationCode;
    }

    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (this.clientId != null) {
            map.put("clientId", (Serializable)((Object)this.clientId));
        }
        if (this.redirectURI != null) {
            map.put("redirectURI", (Serializable)((Object)this.redirectURI));
        }
        if (this.responseType != null) {
            map.put("responseType", (Serializable)((Object)this.responseType));
        }
        if (this.scope != null) {
            map.put("scope", (Serializable)((Object)this.scope));
        }
        if (this.creationDate != null) {
            map.put("creationDate", this.creationDate);
        }
        if (this.authorizationCode != null) {
            map.put("authorizationCode", (Serializable)((Object)this.authorizationCode));
        }
        if (this.authorizationKey != null) {
            map.put("authorizationKey", (Serializable)((Object)this.authorizationKey));
        }
        if (this.username != null) {
            map.put("username", (Serializable)((Object)this.username));
        }
        return map;
    }
}

