/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoOAuth2TokenReader
extends EntityJsonReader<NuxeoOAuth2Token> {
    public NuxeoOAuth2TokenReader() {
        super("nuxeoOAuth2Token");
    }

    protected NuxeoOAuth2Token readEntity(JsonNode jn) throws IOException {
        String cliendId = this.getStringField(jn, "clientId");
        NuxeoOAuth2Token token = new NuxeoOAuth2Token(0L, cliendId);
        token.setServiceName(this.getStringField(jn, "serviceName"));
        token.setNuxeoLogin(this.getStringField(jn, "nuxeoLogin"));
        token.setServiceLogin(this.getStringField(jn, "serviceLogin"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(dateFormat.parse(this.getStringField(jn, "creationDate")));
        }
        catch (ParseException e) {
            cal = null;
        }
        token.setCreationDate(cal);
        token.setIsShared(this.getBooleanField(jn, "isShared"));
        List sharedWith = this.getStringListField(jn, "sharedWith");
        token.setSharedWith(sharedWith == null ? "" : String.join((CharSequence)",", sharedWith));
        return token;
    }
}

