/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.runtime.api.Framework;

public class OAuth2TokenStore
implements DataStore<StoredCredential> {
    protected static final Log log = LogFactory.getLog(OAuth2TokenStore.class);
    public static final String DIRECTORY_NAME = "oauth2Tokens";
    public static final String ENTRY_ID = "id";
    private String serviceName;

    public OAuth2TokenStore(String serviceName) {
        this.serviceName = serviceName;
    }

    public DataStore<StoredCredential> set(String key, StoredCredential credential) throws IOException {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put(ENTRY_ID, (Serializable)((Object)key));
        DocumentModel entry = this.find(filter);
        if (entry == null) {
            this.store(key, new NuxeoOAuth2Token(credential));
        } else {
            this.refresh(entry, new NuxeoOAuth2Token(credential));
        }
        return this;
    }

    public DataStore<StoredCredential> delete(String key) throws IOException {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("serviceName", this.serviceName);
            filter.put(ENTRY_ID, key);
            DocumentModelList entries = session.query(filter);
            for (DocumentModel entry : entries) {
                session.deleteEntry(entry);
            }
        }
        return this;
    }

    public StoredCredential get(String key) throws IOException {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put(ENTRY_ID, (Serializable)((Object)key));
        DocumentModel entry = this.find(filter);
        return entry != null ? NuxeoOAuth2Token.asCredential(entry) : null;
    }

    public DataStoreFactory getDataStoreFactory() {
        return null;
    }

    public final String getId() {
        return this.serviceName;
    }

    public boolean containsKey(String key) throws IOException {
        return this.get(key) != null;
    }

    public boolean containsValue(StoredCredential value) throws IOException {
        return this.values().contains(value);
    }

    public boolean isEmpty() throws IOException {
        return this.size() == 0;
    }

    public int size() throws IOException {
        return this.keySet().size();
    }

    public Set<String> keySet() throws IOException {
        HashSet<String> keys = new HashSet<String>();
        DocumentModelList entries = this.query();
        for (DocumentModel entry : entries) {
            keys.add((String)entry.getProperty("oauth2Token", ENTRY_ID));
        }
        return keys;
    }

    public Collection<StoredCredential> values() throws IOException {
        ArrayList<StoredCredential> results = new ArrayList<StoredCredential>();
        DocumentModelList entries = this.query();
        for (DocumentModel entry : entries) {
            results.add(NuxeoOAuth2Token.asCredential(entry));
        }
        return results;
    }

    public DataStore<StoredCredential> clear() throws IOException {
        return null;
    }

    public void store(String userId, NuxeoOAuth2Token token) {
        token.setServiceName(this.serviceName);
        token.setNuxeoLogin(userId);
        try {
            this.storeTokenAsDirectoryEntry(token);
        }
        catch (DirectoryException e) {
            log.error((Object)"Error during token storage", (Throwable)e);
        }
    }

    public NuxeoOAuth2Token refresh(String refreshToken, String clientId) {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("clientId", (Serializable)((Object)clientId));
        filter.put("refreshToken", (Serializable)((Object)refreshToken));
        filter.put("serviceName", (Serializable)((Object)this.serviceName));
        DocumentModel entry = this.find(filter);
        if (entry != null) {
            NuxeoOAuth2Token token = this.getTokenFromDirectoryEntry(entry);
            this.delete(token.getAccessToken(), clientId);
            token.refresh();
            return this.storeTokenAsDirectoryEntry(token);
        }
        return null;
    }

    public NuxeoOAuth2Token refresh(DocumentModel entry, NuxeoOAuth2Token token) {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        return (NuxeoOAuth2Token)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                entry.setProperty("oauth2Token", "accessToken", (Object)token.getAccessToken());
                entry.setProperty("oauth2Token", "refreshToken", (Object)token.getRefreshToken());
                entry.setProperty("oauth2Token", "creationDate", (Object)token.getCreationDate());
                entry.setProperty("oauth2Token", "expirationTimeMilliseconds", (Object)token.getExpirationTimeMilliseconds());
                session.updateEntry(entry);
                NuxeoOAuth2Token nuxeoOAuth2Token = this.getTokenFromDirectoryEntry(entry);
                return nuxeoOAuth2Token;
            }
        });
    }

    public void delete(String token, String clientId) {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put("serviceName", this.serviceName);
                filter.put("clientId", clientId);
                filter.put("accessToken", token);
                DocumentModelList entries = session.query(filter);
                for (DocumentModel entry : entries) {
                    session.deleteEntry(entry);
                }
            }
        });
    }

    public NuxeoOAuth2Token getToken(String token) {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("accessToken", (Serializable)((Object)token));
        DocumentModelList entries = this.query(filter);
        if (entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            log.error((Object)"Found several tokens");
        }
        return this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0));
    }

    public DocumentModelList query() {
        return this.query(new HashMap<String, Serializable>());
    }

    public DocumentModelList query(Map<String, Serializable> filter) {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        return (DocumentModelList)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                filter.put("serviceName", (Serializable)((Object)this.serviceName));
                DocumentModelList documentModelList = session.query(filter);
                return documentModelList;
            }
        });
    }

    protected NuxeoOAuth2Token getTokenFromDirectoryEntry(DocumentModel entry) {
        return new NuxeoOAuth2Token(entry);
    }

    protected NuxeoOAuth2Token storeTokenAsDirectoryEntry(NuxeoOAuth2Token aToken) {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        return (NuxeoOAuth2Token)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModel entry = session.createEntry(aToken.toMap());
                session.updateEntry(entry);
                NuxeoOAuth2Token nuxeoOAuth2Token = this.getTokenFromDirectoryEntry(entry);
                return nuxeoOAuth2Token;
            }
        });
    }

    protected DocumentModel find(Map<String, Serializable> filter) {
        DocumentModelList entries = this.query(filter);
        if (entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            log.error((Object)"Found several tokens");
        }
        return (DocumentModel)entries.get(0);
    }
}

