/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ServerAddress;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class MongoDBChecker
implements BackingChecker {
    public static final String TEMPLATE_NAME = "mongodb";

    public boolean accepts(ConfigurationGenerator cg) {
        return cg.getTemplateList().contains(TEMPLATE_NAME);
    }

    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        MongoClient ret = null;
        String serverName = cg.getUserConfig().getProperty("nuxeo.mongodb.server");
        String dbName = cg.getUserConfig().getProperty("nuxeo.mongodb.dbname");
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder().serverSelectionTimeout((int)TimeUnit.SECONDS.toMillis(1L)).description("Nuxeo DB Check");
        ret = serverName.startsWith("mongodb://") ? new MongoClient(new MongoClientURI(serverName, optionsBuilder)) : new MongoClient(new ServerAddress(serverName), optionsBuilder.build());
        try {
            Document ping = new Document("ping", (Object)"1");
            ret.getDatabase(dbName).runCommand((Bson)ping);
        }
        catch (MongoTimeoutException e) {
            throw new ConfigurationException(String.format("Unable to connect to MongoDB at %s, please check your connection", serverName));
        }
        finally {
            ret.close();
        }
    }
}

