/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CursorService;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSStateFlattener;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MongoDBRepository.class);
    public static final Long ZERO = 0L;
    public static final Long ONE = 1L;
    public static final Long MINUS_ONE = -1L;
    public static final String DB_DEFAULT = "nuxeo";
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    public static final String MONGODB_SET = "$set";
    public static final String MONGODB_UNSET = "$unset";
    public static final String MONGODB_PUSH = "$push";
    public static final String MONGODB_EACH = "$each";
    public static final String MONGODB_META = "$meta";
    public static final String MONGODB_TEXT_SCORE = "textScore";
    private static final String MONGODB_INDEX_TEXT = "text";
    private static final String MONGODB_INDEX_NAME = "name";
    private static final String MONGODB_LANGUAGE_OVERRIDE = "language_override";
    private static final String FULLTEXT_INDEX_NAME = "fulltext";
    private static final String LANGUAGE_FIELD = "__language";
    protected static final String COUNTER_NAME_UUID = "ecm:id";
    protected static final String COUNTER_FIELD = "seq";
    protected static final int MONGODB_OPTION_CONNECTION_TIMEOUT_MS = 30000;
    protected static final int MONGODB_OPTION_SOCKET_TIMEOUT_MS = 60000;
    protected MongoClient mongoClient;
    protected DBCollection coll;
    protected DBCollection countersColl;
    protected String idKey;
    protected boolean useCustomId;
    protected long sequenceLeft;
    protected long sequenceLastValue;
    protected long sequenceBlockSize;
    protected final MongoDBConverter converter;
    protected final CursorService<DBCursor, DBObject> cursorService = new CursorService();
    protected DBObject binaryKeys;
    protected static final DBObject LOCK_FIELDS = new BasicDBObject();
    protected static final DBObject UNSET_LOCK_UPDATE;

    public MongoDBRepository(ConnectionManager cm, MongoDBRepositoryDescriptor descriptor) {
        super(cm, descriptor.name, (DBSRepositoryDescriptor)descriptor);
        try {
            this.mongoClient = MongoDBRepository.newMongoClient(descriptor);
            this.coll = MongoDBRepository.getCollection(descriptor, this.mongoClient);
            this.countersColl = MongoDBRepository.getCountersCollection(descriptor, this.mongoClient);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.idKey = Boolean.TRUE.equals(descriptor.nativeId) ? MONGODB_ID : COUNTER_NAME_UUID;
        this.useCustomId = COUNTER_NAME_UUID.equals(this.idKey);
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            Integer sbs = descriptor.sequenceBlockSize;
            this.sequenceBlockSize = sbs == null ? 1L : sbs.longValue();
            this.sequenceLeft = 0L;
        }
        this.converter = new MongoDBConverter(this.idKey);
        this.initRepository();
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Arrays.asList(DBSRepositoryBase.IdType.varchar, DBSRepositoryBase.IdType.sequence);
    }

    public void shutdown() {
        super.shutdown();
        this.cursorService.clear();
        this.mongoClient.close();
    }

    public static MongoClient newMongoClient(MongoDBRepositoryDescriptor descriptor) throws UnknownHostException {
        String server = descriptor.server;
        if (StringUtils.isBlank((String)server)) {
            throw new NuxeoException("Missing <server> in MongoDB repository descriptor");
        }
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder().socketKeepAlive(true).connectTimeout(30000).socketTimeout(60000).description("Nuxeo");
        MongoClient ret = server.startsWith("mongodb://") ? new MongoClient(new MongoClientURI(server, optionsBuilder)) : new MongoClient(new ServerAddress(server), optionsBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoClient initialized with options: " + ret.getMongoClientOptions().toString()));
        }
        return ret;
    }

    protected static DBCollection getCollection(MongoClient mongoClient, String dbname, String collection) {
        if (StringUtils.isBlank((String)dbname)) {
            dbname = DB_DEFAULT;
        }
        DB db = mongoClient.getDB(dbname);
        return db.getCollection(collection);
    }

    public static DBCollection getCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name);
    }

    public static DBCollection getCountersCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name + ".counters");
    }

    protected void initRepository() {
        BasicDBObject query;
        if (this.useCustomId) {
            this.coll.createIndex((DBObject)new BasicDBObject(this.idKey, (Object)ONE));
        }
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:parentId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:ancestorIds", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:versionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyTargetId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyVersionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:racl", (Object)ONE));
        BasicDBObject parentChild = new BasicDBObject();
        parentChild.put("ecm:parentId", (Object)ONE);
        parentChild.put("ecm:name", (Object)ONE);
        this.coll.createIndex((DBObject)parentChild);
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:primaryType", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:lifeCycleState", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:fulltextJobId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:acp.acl.user", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:acp.acl.status", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("dc:modified", (Object)MINUS_ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("rend:renditionName", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("drv:subscriptions.enabled", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("collectionMember:collectionIds", (Object)ONE));
        if (!this.isFulltextDisabled()) {
            BasicDBObject indexKeys = new BasicDBObject();
            indexKeys.put("ecm:fulltextSimple", (Object)MONGODB_INDEX_TEXT);
            indexKeys.put("ecm:fulltextBinary", (Object)MONGODB_INDEX_TEXT);
            BasicDBObject indexOptions = new BasicDBObject();
            indexOptions.put(MONGODB_INDEX_NAME, (Object)FULLTEXT_INDEX_NAME);
            indexOptions.put(MONGODB_LANGUAGE_OVERRIDE, (Object)LANGUAGE_FIELD);
            this.coll.createIndex((DBObject)indexKeys, (DBObject)indexOptions);
        }
        if (this.coll.findOne((DBObject)(query = new BasicDBObject(this.idKey, (Object)this.getRootId())), this.justPresenceField()) != null) {
            return;
        }
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            BasicDBObject idCounter = new BasicDBObject();
            idCounter.put(MONGODB_ID, (Object)COUNTER_NAME_UUID);
            idCounter.put(COUNTER_FIELD, (Object)ZERO);
            this.countersColl.insert(new DBObject[]{idCounter});
        }
        this.initRoot();
    }

    protected synchronized Long getNextSequenceId() {
        if (this.sequenceLeft == 0L) {
            BasicDBObject query = new BasicDBObject(MONGODB_ID, (Object)COUNTER_NAME_UUID);
            BasicDBObject update = new BasicDBObject(MONGODB_INC, (Object)new BasicDBObject(COUNTER_FIELD, (Object)this.sequenceBlockSize));
            DBObject idCounter = this.countersColl.findAndModify((DBObject)query, null, null, false, (DBObject)update, true, false);
            if (idCounter == null) {
                throw new NuxeoException("Repository id counter not initialized");
            }
            this.sequenceLeft = this.sequenceBlockSize;
            this.sequenceLastValue = (Long)idCounter.get(COUNTER_FIELD) - this.sequenceBlockSize;
        }
        --this.sequenceLeft;
        ++this.sequenceLastValue;
        return this.sequenceLastValue;
    }

    public String generateNewId() {
        if (this.idType == DBSRepositoryBase.IdType.sequence) {
            Long id = this.getNextSequenceId();
            return id.toString();
        }
        return UUID.randomUUID().toString();
    }

    public void createState(State state) {
        DBObject ob = this.converter.stateToBson(state);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: CREATE " + ob.get(this.idKey) + ": " + ob));
        }
        this.coll.insert(new DBObject[]{ob});
    }

    public void createStates(List<State> states) {
        List obs = states.stream().map(this.converter::stateToBson).collect(Collectors.toList());
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: CREATE [" + obs.stream().map(ob -> ob.get(this.idKey).toString()).collect(Collectors.joining(", ")) + "]: " + obs));
        }
        this.coll.insert(obs);
    }

    public State readState(String id) {
        BasicDBObject query = new BasicDBObject(this.idKey, (Object)id);
        return this.findOne((DBObject)query);
    }

    public List<State> readStates(List<String> ids) {
        BasicDBObject query = new BasicDBObject(this.idKey, (Object)new BasicDBObject("$in", ids));
        return this.findAll((DBObject)query, ids.size());
    }

    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        List<DBObject> updates = this.converter.diffToBson(diff);
        for (DBObject update : updates) {
            WriteResult w;
            BasicDBObject query = new BasicDBObject(this.idKey, (Object)id);
            if (changeTokenUpdater == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("MongoDB: UPDATE " + id + ": " + update));
                }
            } else {
                Map conditions = changeTokenUpdater.getConditions();
                Map tokenUpdates = changeTokenUpdater.getUpdates();
                if (update.containsField(MONGODB_SET)) {
                    ((DBObject)update.get(MONGODB_SET)).putAll(tokenUpdates);
                } else {
                    BasicDBObject set = new BasicDBObject();
                    set.putAll(tokenUpdates);
                    update.put(MONGODB_SET, (Object)set);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("MongoDB: UPDATE " + id + ": IF " + conditions + " THEN " + update));
                }
                query.putAll(conditions);
            }
            if ((w = this.coll.update((DBObject)query, update)).getN() == 1) continue;
            log.trace((Object)("MongoDB:    -> CONCURRENT UPDATE: " + id));
            throw new ConcurrentUpdateException(id);
        }
    }

    public void deleteStates(Set<String> ids) {
        WriteResult w;
        BasicDBObject query = new BasicDBObject(this.idKey, (Object)new BasicDBObject("$in", ids));
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: REMOVE " + ids));
        }
        if ((w = this.coll.remove((DBObject)query)).getN() != ids.size()) {
            log.error((Object)("Removed " + w.getN() + " docs for " + ids.size() + " ids: " + ids));
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    protected void logQuery(String id, DBObject fields) {
        this.logQuery((DBObject)new BasicDBObject(this.idKey, (Object)id), fields);
    }

    protected void logQuery(DBObject query, DBObject fields) {
        if (fields == null) {
            log.trace((Object)("MongoDB: QUERY " + query));
        } else {
            log.trace((Object)("MongoDB: QUERY " + query + " KEYS " + fields));
        }
    }

    protected void logQuery(DBObject query, DBObject fields, DBObject orderBy, int limit, int offset) {
        log.trace((Object)("MongoDB: QUERY " + query + " KEYS " + fields + (orderBy == null ? "" : " ORDER BY " + orderBy) + " OFFSET " + offset + " LIMIT " + limit));
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        if (log.isTraceEnabled()) {
            this.logQuery(query, this.justPresenceField());
        }
        return this.coll.findOne(query, this.justPresenceField()) != null;
    }

    protected DBObject getChildQuery(String parentId, String name, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject();
        query.put("ecm:parentId", (Object)parentId);
        query.put("ecm:name", (Object)name);
        this.addIgnoredIds((DBObject)query, ignored);
        return query;
    }

    protected void addIgnoredIds(DBObject query, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            BasicDBObject notInIds = new BasicDBObject("$nin", new ArrayList<String>(ignored));
            query.put(this.idKey, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(this.converter.keyToBson(key), value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(this.converter.keyToBson(key1), value1);
        query.put(this.converter.keyToBson(key2), value2);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        BasicDBObject query = new BasicDBObject(key, value);
        BasicDBObject fields = new BasicDBObject();
        if (this.useCustomId) {
            fields.put(MONGODB_ID, (Object)ZERO);
        }
        fields.put(this.idKey, (Object)ONE);
        fields.put("ecm:isProxy", (Object)ONE);
        fields.put("ecm:proxyTargetId", (Object)ONE);
        fields.put("ecm:proxyIds", (Object)ONE);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)query, (DBObject)fields);
        }
        try (DBCursor cursor = this.coll.find((DBObject)query, (DBObject)fields);){
            for (DBObject ob : cursor) {
                Object[] proxyIds;
                String id = (String)ob.get(this.idKey);
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(ob.get("ecm:isProxy"))) {
                    String targetId = (String)ob.get("ecm:proxyTargetId");
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])this.converter.bsonToValue(ob.get("ecm:proxyIds"))) == null) continue;
                targetProxies.put(id, proxyIds);
            }
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)query, this.justPresenceField());
        }
        return this.coll.findOne((DBObject)query, this.justPresenceField()) != null;
    }

    protected State findOne(DBObject query) {
        if (log.isTraceEnabled()) {
            this.logQuery(query, null);
        }
        return this.converter.bsonToState(this.coll.findOne(query));
    }

    protected List<State> findAll(DBObject query, int sizeHint) {
        if (log.isTraceEnabled()) {
            this.logQuery(query, null);
        }
        HashSet<String> seen = new HashSet<String>();
        try (DBCursor cursor = this.coll.find(query);){
            ArrayList<State> list = new ArrayList<State>(sizeHint);
            for (DBObject ob : cursor) {
                if (!seen.add((String)ob.get(this.idKey))) continue;
                list.add(this.converter.bsonToState(ob));
            }
            ArrayList<State> arrayList = list;
            return arrayList;
        }
    }

    protected DBObject justPresenceField() {
        return new BasicDBObject(MONGODB_ID, (Object)ONE);
    }

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        long totalSize;
        ArrayList<Map> projections;
        boolean manualProjection;
        MongoDBQueryBuilder builder = new MongoDBQueryBuilder(this, evaluator.getExpression(), evaluator.getSelectClause(), orderByClause, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.isFulltextDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        DBObject query = builder.getQuery();
        this.addPrincipals(query, evaluator.principals);
        DBObject orderBy = builder.getOrderBy();
        DBObject keys = builder.getProjection();
        boolean bl = manualProjection = !distinctDocuments && builder.hasProjectionWildcard();
        if (manualProjection) {
            keys = new BasicDBObject();
            evaluator.parse();
        }
        if (log.isTraceEnabled()) {
            this.logQuery(query, keys, orderBy, limit, offset);
        }
        try (DBCursor cursor = this.coll.find(query, keys).skip(offset).limit(limit);){
            if (orderBy != null) {
                cursor.sort(orderBy);
            }
            projections = new ArrayList<Map>();
            for (DBObject ob : cursor) {
                State state = this.converter.bsonToState(ob);
                if (manualProjection) {
                    projections.addAll(evaluator.matches(state));
                    continue;
                }
                projections.add(DBSStateFlattener.flatten((State)state));
            }
            if (countUpTo == -1) {
                totalSize = limit == 0 ? (long)projections.size() : (long)cursor.count();
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                totalSize = limit == 0 ? (long)projections.size() : (long)cursor.copy().limit(countUpTo + 1).count();
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
        }
        if (log.isTraceEnabled() && projections.size() != 0) {
            log.trace((Object)("MongoDB:    -> " + projections.size()));
        }
        return new PartialList(projections, totalSize);
    }

    public ScrollResult scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        this.cursorService.checkForTimedOutScroll();
        MongoDBQueryBuilder builder = new MongoDBQueryBuilder(this, evaluator.getExpression(), evaluator.getSelectClause(), null, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.isFulltextDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        DBObject query = builder.getQuery();
        DBObject keys = builder.getProjection();
        if (log.isTraceEnabled()) {
            this.logQuery(query, keys, null, 0, 0);
        }
        DBCursor cursor = this.coll.find(query, keys);
        String scrollId = this.cursorService.registerCursor((Object)cursor, batchSize, keepAliveSeconds);
        return this.scroll(scrollId);
    }

    public ScrollResult scroll(String scrollId) {
        return this.cursorService.scroll(scrollId, ob -> (String)ob.get(this.converter.keyToBson(COUNTER_NAME_UUID)));
    }

    protected void addPrincipals(DBObject query, Set<String> principals) {
        if (principals != null) {
            BasicDBObject inPrincipals = new BasicDBObject("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }

    protected void initBlobsPaths() {
        MongoDBBlobFinder finder = new MongoDBBlobFinder();
        finder.visit();
        this.binaryKeys = finder.binaryKeys;
    }

    public void markReferencedBinaries() {
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)new BasicDBObject(), this.binaryKeys);
        }
        try (DBCursor cursor = this.coll.find((DBObject)new BasicDBObject(), this.binaryKeys);){
            for (DBObject ob : cursor) {
                this.markReferencedBinaries(ob, blobManager);
            }
        }
    }

    protected void markReferencedBinaries(DBObject ob, DocumentBlobManager blobManager) {
        for (String key : ob.keySet()) {
            Object value = ob.get(key);
            if (value instanceof List) {
                List list = (List)value;
                for (Object v : list) {
                    if (v instanceof DBObject) {
                        this.markReferencedBinaries((DBObject)v, blobManager);
                        continue;
                    }
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof DBObject) {
                this.markReferencedBinaries((DBObject)value, blobManager);
                continue;
            }
            this.markReferencedBinary(value, blobManager);
        }
    }

    protected void markReferencedBinary(Object value, DocumentBlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }

    public Lock getLock(String id) {
        DBObject res;
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((res = this.coll.findOne((DBObject)new BasicDBObject(this.idKey, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)res.get("ecm:lockOwner");
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.converter.scalarToSerializable(res.get("ecm:lockCreated"));
        return new Lock(owner, created);
    }

    public Lock setLock(String id, Lock lock) {
        DBObject old;
        DBObject res;
        BasicDBObject query = new BasicDBObject(this.idKey, (Object)id);
        query.put("ecm:lockOwner", null);
        BasicDBObject setLock = new BasicDBObject();
        setLock.put("ecm:lockOwner", (Object)lock.getOwner());
        setLock.put("ecm:lockCreated", this.converter.serializableToBson(lock.getCreated()));
        BasicDBObject setLockUpdate = new BasicDBObject(MONGODB_SET, (Object)setLock);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: FINDANDMODIFY " + query + " UPDATE " + setLockUpdate));
        }
        if ((res = this.coll.findAndModify((DBObject)query, null, null, false, (DBObject)setLockUpdate, false, false)) != null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((old = this.coll.findOne((DBObject)new BasicDBObject(this.idKey, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get("ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get("ecm:lockCreated"));
        if (oldOwner != null) {
            return new Lock(oldOwner, oldCreated);
        }
        throw new ConcurrentUpdateException("Lock " + id);
    }

    public Lock removeLock(String id, String owner) {
        DBObject old;
        BasicDBObject query = new BasicDBObject(this.idKey, (Object)id);
        if (owner != null) {
            List<String> ownerOrNull = Arrays.asList(owner, null);
            query.put("ecm:lockOwner", (Object)new BasicDBObject("$in", ownerOrNull));
        }
        if ((old = this.coll.findAndModify((DBObject)query, null, null, false, UNSET_LOCK_UPDATE, false, false)) != null) {
            String oldOwner = (String)old.get("ecm:lockOwner");
            if (oldOwner == null) {
                return null;
            }
            Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get("ecm:lockCreated"));
            return new Lock(oldOwner, oldCreated);
        }
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((old = this.coll.findOne((DBObject)new BasicDBObject(this.idKey, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get("ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.scalarToSerializable(old.get("ecm:lockCreated"));
        if (oldOwner != null) {
            if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
                return new Lock(oldOwner, oldCreated, true);
            }
            throw new ConcurrentUpdateException("Unlock " + id);
        }
        throw new ConcurrentUpdateException("Unlock " + id);
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    static {
        LOCK_FIELDS.put("ecm:lockOwner", (Object)ONE);
        LOCK_FIELDS.put("ecm:lockCreated", (Object)ONE);
        UNSET_LOCK_UPDATE = new BasicDBObject(MONGODB_UNSET, (Object)LOCK_FIELDS);
    }

    protected static class MongoDBBlobFinder
    extends DBSRepositoryBase.BlobFinder {
        protected DBObject binaryKeys = new BasicDBObject("_id", (Object)ZERO);

        protected MongoDBBlobFinder() {
        }

        protected void recordBlobPath() {
            this.path.addLast("data");
            this.binaryKeys.put(StringUtils.join((Collection)this.path, (String)"."), (Object)ONE);
            this.path.removeLast();
        }
    }
}

