/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleGroupFlatTree;
import org.nuxeo.apidoc.api.BundleGroupTreeHelper;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.JavaDocHelper;
import org.nuxeo.apidoc.introspection.BundleGroupImpl;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;
import org.nuxeo.apidoc.introspection.OperationInfoImpl;
import org.nuxeo.apidoc.introspection.SeamComponentInfoImpl;
import org.nuxeo.apidoc.introspection.ServerInfo;
import org.nuxeo.apidoc.seam.SeamRuntimeIntrospector;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class RuntimeSnapshot
extends BaseNuxeoArtifact
implements DistributionSnapshot {
    public static final String VIRTUAL_BUNDLE_GROUP = "grp:org.nuxeo.misc";
    protected ServerInfo serverInfo;
    protected Date created;
    protected final List<String> bundleIds = new ArrayList<String>();
    protected final List<String> javaComponentsIds = new ArrayList<String>();
    protected final Map<String, String> components2Bundles = new HashMap<String, String>();
    protected final Map<String, String> services2Components = new HashMap<String, String>();
    protected final Map<String, ExtensionPointInfo> extensionPoints = new HashMap<String, ExtensionPointInfo>();
    protected final Map<String, ExtensionInfo> contributions = new HashMap<String, ExtensionInfo>();
    protected final Map<String, List<String>> mavenGroups = new HashMap<String, List<String>>();
    protected final Map<String, List<String>> mavenSubGroups = new HashMap<String, List<String>>();
    protected final List<BundleGroup> bundleGroups = new ArrayList<BundleGroup>();
    protected boolean seamInitialized = false;
    protected List<SeamComponentInfo> seamComponents = new ArrayList<SeamComponentInfo>();
    protected boolean opsInitialized = false;
    protected final List<OperationInfo> operations = new ArrayList<OperationInfo>();
    protected JavaDocHelper jdocHelper;
    protected final List<Class<?>> spi = new ArrayList();
    final List<String> aliases = new LinkedList<String>(Collections.singletonList("current"));

    public static RuntimeSnapshot build() {
        return new RuntimeSnapshot();
    }

    @JsonCreator
    private RuntimeSnapshot(@JsonProperty(value="serverInfo") ServerInfo serverInfo, @JsonProperty(value="creationDate") Date created, @JsonProperty(value="seamComponents") List<SeamComponentInfo> seamComponents, @JsonProperty(value="operations") List<OperationInfo> operations) {
        this.serverInfo = serverInfo;
        this.created = created;
        this.index();
        this.seamComponents.addAll(seamComponents);
        this.operations.addAll(operations);
    }

    protected RuntimeSnapshot() {
        this.serverInfo = ServerInfo.build();
        this.created = new Date();
        this.index();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    @JsonIgnore
    public String getVersion() {
        return this.serverInfo.getVersion();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.serverInfo.getName();
    }

    protected void index() {
        this.spi.addAll(this.serverInfo.getAllSpi());
        for (BundleInfo bInfo : this.serverInfo.getBundles()) {
            this.bundleIds.add(bInfo.getId());
            String groupId = bInfo.getGroupId();
            if (groupId != null) {
                groupId = "grp:" + groupId;
            }
            String artifactId = bInfo.getArtifactId();
            if (groupId == null || artifactId == null) {
                groupId = VIRTUAL_BUNDLE_GROUP;
                ((BundleInfoImpl)bInfo).setGroupId(groupId);
            }
            if (!this.mavenGroups.containsKey(groupId)) {
                this.mavenGroups.put(groupId, new ArrayList());
            }
            this.mavenGroups.get(groupId).add(bInfo.getId());
            for (ComponentInfo cInfo : bInfo.getComponents()) {
                this.components2Bundles.put(cInfo.getId(), bInfo.getId());
                if (!cInfo.isXmlPureComponent()) {
                    this.javaComponentsIds.add(cInfo.getId());
                }
                for (ServiceInfo sInfo : cInfo.getServices()) {
                    if (sInfo.isOverriden()) continue;
                    this.services2Components.put(sInfo.getId(), cInfo.getId());
                }
                for (ExtensionPointInfo epi : cInfo.getExtensionPoints()) {
                    this.extensionPoints.put(epi.getId(), epi);
                }
                for (ExtensionInfo ei : cInfo.getExtensions()) {
                    this.contributions.put(ei.getId(), ei);
                }
            }
        }
        ArrayList<String> mvnGroupNames = new ArrayList<String>();
        mvnGroupNames.addAll(this.mavenGroups.keySet());
        for (String mvnGroupName : mvnGroupNames) {
            List<String> artifactIds = this.mavenGroups.get(mvnGroupName);
            Collections.sort(artifactIds);
            ArrayList<String> subGroups = new ArrayList<String>();
            for (String id : artifactIds) {
                String grp;
                if (!id.endsWith(".api") || (grp = "grp:" + id.substring(0, id.length() - 4)).equals(mvnGroupName)) continue;
                subGroups.add(grp);
            }
            if (subGroups.size() < 2) continue;
            for (String grp : subGroups) {
                ArrayList<String> grpArtifactIds = new ArrayList<String>();
                for (String aid : artifactIds) {
                    if (!aid.startsWith(grp) && !("grp:" + aid).startsWith(grp)) continue;
                    grpArtifactIds.add(aid);
                }
                if (grpArtifactIds.size() <= 0) continue;
                for (String aid : grpArtifactIds) {
                    artifactIds.remove(aid);
                }
                this.mavenSubGroups.put(grp, grpArtifactIds);
                artifactIds.add(grp);
            }
        }
        for (String grpId : this.mavenGroups.keySet()) {
            BundleGroupImpl bGroup = this.buildBundleGroup(grpId, this.serverInfo.getVersion());
            this.bundleGroups.add(bGroup);
        }
    }

    protected BundleGroupImpl buildBundleGroup(String id, String version) {
        BundleGroupImpl bGroup = new BundleGroupImpl(id, version);
        for (String aid : this.getBundleGroupChildren(id)) {
            if (aid.startsWith("grp:")) {
                BundleGroupImpl newGroup = this.buildBundleGroup(aid, version);
                bGroup.add(newGroup);
                newGroup.addParent(bGroup.getId());
                continue;
            }
            bGroup.add(aid);
            ((BundleInfoImpl)this.getBundle(aid)).setBundleGroup(bGroup);
            BundleInfo bi = this.getBundle(aid);
            bGroup.addLiveDoc(bi.getParentLiveDoc());
        }
        return bGroup;
    }

    @Override
    @JsonIgnore
    public List<BundleGroup> getBundleGroups() {
        return this.bundleGroups;
    }

    @Override
    public BundleGroup getBundleGroup(String groupId) {
        BundleGroupTreeHelper bgth = new BundleGroupTreeHelper(this);
        List<BundleGroupFlatTree> tree = bgth.getBundleGroupTree();
        for (BundleGroupFlatTree info : tree) {
            if (!info.getGroup().getId().equals(groupId)) continue;
            return info.getGroup();
        }
        if (!groupId.startsWith("grp:")) {
            return this.getBundleGroup("grp:" + groupId);
        }
        return null;
    }

    protected void browseBundleGroup(BundleGroup group, int level, List<BundleGroupFlatTree> tree) {
        BundleGroupFlatTree info = new BundleGroupFlatTree(group, level);
        tree.add(info);
        for (BundleGroup subGroup : group.getSubGroups()) {
            this.browseBundleGroup(subGroup, level + 1, tree);
        }
    }

    @Override
    @JsonIgnore
    public List<String> getBundleIds() {
        ArrayList<String> bundlesIds = new ArrayList<String>();
        for (BundleInfo info : this.serverInfo.getBundles()) {
            bundlesIds.add(info.getId());
        }
        Collections.sort(bundlesIds);
        return bundlesIds;
    }

    @Override
    public BundleInfo getBundle(String id) {
        return this.serverInfo.getBundle(id);
    }

    @Override
    @JsonIgnore
    public List<String> getComponentIds() {
        ArrayList<String> componentsIds = new ArrayList<String>();
        componentsIds.addAll(this.components2Bundles.keySet());
        Collections.sort(componentsIds);
        return componentsIds;
    }

    @Override
    public ComponentInfo getComponent(String id) {
        String bundleId = this.components2Bundles.get(id);
        if (bundleId == null) {
            return null;
        }
        BundleInfo bi = this.getBundle(bundleId);
        for (ComponentInfo ci : bi.getComponents()) {
            if (!ci.getId().equals(id)) continue;
            return ci;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getServiceIds() {
        ArrayList<String> serviceIds = new ArrayList<String>();
        serviceIds.addAll(this.services2Components.keySet());
        Collections.sort(serviceIds);
        return serviceIds;
    }

    @Override
    @JsonIgnore
    public List<String> getExtensionPointIds() {
        ArrayList<String> epIds = new ArrayList<String>();
        epIds.addAll(this.extensionPoints.keySet());
        Collections.sort(epIds);
        return epIds;
    }

    @Override
    @JsonIgnore
    public ExtensionPointInfo getExtensionPoint(String id) {
        return this.extensionPoints.get(id);
    }

    @Override
    @JsonIgnore
    public List<String> getContributionIds() {
        ArrayList<String> contribIds = new ArrayList<String>();
        contribIds.addAll(this.contributions.keySet());
        Collections.sort(contribIds);
        return contribIds;
    }

    @Override
    @JsonIgnore
    public List<ExtensionInfo> getContributions() {
        ArrayList<ExtensionInfo> contribs = new ArrayList<ExtensionInfo>();
        contribs.addAll(this.contributions.values());
        return contribs;
    }

    @Override
    public ExtensionInfo getContribution(String id) {
        return this.contributions.get(id);
    }

    public List<String> getBundleGroupIds() {
        ArrayList<String> grpIds = new ArrayList<String>();
        grpIds.addAll(this.mavenGroups.keySet());
        Collections.sort(grpIds);
        return grpIds;
    }

    @Override
    public List<String> getBundleGroupChildren(String groupId) {
        List<String> res = this.mavenSubGroups.get(groupId);
        if (res == null) {
            res = this.mavenGroups.get(groupId);
        }
        if (res != null) {
            return res;
        }
        return new ArrayList<String>();
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getName() + "-" + this.getVersion();
    }

    @Override
    @JsonIgnore
    public List<Class<?>> getSpi() {
        return this.spi;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getKey();
    }

    @Override
    @JsonIgnore
    public String getArtifactType() {
        return "NXDistribution";
    }

    @Override
    public ServiceInfo getService(String id) {
        String cId = this.services2Components.get(id);
        if (cId == null) {
            return null;
        }
        for (ServiceInfo si : this.getComponent(cId).getServices()) {
            if (!id.equals(si.getId())) continue;
            return si;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getJavaComponentIds() {
        return this.javaComponentsIds;
    }

    @Override
    @JsonIgnore
    public List<String> getXmlComponentIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (String cId : this.getComponentIds()) {
            if (this.javaComponentsIds.contains(cId)) continue;
            result.add(cId);
        }
        return result;
    }

    @Override
    public Date getCreationDate() {
        return this.created;
    }

    @Override
    @JsonIgnore
    public Date getReleaseDate() {
        return null;
    }

    @Override
    @JsonIgnore
    public boolean isLive() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getHierarchyPath() {
        return null;
    }

    public void initSeamComponents(HttpServletRequest request) {
        if (this.seamInitialized) {
            return;
        }
        this.seamComponents = SeamRuntimeIntrospector.listNuxeoComponents(request);
        for (SeamComponentInfo seamComp : this.seamComponents) {
            ((SeamComponentInfoImpl)seamComp).setVersion(this.getVersion());
        }
        this.seamInitialized = true;
    }

    public void initOperations() {
        OperationType[] ops;
        if (this.opsInitialized) {
            return;
        }
        AutomationService service = (AutomationService)Framework.getService(AutomationService.class);
        if (service == null) {
            return;
        }
        for (OperationType op : ops = service.getOperations()) {
            OperationDocumentation documentation;
            try {
                documentation = op.getDocumentation();
            }
            catch (OperationException e) {
                throw new NuxeoException((Throwable)e);
            }
            this.operations.add(new OperationInfoImpl(documentation, this.getVersion(), op.getType().getCanonicalName(), op.getContributingComponent()));
        }
        this.opsInitialized = true;
    }

    @Override
    public SeamComponentInfo getSeamComponent(String id) {
        for (SeamComponentInfo sci : this.getSeamComponents()) {
            if (!sci.getId().equals(id)) continue;
            return sci;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<String> getSeamComponentIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (SeamComponentInfo sci : this.getSeamComponents()) {
            ids.add(sci.getId());
        }
        return ids;
    }

    @Override
    public List<SeamComponentInfo> getSeamComponents() {
        return this.seamComponents;
    }

    @Override
    public boolean containsSeamComponents() {
        return this.getSeamComponentIds().size() > 0;
    }

    @Override
    public OperationInfo getOperation(String id) {
        if (id.startsWith("op:")) {
            id = id.substring("op:".length());
        }
        for (OperationInfo op : this.getOperations()) {
            if (op.getName().equals(id)) {
                return op;
            }
            String finalId = id;
            Optional<String> first = Arrays.stream(op.getAliases()).filter(s -> s.equals(finalId)).findFirst();
            if (!first.isPresent()) continue;
            return op;
        }
        return null;
    }

    @Override
    public List<OperationInfo> getOperations() {
        this.initOperations();
        return this.operations;
    }

    public JavaDocHelper getJavaDocHelper() {
        if (this.jdocHelper == null) {
            this.jdocHelper = JavaDocHelper.getHelper(this.getName(), this.getVersion());
        }
        return this.jdocHelper;
    }

    @Override
    public void cleanPreviousArtifacts() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonIgnore
    public boolean isLatestFT() {
        return false;
    }

    @Override
    @JsonIgnore
    public boolean isLatestLTS() {
        return false;
    }

    @Override
    @JsonIgnore
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @JsonIgnore
    public boolean isHidden() {
        return false;
    }
}

