/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.support.NodesResponse;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesMasterCoordinatedAction<Request extends MasterNodeRequest, Response extends NodesResponse, NodeRequest extends BaseNodeRequest, NodeResponse extends NodesResponse.Node>
extends TransportMasterNodeAction<Request, Response> {
    private final String transportActionName;

    protected TransportNodesMasterCoordinatedAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request, Class<NodeRequest> nodeRequest) {
        super(settings, actionName, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, request);
        this.transportActionName = actionName + "[n]";
        transportService.registerRequestHandler(this.transportActionName, nodeRequest, "management", (TransportRequestHandler)new NodeTransportHandler());
    }

    protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        new NodeOperationManager(this, request, listener).startNodeOperations();
    }

    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return null;
    }

    protected String executor() {
        return "management";
    }

    protected abstract NodeResponse newNodeResponse();

    protected abstract NodeResponse newNodeResponse(DiscoveryNode var1, FailedNodeException var2);

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    protected abstract Response newResponse(AtomicReferenceArray<NodeResponse> var1);

    protected abstract NodeRequest newNodeRequest(String var1, Request var2);

    class NodeTransportHandler
    extends TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(TransportNodesMasterCoordinatedAction.this.nodeOperation(request));
        }
    }

    static class NodeOperationManager {
        private final DiscoveryNodes nodes;
        private final AtomicReferenceArray<NodeResponse> nodeResponses;
        private final AtomicInteger counter = new AtomicInteger();
        private final Request request;
        private final ActionListener<Response> listener;
        final /* synthetic */ TransportNodesMasterCoordinatedAction this$0;

        NodeOperationManager(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.nodes = ((TransportNodesMasterCoordinatedAction)this$0).clusterService.state().nodes();
            this.nodeResponses = new AtomicReferenceArray(this.nodes.size());
            this.request = request;
            this.listener = listener;
        }

        void startNodeOperations() {
            int index = 0;
            for (final DiscoveryNode node : this.nodes) {
                final int currentIndex = index;
                try {
                    Object nodeRequest = this.this$0.newNodeRequest(node.getId(), this.request);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportActionName, nodeRequest, (TransportResponseHandler)new BaseTransportResponseHandler<NodeResponse>(){

                        public NodeResponse newInstance() {
                            return NodeOperationManager.this.this$0.newNodeResponse();
                        }

                        public void handleResponse(NodeResponse response) {
                            NodeOperationManager.this.onOperation(currentIndex, (Object)((Object)response));
                        }

                        public void handleException(TransportException exp) {
                            NodeOperationManager.this.onFailure(currentIndex, node, (Throwable)exp);
                        }

                        public String executor() {
                            return "same";
                        }
                    });
                }
                catch (Exception e) {
                    this.onFailure(currentIndex, node, e);
                }
                ++index;
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.nodeResponses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.nodeResponses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, DiscoveryNode node, Throwable t) {
            if (this.this$0.logger.isDebugEnabled()) {
                this.this$0.logger.debug("failed to execute on node [{}]", t, new Object[]{node.id()});
            }
            Object response = this.this$0.newNodeResponse(node, new FailedNodeException(node.id(), "Failed node [" + node.id() + "]", t));
            this.nodeResponses.set(idx, response);
            if (this.counter.incrementAndGet() == this.nodeResponses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.nodeResponses);
            }
            catch (Throwable t) {
                this.this$0.logger.debug("failed to combine responses from nodes", t, new Object[0]);
                this.listener.onFailure(t);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }
}

