/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.audit;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.audit.AuditTrailService;
import org.elasticsearch.shield.audit.index.IndexAuditTrail;
import org.elasticsearch.shield.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.shield.support.AbstractShieldModule;

public class AuditTrailModule
extends AbstractShieldModule.Node {
    private final boolean enabled;

    public AuditTrailModule(Settings settings) {
        super(settings);
        this.enabled = AuditTrailModule.auditingEnabled(settings);
    }

    @Override
    protected void configureNode() {
        if (!this.enabled) {
            this.bind(AuditTrail.class).toInstance((Object)AuditTrail.NOOP);
            return;
        }
        Object[] outputs = this.settings.getAsArray("shield.audit.outputs", new String[]{"logfile"});
        if (outputs.length == 0) {
            this.bind(AuditTrail.class).toInstance((Object)AuditTrail.NOOP);
            return;
        }
        this.bind(AuditTrail.class).to(AuditTrailService.class).asEagerSingleton();
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), AuditTrail.class);
        HashSet uniqueOutputs = Sets.newHashSet((Object[])outputs);
        Iterator iterator = uniqueOutputs.iterator();
        block8: while (iterator.hasNext()) {
            String output;
            switch (output = (String)iterator.next()) {
                case "logfile": {
                    binder.addBinding().to(LoggingAuditTrail.class);
                    this.bind(LoggingAuditTrail.class).asEagerSingleton();
                    continue block8;
                }
                case "index": {
                    binder.addBinding().to(IndexAuditTrail.class);
                    this.bind(IndexAuditTrail.class).asEagerSingleton();
                    continue block8;
                }
            }
            throw new ElasticsearchException("unknown audit trail output [" + output + "]", new Object[0]);
        }
    }

    public static boolean auditingEnabled(Settings settings) {
        return settings.getAsBoolean("shield.audit.enabled", Boolean.valueOf(false));
    }

    public static boolean indexAuditLoggingEnabled(Settings settings) {
        if (AuditTrailModule.auditingEnabled(settings)) {
            String[] outputs;
            for (String output : outputs = settings.getAsArray("shield.audit.outputs")) {
                if (!output.equals("index")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean fileAuditLoggingEnabled(Settings settings) {
        if (AuditTrailModule.auditingEnabled(settings)) {
            String[] outputs;
            for (String output : outputs = settings.getAsArray("shield.audit.outputs", new String[]{"logfile"})) {
                if (!output.equals("logfile")) continue;
                return true;
            }
        }
        return false;
    }
}

