/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.audit.index;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.InternalSystemUser;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.audit.AuditUtil;
import org.elasticsearch.shield.audit.index.IndexAuditLevel;
import org.elasticsearch.shield.audit.index.IndexNameResolver;
import org.elasticsearch.shield.audit.index.InternalAuditUser;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.rest.RemoteHostHeader;
import org.elasticsearch.shield.transport.filter.ShieldIpFilterRule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportMessage;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class IndexAuditTrail
extends AbstractComponent
implements AuditTrail,
ClusterStateListener {
    public static final int DEFAULT_BULK_SIZE = 1000;
    public static final int MAX_BULK_SIZE = 10000;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    public static final TimeValue DEFAULT_FLUSH_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final IndexNameResolver.Rollover DEFAULT_ROLLOVER = IndexNameResolver.Rollover.DAILY;
    public static final String NAME = "index";
    public static final String INDEX_NAME_PREFIX = ".shield_audit_log";
    public static final String DOC_TYPE = "event";
    public static final String ROLLOVER_SETTING = "shield.audit.index.rollover";
    public static final String QUEUE_SIZE_SETTING = "shield.audit.index.queue_max_size";
    public static final String INDEX_TEMPLATE_NAME = "shield_audit_log";
    public static final String DEFAULT_CLIENT_NAME = "shield-audit-client";
    static final String[] DEFAULT_EVENT_INCLUDES = new String[]{IndexAuditLevel.ACCESS_DENIED.toString(), IndexAuditLevel.ACCESS_GRANTED.toString(), IndexAuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), IndexAuditLevel.AUTHENTICATION_FAILED.toString(), IndexAuditLevel.CONNECTION_DENIED.toString(), IndexAuditLevel.CONNECTION_GRANTED.toString(), IndexAuditLevel.TAMPERED_REQUEST.toString(), IndexAuditLevel.RUN_AS_DENIED.toString(), IndexAuditLevel.RUN_AS_GRANTED.toString()};
    private static final ImmutableSet<String> forbiddenIndexSettings = ImmutableSet.of((Object)"index.mapper.dynamic");
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final String nodeName;
    private final Provider<Client> clientProvider;
    private final AuthenticationService authenticationService;
    private final BlockingQueue<Message> eventQueue;
    private final QueueConsumer queueConsumer;
    private final Transport transport;
    private final ThreadPool threadPool;
    private final Lock putMappingLock = new ReentrantLock();
    private final ClusterService clusterService;
    private final boolean indexToRemoteCluster;
    private BulkProcessor bulkProcessor;
    private Client client;
    private IndexNameResolver.Rollover rollover;
    private String nodeHostName;
    private String nodeHostAddress;
    private EnumSet<IndexAuditLevel> events;

    @Override
    public String name() {
        return NAME;
    }

    @Inject
    public IndexAuditTrail(Settings settings, AuthenticationService authenticationService, Transport transport, Provider<Client> clientProvider, ThreadPool threadPool, ClusterService clusterService) {
        super(settings);
        this.authenticationService = authenticationService;
        this.clientProvider = clientProvider;
        this.transport = transport;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.nodeName = settings.get("name");
        this.queueConsumer = new QueueConsumer(EsExecutors.threadName((Settings)settings, (String)"audit-queue-consumer"));
        int maxQueueSize = settings.getAsInt(QUEUE_SIZE_SETTING, Integer.valueOf(1000));
        if (maxQueueSize <= 0) {
            this.logger.warn("invalid value [{}] for setting [{}]. using default value [{}]", new Object[]{maxQueueSize, QUEUE_SIZE_SETTING, 1000});
            maxQueueSize = 1000;
        }
        this.eventQueue = this.createQueue(maxQueueSize);
        try {
            this.rollover = IndexNameResolver.Rollover.valueOf(settings.get(ROLLOVER_SETTING, DEFAULT_ROLLOVER.name()).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("invalid value for setting [shield.audit.index.rollover]; falling back to default [{}]", new Object[]{DEFAULT_ROLLOVER.name()});
            this.rollover = DEFAULT_ROLLOVER;
        }
        String[] includedEvents = settings.getAsArray("shield.audit.index.events.include", DEFAULT_EVENT_INCLUDES);
        String[] excludedEvents = settings.getAsArray("shield.audit.index.events.exclude");
        try {
            this.events = IndexAuditLevel.parse(includedEvents, excludedEvents);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("invalid event type specified, using default for audit index output. include events [{}], exclude events [{}]", (Throwable)e, new Object[]{includedEvents, excludedEvents});
            this.events = IndexAuditLevel.parse(DEFAULT_EVENT_INCLUDES, Strings.EMPTY_ARRAY);
        }
        this.indexToRemoteCluster = settings.getByPrefix("shield.audit.index.client.").names().size() > 0;
    }

    public State state() {
        return this.state.get();
    }

    public synchronized boolean canStart(ClusterChangedEvent event, boolean master) {
        if (this.indexToRemoteCluster) {
            try {
                if (this.client == null) {
                    this.initializeClient();
                }
            }
            catch (Exception e) {
                this.logger.error("failed to initialize client for remote indexing. index based output is disabled", (Throwable)e, new Object[0]);
                this.state.set(State.FAILED);
                return false;
            }
            ClusterStateResponse response = (ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet();
            return this.canStart(response.getState(), master);
        }
        return this.canStart(event.state(), master);
    }

    private boolean canStart(ClusterState clusterState, boolean master) {
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("index audit trail waiting until gateway has recovered from disk", new Object[0]);
            return false;
        }
        if (!master && clusterState.metaData().templates().get((Object)INDEX_TEMPLATE_NAME) == null) {
            this.logger.debug("shield audit index template [{}] does not exist, so service cannot start", new Object[]{INDEX_TEMPLATE_NAME});
            return false;
        }
        String index = IndexNameResolver.resolve(INDEX_NAME_PREFIX, DateTime.now((DateTimeZone)DateTimeZone.UTC), this.rollover);
        IndexMetaData metaData = clusterState.metaData().index(index);
        if (metaData == null) {
            this.logger.debug("shield audit index [{}] does not exist, so service can start", new Object[]{index});
            return true;
        }
        if (clusterState.routingTable().index(index).allPrimaryShardsActive()) {
            this.logger.debug("shield audit index [{}] all primary shards started, so service can start", new Object[]{index});
            return true;
        }
        this.logger.debug("shield audit index [{}] does not have all primary shards started, so service cannot start", new Object[]{index});
        return false;
    }

    public void start(boolean master) {
        if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
            this.nodeHostName = this.transport.boundAddress().publishAddress().getHost();
            this.nodeHostAddress = this.transport.boundAddress().publishAddress().getAddress();
            if (this.client == null) {
                this.initializeClient();
            }
            if (master) {
                this.putTemplate(this.customAuditIndexSettings(this.settings));
            }
            this.clusterService.add((ClusterStateListener)this);
            this.initializeBulkProcessor();
            this.queueConsumer.start();
            this.state.set(State.STARTED);
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.queueConsumer.interrupt();
                if (this.bulkProcessor != null) {
                    this.bulkProcessor.flush();
                }
            }
            finally {
                this.state.set(State.STOPPED);
            }
        }
    }

    public void close() {
        if (this.state.get() != State.STOPPED) {
            this.stop();
        }
        try {
            if (this.bulkProcessor != null) {
                this.bulkProcessor.close();
            }
        }
        finally {
            if (this.indexToRemoteCluster && this.client != null) {
                this.client.close();
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", action, null, null, AuditUtil.indices(message), message), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)IndexAuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", null, null, null, null, request), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", action, null, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", null, null, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED) && !InternalAuditUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", action, token, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED) && !InternalAuditUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", null, token, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED) && !InternalAuditUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", action, token, realm, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)IndexAuditLevel.AUTHENTICATION_FAILED) && !InternalAuditUser.is(token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", null, token, realm, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void accessGranted(User user, String action, TransportMessage<?> message) {
        if (InternalSystemUser.is(user) && Privilege.SYSTEM.predicate().apply((Object)action)) {
            if (this.events.contains((Object)IndexAuditLevel.SYSTEM_ACCESS_GRANTED)) {
                try {
                    this.enqueue(this.message("access_granted", action, user, AuditUtil.indices(message), message), "access_granted");
                }
                catch (Exception e) {
                    this.logger.warn("failed to index audit event: [access_granted]", (Throwable)e, new Object[0]);
                }
            }
        } else if (this.events.contains((Object)IndexAuditLevel.ACCESS_GRANTED) && !InternalAuditUser.is(user)) {
            try {
                this.enqueue(this.message("access_granted", action, user, AuditUtil.indices(message), message), "access_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_granted]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void accessDenied(User user, String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.ACCESS_DENIED) && !InternalAuditUser.is(user)) {
            try {
                this.enqueue(this.message("access_denied", action, user, AuditUtil.indices(message), message), "access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_denied]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.TAMPERED_REQUEST)) {
            try {
                this.enqueue(this.message("tampered_request", action, null, AuditUtil.indices(message), message), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage<?> request) {
        if (this.events.contains((Object)IndexAuditLevel.TAMPERED_REQUEST) && !InternalAuditUser.is(user)) {
            try {
                this.enqueue(this.message("tampered_request", action, user, AuditUtil.indices(request), request), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        if (this.events.contains((Object)IndexAuditLevel.CONNECTION_GRANTED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_granted", inetAddress, profile, rule), "connection_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_granted]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, ShieldIpFilterRule rule) {
        if (this.events.contains((Object)IndexAuditLevel.CONNECTION_DENIED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_denied", inetAddress, profile, rule), "connection_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_denied]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void runAsGranted(User user, String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.RUN_AS_GRANTED)) {
            try {
                this.enqueue(this.message("run_as_granted", action, user, null, message), "access_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_granted]", (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public void runAsDenied(User user, String action, TransportMessage<?> message) {
        if (this.events.contains((Object)IndexAuditLevel.RUN_AS_DENIED)) {
            try {
                this.enqueue(this.message("run_as_denied", action, user, null, message), "access_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_denied]", (Throwable)e, new Object[0]);
            }
        }
    }

    private Message message(String type, @Nullable String action, @Nullable User user, @Nullable String[] indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.transport);
        if (action != null) {
            msg.builder.field(Field.ACTION, action);
        }
        if (user != null) {
            if (user.runAs() != null) {
                if ("run_as_granted".equals(type) || "run_as_denied".equals(type)) {
                    msg.builder.field(Field.PRINCIPAL, user.principal());
                    msg.builder.field(Field.RUN_AS_PRINCIPAL, user.runAs().principal());
                } else {
                    msg.builder.field(Field.PRINCIPAL, user.runAs().principal());
                    msg.builder.field(Field.RUN_BY_PRINCIPAL, user.principal());
                }
            } else {
                msg.builder.field(Field.PRINCIPAL, user.principal());
            }
        }
        if (indices != null) {
            msg.builder.array(Field.INDICES, indices);
        }
        msg.builder.field(Field.REQUEST, message.getClass().getSimpleName());
        return msg.end();
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable String[] indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.transport);
        if (action != null) {
            msg.builder.field(Field.ACTION, action);
        }
        if (token != null) {
            msg.builder.field(Field.PRINCIPAL, token.principal());
        }
        if (realm != null) {
            msg.builder.field(Field.REALM, realm);
        }
        if (indices != null) {
            msg.builder.array(Field.INDICES, indices);
        }
        msg.builder.field(Field.REQUEST, message.getClass().getSimpleName());
        return msg.end();
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable String[] indices, RestRequest request) throws Exception {
        Message msg = new Message().start();
        this.common("rest", type, msg.builder);
        if (action != null) {
            msg.builder.field(Field.ACTION, action);
        }
        if (token != null) {
            msg.builder.field(Field.PRINCIPAL, token.principal());
        }
        if (realm != null) {
            msg.builder.field(Field.REALM, realm);
        }
        if (indices != null) {
            msg.builder.array(Field.INDICES, indices);
        }
        msg.builder.field(Field.REQUEST_BODY, AuditUtil.restRequestContent(request));
        msg.builder.field(Field.ORIGIN_TYPE, "rest");
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            msg.builder.field(Field.ORIGIN_ADDRESS, NetworkAddress.formatAddress((InetAddress)((InetSocketAddress)request.getRemoteAddress()).getAddress()));
        } else {
            msg.builder.field(Field.ORIGIN_ADDRESS, (Object)address);
        }
        msg.builder.field(Field.URI, request.uri());
        return msg.end();
    }

    private Message message(String layer, String type, InetAddress originAddress, String profile, ShieldIpFilterRule rule) throws IOException {
        Message msg = new Message().start();
        this.common(layer, type, msg.builder);
        msg.builder.field(Field.ORIGIN_ADDRESS, NetworkAddress.formatAddress((InetAddress)originAddress));
        msg.builder.field(Field.TRANSPORT_PROFILE, profile);
        msg.builder.field(Field.RULE, (Object)rule);
        return msg.end();
    }

    private XContentBuilder common(String layer, String type, XContentBuilder builder) throws IOException {
        builder.field(Field.NODE_NAME, this.nodeName);
        builder.field(Field.NODE_HOST_NAME, this.nodeHostName);
        builder.field(Field.NODE_HOST_ADDRESS, this.nodeHostAddress);
        builder.field(Field.LAYER, layer);
        builder.field(Field.TYPE, type);
        return builder;
    }

    private static XContentBuilder originAttributes(TransportMessage message, XContentBuilder builder, Transport transport) throws IOException {
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(message);
        if (restAddress != null) {
            builder.field(Field.ORIGIN_TYPE, "rest");
            builder.field(Field.ORIGIN_ADDRESS, NetworkAddress.formatAddress((InetAddress)restAddress.getAddress()));
            return builder;
        }
        TransportAddress address = message.remoteAddress();
        if (address != null) {
            builder.field(Field.ORIGIN_TYPE, "transport");
            if (address instanceof InetSocketTransportAddress) {
                builder.field(Field.ORIGIN_ADDRESS, NetworkAddress.formatAddress((InetAddress)((InetSocketTransportAddress)address).address().getAddress()));
            } else {
                builder.field(Field.ORIGIN_ADDRESS, (Object)address);
            }
            return builder;
        }
        builder.field(Field.ORIGIN_TYPE, "local_node");
        builder.field(Field.ORIGIN_ADDRESS, transport.boundAddress().publishAddress().getAddress());
        return builder;
    }

    void enqueue(Message message, String type) {
        boolean accepted;
        State currentState = this.state();
        if (currentState != State.STOPPING && currentState != State.STOPPED && !(accepted = this.eventQueue.offer(message))) {
            this.logger.warn("failed to index audit event: [{}]. queue is full; bulk processor may not be able to keep up or has stopped indexing.", new Object[]{type});
        }
    }

    Message peek() {
        return (Message)this.eventQueue.peek();
    }

    private void initializeClient() {
        if (!this.indexToRemoteCluster) {
            this.client = (Client)this.clientProvider.get();
        } else {
            Settings clientSettings = this.settings.getByPrefix("shield.audit.index.client.");
            String[] hosts = clientSettings.getAsArray("hosts");
            if (hosts.length == 0) {
                throw new ElasticsearchException("missing required setting [shield.audit.index.client.hosts] for remote audit log indexing", new Object[0]);
            }
            if (clientSettings.get("cluster.name", "").isEmpty()) {
                throw new ElasticsearchException("missing required setting [shield.audit.index.client.cluster.name] for remote audit log indexing", new Object[0]);
            }
            ArrayList<Tuple> hostPortPairs = new ArrayList<Tuple>();
            for (String host : hosts) {
                List hostPort = Splitter.on((String)":").splitToList((CharSequence)host.trim());
                if (hostPort.size() != 1 && hostPort.size() != 2) {
                    this.logger.warn("invalid host:port specified: [{}] for setting [shield.audit.index.client.hosts]", new Object[]{host});
                }
                hostPortPairs.add(new Tuple(hostPort.get(0), (Object)(hostPort.size() == 2 ? Integer.valueOf((String)hostPort.get(1)) : 9300)));
            }
            if (hostPortPairs.size() == 0) {
                throw new ElasticsearchException("no valid host:port pairs specified for setting [shield.audit.index.client.hosts]", new Object[0]);
            }
            TransportClient transportClient = TransportClient.builder().settings(Settings.builder().put("name", "shield-audit-client-" + this.settings.get("name")).put(clientSettings)).addPlugin(ShieldPlugin.class).build();
            for (Tuple pair : hostPortPairs) {
                try {
                    transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName((String)pair.v1()), ((Integer)pair.v2()).intValue()));
                }
                catch (UnknownHostException e) {
                    throw new ElasticsearchException("could not find host {}", (Throwable)e, new Object[]{pair.v1()});
                }
            }
            this.client = transportClient;
            this.logger.info("forwarding audit events to remote cluster [{}] using hosts [{}]", new Object[]{clientSettings.get("cluster.name", ""), ((Object)hostPortPairs).toString()});
        }
    }

    Settings customAuditIndexSettings(Settings nodeSettings) {
        Settings newSettings = Settings.builder().put(nodeSettings.getAsSettings("shield.audit.index.settings.index")).build();
        if (newSettings.names().isEmpty()) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        for (Map.Entry entry : newSettings.getAsMap().entrySet()) {
            String name = "index." + (String)entry.getKey();
            if (forbiddenIndexSettings.contains((Object)name)) {
                this.logger.warn("overriding the default [{}} setting is forbidden. ignoring...", new Object[]{name});
                continue;
            }
            builder.put(name, (String)entry.getValue());
        }
        return builder.build();
    }

    void putTemplate(Settings customSettings) {
        try (InputStream is = this.getClass().getResourceAsStream("/shield_audit_log.json");){
            PutIndexTemplateResponse response;
            byte[] template = ByteStreams.toByteArray((InputStream)is);
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(INDEX_TEMPLATE_NAME).source(template);
            if (customSettings != null && customSettings.names().size() > 0) {
                Settings updatedSettings = Settings.builder().put(request.settings()).put(customSettings).build();
                request.settings(updatedSettings);
            }
            assert (!Thread.currentThread().isInterrupted()) : "current thread has been interrupted before putting index template!!!";
            if (!this.indexToRemoteCluster) {
                this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)request, InternalAuditUser.INSTANCE);
            }
            if (!(response = (PutIndexTemplateResponse)this.client.admin().indices().putTemplate(request).actionGet()).isAcknowledged()) {
                throw new IllegalStateException("failed to put index template for audit logging");
            }
            Message message = (Message)this.eventQueue.peek();
            DateTime dateTime = message != null ? message.timestamp : DateTime.now((DateTimeZone)DateTimeZone.UTC);
            String index = IndexNameResolver.resolve(INDEX_NAME_PREFIX, dateTime, this.rollover);
            IndicesExistsRequest existsRequest = new IndicesExistsRequest(new String[]{index});
            if (!this.indexToRemoteCluster) {
                this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)existsRequest, InternalAuditUser.INSTANCE);
            }
            if (((IndicesExistsResponse)this.client.admin().indices().exists(existsRequest).get()).isExists()) {
                PutMappingResponse putMappingResponse;
                this.logger.debug("index [{}] exists so we need to update mappings", new Object[]{index});
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index}).type(DOC_TYPE).source((String)request.mappings().get(DOC_TYPE));
                if (!this.indexToRemoteCluster) {
                    this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)putMappingRequest, InternalAuditUser.INSTANCE);
                }
                if (!(putMappingResponse = (PutMappingResponse)this.client.admin().indices().putMapping(putMappingRequest).get()).isAcknowledged()) {
                    throw new IllegalStateException("failed to put mappings for audit logging index [" + index + "]");
                }
            } else {
                this.logger.debug("index [{}] does not exist so we do not need to update mappings", new Object[]{index});
            }
        }
        catch (Exception e) {
            this.logger.debug("unexpected exception while putting index template", (Throwable)e, new Object[0]);
            throw new IllegalStateException("failed to load [shield_audit_log.json]", e);
        }
    }

    BlockingQueue<Message> createQueue(int maxQueueSize) {
        return new LinkedBlockingQueue<Message>(maxQueueSize);
    }

    private void initializeBulkProcessor() {
        int bulkSize = Math.min(this.settings.getAsInt("shield.audit.index.bulk_size", Integer.valueOf(1000)), 10000);
        bulkSize = bulkSize < 1 ? 1000 : bulkSize;
        TimeValue interval = this.settings.getAsTime("shield.audit.index.flush_interval", DEFAULT_FLUSH_INTERVAL);
        interval = interval.millis() < 1L ? DEFAULT_FLUSH_INTERVAL : interval;
        this.bulkProcessor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                try {
                    if (!IndexAuditTrail.this.indexToRemoteCluster) {
                        IndexAuditTrail.this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)request, InternalAuditUser.INSTANCE);
                    }
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to attach user header", (Throwable)e, new Object[0]);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    IndexAuditTrail.this.logger.info("failed to bulk index audit events: [{}]", new Object[]{response.buildFailureMessage()});
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                IndexAuditTrail.this.logger.error("failed to bulk index audit events: [{}]", failure, new Object[]{failure.getMessage()});
            }
        }).setBulkActions(bulkSize).setFlushInterval(interval).setConcurrentRequests(1).build();
    }

    public void clusterChanged(ClusterChangedEvent clusterChangedEvent) {
        State state = this.state();
        if (state != State.STARTED || this.indexToRemoteCluster) {
            return;
        }
        if (!clusterChangedEvent.localNodeMaster()) {
            return;
        }
        if (clusterChangedEvent.state().metaData().templates().get((Object)INDEX_TEMPLATE_NAME) == null) {
            this.logger.debug("shield audit index template [{}] does not exist. it may have been deleted - putting the template", new Object[]{INDEX_TEMPLATE_NAME});
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Throwable throwable) {
                    IndexAuditTrail.this.logger.error("failed to update shield audit index template [{}]", throwable, new Object[]{IndexAuditTrail.INDEX_TEMPLATE_NAME});
                }

                protected void doRun() throws Exception {
                    boolean locked = IndexAuditTrail.this.putMappingLock.tryLock();
                    if (locked) {
                        try {
                            IndexAuditTrail.this.putTemplate(IndexAuditTrail.this.customAuditIndexSettings(IndexAuditTrail.this.settings));
                        }
                        finally {
                            IndexAuditTrail.this.putMappingLock.unlock();
                        }
                    } else {
                        IndexAuditTrail.this.logger.trace("unable to PUT shield audit index template as the lock is already held", new Object[0]);
                    }
                }
            });
        }
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }

    static interface Field {
        public static final XContentBuilderString TIMESTAMP = new XContentBuilderString("@timestamp");
        public static final XContentBuilderString NODE_NAME = new XContentBuilderString("node_name");
        public static final XContentBuilderString NODE_HOST_NAME = new XContentBuilderString("node_host_name");
        public static final XContentBuilderString NODE_HOST_ADDRESS = new XContentBuilderString("node_host_address");
        public static final XContentBuilderString LAYER = new XContentBuilderString("layer");
        public static final XContentBuilderString TYPE = new XContentBuilderString("event_type");
        public static final XContentBuilderString ORIGIN_ADDRESS = new XContentBuilderString("origin_address");
        public static final XContentBuilderString ORIGIN_TYPE = new XContentBuilderString("origin_type");
        public static final XContentBuilderString PRINCIPAL = new XContentBuilderString("principal");
        public static final XContentBuilderString RUN_AS_PRINCIPAL = new XContentBuilderString("run_as_principal");
        public static final XContentBuilderString RUN_BY_PRINCIPAL = new XContentBuilderString("run_by_principal");
        public static final XContentBuilderString ACTION = new XContentBuilderString("action");
        public static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        public static final XContentBuilderString REQUEST = new XContentBuilderString("request");
        public static final XContentBuilderString REQUEST_BODY = new XContentBuilderString("request_body");
        public static final XContentBuilderString URI = new XContentBuilderString("uri");
        public static final XContentBuilderString REALM = new XContentBuilderString("realm");
        public static final XContentBuilderString TRANSPORT_PROFILE = new XContentBuilderString("transport_profile");
        public static final XContentBuilderString RULE = new XContentBuilderString("rule");
    }

    static class Message {
        final DateTime timestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        final XContentBuilder builder = XContentFactory.jsonBuilder();

        Message() throws IOException {
        }

        Message start() throws IOException {
            this.builder.startObject();
            this.builder.field(Field.TIMESTAMP, (ReadableInstant)this.timestamp);
            return this;
        }

        Message end() throws IOException {
            this.builder.endObject();
            return this;
        }
    }

    private class QueueConsumer
    extends Thread {
        volatile boolean running;

        QueueConsumer(String name) {
            super(name);
            this.running = true;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Message message = (Message)IndexAuditTrail.this.eventQueue.take();
                    IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)IndexAuditTrail.this.client.prepareIndex().setIndex(IndexNameResolver.resolve(IndexAuditTrail.INDEX_NAME_PREFIX, message.timestamp, IndexAuditTrail.this.rollover))).setType(IndexAuditTrail.DOC_TYPE).setSource(message.builder).request();
                    if (!IndexAuditTrail.this.indexToRemoteCluster) {
                        IndexAuditTrail.this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)indexRequest, InternalAuditUser.INSTANCE);
                    }
                    IndexAuditTrail.this.bulkProcessor.add(indexRequest);
                }
                catch (InterruptedException e) {
                    IndexAuditTrail.this.logger.debug("index audit queue consumer interrupted", (Throwable)e, new Object[0]);
                    this.running = false;
                    return;
                }
                catch (Exception e) {
                    IndexAuditTrail.this.logger.warn("failed to index audit message from queue", (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

