/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esusers;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.support.NoOpLogger;
import org.elasticsearch.shield.support.ShieldFiles;
import org.elasticsearch.shield.support.Validation;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public class FileUserRolesStore {
    private static final Pattern USERS_DELIM = Pattern.compile("\\s*,\\s*");
    private final ESLogger logger;
    private final Path file;
    private CopyOnWriteArrayList<RefreshListener> listeners;
    private volatile ImmutableMap<String, String[]> userRoles;

    public FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, null);
    }

    FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService, RefreshListener listener) {
        this.logger = config.logger(FileUserRolesStore.class);
        this.file = FileUserRolesStore.resolveFile(config.settings(), config.env());
        this.userRoles = FileUserRolesStore.parseFileLenient(this.file, this.logger);
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching the user roles file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
        this.listeners = new CopyOnWriteArrayList();
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void addListener(RefreshListener listener) {
        this.listeners.add(listener);
    }

    int entriesCount() {
        return this.userRoles.size();
    }

    public String[] roles(String username) {
        if (this.userRoles == null) {
            return Strings.EMPTY_ARRAY;
        }
        String[] roles = (String[])this.userRoles.get((Object)username);
        return roles == null ? Strings.EMPTY_ARRAY : (String[])this.userRoles.get((Object)username);
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = settings.get("files.users_roles");
        if (location == null) {
            return ShieldPlugin.resolveConfigFile(env, "users_roles");
        }
        return env.binFile().getParent().resolve(location);
    }

    static ImmutableMap<String, String[]> parseFileLenient(Path path, ESLogger logger) {
        try {
            return FileUserRolesStore.parseFile(path, logger);
        }
        catch (Throwable t) {
            logger.error("failed to parse users_roles file [{}]. skipping/removing all entries...", t, new Object[]{path.toAbsolutePath()});
            return ImmutableMap.of();
        }
    }

    public static ImmutableMap<String, String[]> parseFile(Path path, @Nullable ESLogger logger) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users_roles file [{}]...", new Object[]{path.toAbsolutePath()});
        if (!Files.exists(path, new LinkOption[0])) {
            return ImmutableMap.of();
        }
        try {
            lines = Files.readAllLines(path, Charsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not read users file [" + path.toAbsolutePath() + "]", (Throwable)ioe, new Object[0]);
        }
        HashMap<String, ArrayList<String>> userToRoles = new HashMap<String, ArrayList<String>>();
        int lineNr = 0;
        for (String string : lines) {
            ++lineNr;
            if (string.startsWith("#")) continue;
            int n = string.indexOf(":");
            if (n <= 0 || n == string.length() - 1) {
                logger.error("invalid entry in users_roles file [{}], line [{}]. skipping...", new Object[]{path.toAbsolutePath(), lineNr});
                continue;
            }
            String role = string.substring(0, n).trim();
            Validation.Error validationError = Validation.Roles.validateRoleName(role);
            if (validationError != null) {
                logger.error("invalid role entry in users_roles file [{}], line [{}] - {}. skipping...", new Object[]{path.toAbsolutePath(), lineNr, validationError});
                continue;
            }
            String usersStr = string.substring(n + 1).trim();
            if (Strings.isEmpty((CharSequence)usersStr)) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", new Object[]{role, path.toAbsolutePath(), lineNr});
                continue;
            }
            String[] roleUsers = USERS_DELIM.split(usersStr);
            if (roleUsers.length == 0) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", new Object[]{role, path.toAbsolutePath(), lineNr});
                continue;
            }
            for (String user : roleUsers) {
                ArrayList<String> roles = (ArrayList<String>)userToRoles.get(user);
                if (roles == null) {
                    roles = new ArrayList<String>();
                    userToRoles.put(user, roles);
                }
                roles.add(role);
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : userToRoles.entrySet()) {
            builder.put(entry.getKey(), (Object)((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap.isEmpty()) {
            logger.warn("no entries found in users_roles file [{}]. use bin/shield/esusers to add users and role mappings", new Object[]{path.toAbsolutePath()});
        }
        return immutableMap;
    }

    public static void writeFile(Map<String, String[]> userToRoles, Path path) {
        HashMap<Object, ArrayList<String>> roleToUsers = new HashMap<Object, ArrayList<String>>();
        for (Map.Entry<String, String[]> entry : userToRoles.entrySet()) {
            for (String role : entry.getValue()) {
                ArrayList<String> users = (ArrayList<String>)roleToUsers.get(role);
                if (users == null) {
                    users = new ArrayList<String>();
                    roleToUsers.put(role, users);
                }
                users.add(entry.getKey());
            }
        }
        try (PrintWriter writer = new PrintWriter(ShieldFiles.openAtomicMoveWriter(path));){
            for (Map.Entry entry : roleToUsers.entrySet()) {
                writer.printf(Locale.ROOT, "%s:%s%s", entry.getKey(), Strings.collectionToCommaDelimitedString((Iterable)((Iterable)entry.getValue())), System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not write file [" + path.toAbsolutePath() + "], please check file permissions", (Throwable)ioe, new Object[0]);
        }
    }

    public void notifyRefresh() {
        for (RefreshListener listener : this.listeners) {
            listener.onRefresh();
        }
    }

    private class FileListener
    extends FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileUserRolesStore.this.file)) {
                FileUserRolesStore.this.logger.info("users_roles file [{}] changed. updating users roles...", new Object[]{file.toAbsolutePath()});
                FileUserRolesStore.this.userRoles = FileUserRolesStore.parseFileLenient(file, FileUserRolesStore.this.logger);
                FileUserRolesStore.this.notifyRefresh();
            }
        }
    }
}

