/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.pki;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.pki.X509AuthenticationToken;
import org.elasticsearch.shield.authc.support.DnRoleMapper;
import org.elasticsearch.shield.transport.SSLClientAuth;
import org.elasticsearch.shield.transport.netty.ShieldNettyHttpServerTransport;
import org.elasticsearch.shield.transport.netty.ShieldNettyTransport;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.watcher.ResourceWatcherService;

public class PkiRealm
extends Realm<X509AuthenticationToken> {
    public static final String PKI_CERT_HEADER_NAME = "__SHIELD_CLIENT_CERTIFICATE";
    public static final String TYPE = "pki";
    public static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    public static final String AUTH_TYPE = "UNKNOWN";
    private final X509TrustManager[] trustManagers;
    private final Pattern principalPattern;
    private final DnRoleMapper roleMapper;

    public PkiRealm(RealmConfig config, DnRoleMapper roleMapper) {
        super(TYPE, config);
        this.trustManagers = PkiRealm.trustManagers(config.settings(), config.env());
        this.principalPattern = Pattern.compile(config.settings().get("username_pattern", DEFAULT_USERNAME_PATTERN), 2);
        this.roleMapper = roleMapper;
        PkiRealm.checkSSLEnabled(config, this.logger);
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    @Override
    public X509AuthenticationToken token(RestRequest request) {
        return PkiRealm.token(request.getFromContext((Object)PKI_CERT_HEADER_NAME), this.principalPattern, this.logger);
    }

    @Override
    public X509AuthenticationToken token(TransportMessage<?> message) {
        return PkiRealm.token(message.getFromContext((Object)PKI_CERT_HEADER_NAME), this.principalPattern, this.logger);
    }

    @Override
    public User authenticate(X509AuthenticationToken token) {
        if (!PkiRealm.isCertificateChainTrusted(this.trustManagers, token, this.logger)) {
            return null;
        }
        Set<String> roles = this.roleMapper.resolveRoles(token.dn(), Collections.emptyList());
        return new User(token.principal(), roles.toArray(new String[roles.size()]));
    }

    @Override
    public User lookupUser(String username) {
        return null;
    }

    @Override
    public boolean userLookupSupported() {
        return false;
    }

    static X509AuthenticationToken token(Object pkiHeaderValue, Pattern principalPattern, ESLogger logger) {
        if (pkiHeaderValue == null) {
            return null;
        }
        assert (pkiHeaderValue instanceof X509Certificate[]);
        X509Certificate[] certificates = (X509Certificate[])pkiHeaderValue;
        if (certificates.length == 0) {
            return null;
        }
        String dn = certificates[0].getSubjectX500Principal().toString();
        Matcher matcher = principalPattern.matcher(dn);
        if (!matcher.find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but could not extract principal from DN", new Object[]{dn});
            }
            return null;
        }
        String principal = matcher.group(1);
        if (Strings.isNullOrEmpty((String)principal)) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but extracted principal was empty", new Object[]{dn});
            }
            return null;
        }
        return new X509AuthenticationToken(certificates, principal, dn);
    }

    static boolean isCertificateChainTrusted(X509TrustManager[] trustManagers, X509AuthenticationToken token, ESLogger logger) {
        if (trustManagers.length > 0) {
            boolean trusted = false;
            for (X509TrustManager trustManager : trustManagers) {
                try {
                    trustManager.checkClientTrusted(token.credentials(), AUTH_TYPE);
                    trusted = true;
                    break;
                }
                catch (CertificateException e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("failed certificate validation for principal [{}]", (Throwable)e, new Object[]{token.principal()});
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("failed certificate validation for principal [{}]", new Object[]{token.principal()});
                }
            }
            return trusted;
        }
        return true;
    }

    static X509TrustManager[] trustManagers(Settings settings, Environment env) {
        TrustManager[] trustManagers;
        String truststorePath = settings.get("truststore.path");
        if (truststorePath == null) {
            return new X509TrustManager[0];
        }
        String password = settings.get("truststore.password");
        if (password == null) {
            throw new IllegalArgumentException("no truststore password configured");
        }
        String trustStoreAlgorithm = settings.get("truststore.algorithm", System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
        try {
            TrustManager[] trustManagerArray = null;
            try (InputStream in = Files.newInputStream(env.binFile().getParent().resolve(truststorePath), new OpenOption[0]);){
                KeyStore ks = KeyStore.getInstance("jks");
                ks.load(in, password.toCharArray());
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustStoreAlgorithm);
                trustFactory.init(ks);
                trustManagers = trustFactory.getTrustManagers();
            }
            catch (Throwable object) {
                trustManagerArray = object;
                throw object;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to load specified truststore", e);
        }
        ArrayList<X509TrustManager> trustManagerList = new ArrayList<X509TrustManager>();
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            trustManagerList.add((X509TrustManager)trustManager);
        }
        if (trustManagerList.isEmpty()) {
            throw new IllegalArgumentException("no valid certificates found in truststore");
        }
        return trustManagerList.toArray(new X509TrustManager[trustManagerList.size()]);
    }

    static void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
        filter.filterOut("shield.authc.realms." + realmName + "." + "truststore.password");
        filter.filterOut("shield.authc.realms." + realmName + "." + "truststore.path");
        filter.filterOut("shield.authc.realms." + realmName + "." + "truststore.algorithm");
    }

    static void checkSSLEnabled(RealmConfig config, ESLogger logger) {
        Settings settings = config.globalSettings();
        if (settings.getAsBoolean("shield.http.ssl", Boolean.valueOf(false)).booleanValue() && SSLClientAuth.parse(settings.get("shield.http.ssl.client.auth"), ShieldNettyHttpServerTransport.HTTP_CLIENT_AUTH_DEFAULT).enabled()) {
            return;
        }
        boolean ssl = settings.getAsBoolean("shield.transport.ssl", Boolean.valueOf(false));
        SSLClientAuth clientAuth = SSLClientAuth.parse(settings.get("shield.transport.ssl.client.auth"), ShieldNettyTransport.TRANSPORT_CLIENT_AUTH_DEFAULT);
        if (ssl && clientAuth.enabled()) {
            return;
        }
        Map groupedSettings = settings.getGroups("transport.profiles.");
        for (Map.Entry entry : groupedSettings.entrySet()) {
            Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("shield.filter.");
            if (!profileSettings.getAsBoolean("shield.ssl", Boolean.valueOf(ssl)).booleanValue() || !SSLClientAuth.parse(profileSettings.get("shield.transport.ssl.client.auth"), clientAuth).enabled()) continue;
            return;
        }
        logger.error("PKI realm [{}] is enabled but cannot be used as neither HTTP or Transport have both SSL and client authentication enabled", new Object[]{config.name()});
    }

    public static class Factory
    extends Realm.Factory<PkiRealm> {
        private final ResourceWatcherService watcherService;

        @Inject
        public Factory(ResourceWatcherService watcherService) {
            super(PkiRealm.TYPE, false);
            this.watcherService = watcherService;
        }

        @Override
        public void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
            PkiRealm.filterOutSensitiveSettings(realmName, filter);
        }

        @Override
        public PkiRealm create(RealmConfig config) {
            DnRoleMapper roleMapper = new DnRoleMapper(PkiRealm.TYPE, config, this.watcherService, null);
            return new PkiRealm(config, roleMapper);
        }

        @Override
        public PkiRealm createDefault(String name) {
            return null;
        }
    }
}

