/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.support;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;

public class CharArrays {
    public static char[] utf8BytesToChars(byte[] utf8Bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(utf8Bytes);
        CharBuffer charBuffer = Charsets.UTF_8.decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        byteBuffer.clear();
        charBuffer.clear();
        return chars;
    }

    static int indexOf(char[] array, char ch) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static byte[] toUtf8Bytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static boolean charsBeginsWith(String prefix, char[] chars) {
        if (chars == null || prefix == null) {
            return false;
        }
        if (prefix.length() > chars.length) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (chars[i] == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

