/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.InternalSystemUser;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.authc.AnonymousService;
import org.elasticsearch.shield.authc.AuthenticationFailureHandler;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.shield.authz.indicesresolver.DefaultIndicesAndAliasesResolver;
import org.elasticsearch.shield.authz.indicesresolver.IndicesAndAliasesResolver;
import org.elasticsearch.shield.authz.store.RolesStore;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public class InternalAuthorizationService
extends AbstractComponent
implements AuthorizationService {
    public static final String INDICES_PERMISSIONS_KEY = "_indices_permissions";
    private static final Predicate<String> MONITOR_INDEX_PREDICATE = Privilege.Index.MONITOR.predicate();
    private final ClusterService clusterService;
    private final RolesStore rolesStore;
    private final AuditTrail auditTrail;
    private final IndicesAndAliasesResolver[] indicesAndAliasesResolvers;
    private final AnonymousService anonymousService;
    private final AuthenticationFailureHandler authcFailureHandler;

    @Inject
    public InternalAuthorizationService(Settings settings, RolesStore rolesStore, ClusterService clusterService, AuditTrail auditTrail, AnonymousService anonymousService, AuthenticationFailureHandler authcFailureHandler, IndexNameExpressionResolver nameExpressionResolver) {
        super(settings);
        this.rolesStore = rolesStore;
        this.clusterService = clusterService;
        this.auditTrail = auditTrail;
        this.indicesAndAliasesResolvers = new IndicesAndAliasesResolver[]{new DefaultIndicesAndAliasesResolver(this, nameExpressionResolver)};
        this.anonymousService = anonymousService;
        this.authcFailureHandler = authcFailureHandler;
    }

    @Override
    public List<String> authorizedIndicesAndAliases(User user, String action) {
        String[] roles = user.roles();
        if (roles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        for (String role : roles) {
            Permission.Global.Role global = this.rolesStore.role(role);
            if (global == null) continue;
            predicates.add(global.indices().allowedIndicesMatcher(action));
        }
        ArrayList<String> indicesAndAliases = new ArrayList<String>();
        Predicate predicate = Predicates.or(predicates);
        MetaData metaData = this.clusterService.state().metaData();
        for (Map.Entry entry : metaData.getAliasAndIndexLookup().entrySet()) {
            String aliasOrIndex = (String)entry.getKey();
            if (!predicate.apply((Object)aliasOrIndex)) continue;
            indicesAndAliases.add(aliasOrIndex);
        }
        if (!InternalShieldUser.is(user) && indicesAndAliases.remove(".security")) {
            this.logger.debug("removed [{}] from user [{}] list of authorized indices", new Object[]{".security", user.principal()});
        }
        return Collections.unmodifiableList(indicesAndAliases);
    }

    @Override
    public void authorize(User user, String action, TransportRequest request) throws ElasticsearchSecurityException {
        boolean isRunAs;
        if (InternalSystemUser.is(user)) {
            if (InternalSystemUser.isAuthorized(action)) {
                request.putInContext((Object)INDICES_PERMISSIONS_KEY, (Object)IndicesAccessControl.ALLOW_ALL);
                this.grant(user, action, request);
                return;
            }
            throw this.denial(user, action, request);
        }
        Permission.Global permission = this.permission(user.roles());
        boolean bl = isRunAs = user.runAs() != null;
        if (permission == null || permission.isEmpty()) {
            if (isRunAs) {
                throw this.denyRunAs(user, action, request);
            }
            throw this.denial(user, action, request);
        }
        if (isRunAs) {
            Permission.RunAs runAs = permission.runAs();
            if (runAs != null && runAs.check(user.runAs().principal())) {
                this.grantRunAs(user, action, request);
                permission = this.permission(user.runAs().roles());
                if (permission == null || permission.isEmpty()) {
                    throw this.denial(user, action, request);
                }
            } else {
                throw this.denyRunAs(user, action, request);
            }
        }
        if (Privilege.Cluster.ACTION_MATCHER.apply((Object)action)) {
            Permission.Cluster cluster = permission.cluster();
            if (cluster != null && cluster.check(action)) {
                request.putInContext((Object)INDICES_PERMISSIONS_KEY, (Object)IndicesAccessControl.ALLOW_ALL);
                this.grant(user, action, request);
                return;
            }
            throw this.denial(user, action, request);
        }
        if (!Privilege.Index.ACTION_MATCHER.apply((Object)action)) {
            throw this.denial(user, action, request);
        }
        if (!(request instanceof IndicesRequest) && !(request instanceof CompositeIndicesRequest)) {
            if (InternalAuthorizationService.isScrollRelatedAction(action)) {
                this.grant(user, action, request);
                return;
            }
            assert (false) : "only scroll related requests are known indices api that don't support retrieving the indices they relate to";
            throw this.denial(user, action, request);
        }
        if (permission.indices() == null || permission.indices().isEmpty()) {
            throw this.denial(user, action, request);
        }
        ClusterState clusterState = this.clusterService.state();
        Set<String> indexNames = this.resolveIndices(user, action, request, clusterState);
        assert (!indexNames.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
        MetaData metaData = clusterState.metaData();
        IndicesAccessControl indicesAccessControl = permission.authorize(action, indexNames, metaData);
        if (!indicesAccessControl.isGranted()) {
            throw this.denial(user, action, request);
        }
        if (indicesAccessControl.getIndexPermissions(".security") != null && indicesAccessControl.getIndexPermissions(".security").isGranted() && !InternalShieldUser.is(user) && !MONITOR_INDEX_PREDICATE.apply((Object)action)) {
            this.logger.debug("user [{}] attempted to directly perform [{}] against the security index [{}]", new Object[]{user.principal(), action, ".security"});
            throw this.denial(user, action, request);
        }
        request.putInContext((Object)INDICES_PERMISSIONS_KEY, (Object)indicesAccessControl);
        if (Privilege.Index.CREATE_INDEX_MATCHER.apply((Object)action)) {
            assert (request instanceof CreateIndexRequest);
            Set aliases = ((CreateIndexRequest)request).aliases();
            if (!aliases.isEmpty()) {
                HashSet aliasesAndIndices = Sets.newHashSet(indexNames);
                for (Alias alias : aliases) {
                    aliasesAndIndices.add(alias.name());
                }
                indicesAccessControl = permission.authorize("indices:admin/aliases", aliasesAndIndices, metaData);
                if (!indicesAccessControl.isGranted()) {
                    throw this.denial(user, "indices:admin/aliases", request);
                }
            }
        }
        this.grant(user, action, request);
    }

    private Permission.Global permission(String[] roleNames) {
        if (roleNames.length == 0) {
            return Permission.Global.NONE;
        }
        if (roleNames.length == 1) {
            Permission.Global.Role role = this.rolesStore.role(roleNames[0]);
            return role == null ? Permission.Global.NONE : role;
        }
        Permission.Global.Compound.Builder roles = Permission.Global.Compound.builder();
        for (String roleName : roleNames) {
            Permission.Global.Role role = this.rolesStore.role(roleName);
            if (role == null) continue;
            roles.add(role);
        }
        return roles.build();
    }

    private Set<String> resolveIndices(User user, String action, TransportRequest request, ClusterState clusterState) {
        MetaData metaData = clusterState.metaData();
        for (IndicesAndAliasesResolver resolver : this.indicesAndAliasesResolvers) {
            if (!resolver.requestType().isInstance(request)) continue;
            return resolver.resolve(user, action, request, metaData);
        }
        assert (false) : "we should be able to resolve indices for any known request that requires indices privileges";
        throw this.denial(user, action, request);
    }

    private static boolean isScrollRelatedAction(String action) {
        return action.equals("indices:data/read/scroll") || action.equals("indices:data/read/search[phase/scan/scroll]") || action.equals("indices:data/read/search[phase/fetch/id/scroll]") || action.equals("indices:data/read/search[phase/query+fetch/scroll]") || action.equals("indices:data/read/search[phase/query/scroll]") || action.equals("indices:data/read/search[free_context/scroll]") || action.equals("indices:data/read/scroll/clear") || action.equals("indices:data/read/search[clear_scroll_contexts]");
    }

    private ElasticsearchSecurityException denial(User user, String action, TransportRequest request) {
        this.auditTrail.accessDenied(user, action, (TransportMessage<?>)request);
        return this.denialException(user, action);
    }

    private ElasticsearchSecurityException denyRunAs(User user, String action, TransportRequest request) {
        this.auditTrail.runAsDenied(user, action, (TransportMessage<?>)request);
        return this.denialException(user, action);
    }

    private void grant(User user, String action, TransportRequest request) {
        this.auditTrail.accessGranted(user, action, (TransportMessage<?>)request);
    }

    private void grantRunAs(User user, String action, TransportRequest request) {
        this.auditTrail.runAsGranted(user, action, (TransportMessage<?>)request);
    }

    private ElasticsearchSecurityException denialException(User user, String action) {
        if (this.anonymousService.isAnonymous(user) && !this.anonymousService.authorizationExceptionsEnabled()) {
            throw this.authcFailureHandler.authenticationRequired(action);
        }
        if (user.runAs() != null) {
            return Exceptions.authorizationError("action [{}] is unauthorized for user [{}] run as [{}]", action, user.principal(), user.runAs().principal());
        }
        return Exceptions.authorizationError("action [{}] is unauthorized for user [{}]", action, user.principal());
    }
}

