/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.client;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.shield.action.realm.ClearRealmCacheAction;
import org.elasticsearch.shield.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.shield.action.realm.ClearRealmCacheRequestBuilder;
import org.elasticsearch.shield.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.shield.action.role.ClearRolesCacheAction;
import org.elasticsearch.shield.action.role.ClearRolesCacheRequest;
import org.elasticsearch.shield.action.role.ClearRolesCacheRequestBuilder;
import org.elasticsearch.shield.action.role.ClearRolesCacheResponse;
import org.elasticsearch.shield.action.role.DeleteRoleAction;
import org.elasticsearch.shield.action.role.DeleteRoleRequest;
import org.elasticsearch.shield.action.role.DeleteRoleRequestBuilder;
import org.elasticsearch.shield.action.role.DeleteRoleResponse;
import org.elasticsearch.shield.action.role.GetRolesAction;
import org.elasticsearch.shield.action.role.GetRolesRequest;
import org.elasticsearch.shield.action.role.GetRolesRequestBuilder;
import org.elasticsearch.shield.action.role.GetRolesResponse;
import org.elasticsearch.shield.action.role.PutRoleAction;
import org.elasticsearch.shield.action.role.PutRoleRequest;
import org.elasticsearch.shield.action.role.PutRoleRequestBuilder;
import org.elasticsearch.shield.action.role.PutRoleResponse;
import org.elasticsearch.shield.action.user.DeleteUserAction;
import org.elasticsearch.shield.action.user.DeleteUserRequest;
import org.elasticsearch.shield.action.user.DeleteUserRequestBuilder;
import org.elasticsearch.shield.action.user.DeleteUserResponse;
import org.elasticsearch.shield.action.user.GetUsersAction;
import org.elasticsearch.shield.action.user.GetUsersRequest;
import org.elasticsearch.shield.action.user.GetUsersRequestBuilder;
import org.elasticsearch.shield.action.user.GetUsersResponse;
import org.elasticsearch.shield.action.user.PutUserAction;
import org.elasticsearch.shield.action.user.PutUserRequest;
import org.elasticsearch.shield.action.user.PutUserRequestBuilder;
import org.elasticsearch.shield.action.user.PutUserResponse;
import org.elasticsearch.shield.client.ShieldAuthcClient;

public class ShieldClient {
    private final ElasticsearchClient client;
    private final ShieldAuthcClient authcClient;

    public ShieldClient(ElasticsearchClient client) {
        this.client = client;
        this.authcClient = new ShieldAuthcClient(client);
    }

    @Deprecated
    public ShieldAuthcClient authc() {
        return this.authcClient;
    }

    public ClearRealmCacheRequestBuilder prepareClearRealmCache() {
        return new ClearRealmCacheRequestBuilder(this.client);
    }

    public void clearRealmCache(ClearRealmCacheRequest request, ActionListener<ClearRealmCacheResponse> listener) {
        this.client.execute((Action)ClearRealmCacheAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ClearRealmCacheResponse> clearRealmCache(ClearRealmCacheRequest request) {
        return this.client.execute((Action)ClearRealmCacheAction.INSTANCE, (ActionRequest)request);
    }

    public ClearRolesCacheRequestBuilder prepareClearRolesCache() {
        return new ClearRolesCacheRequestBuilder(this.client);
    }

    public void clearRolesCache(ClearRolesCacheRequest request, ActionListener<ClearRolesCacheResponse> listener) {
        this.client.execute((Action)ClearRolesCacheAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ClearRolesCacheResponse> clearRolesCache(ClearRolesCacheRequest request) {
        return this.client.execute((Action)ClearRolesCacheAction.INSTANCE, (ActionRequest)request);
    }

    public GetUsersRequestBuilder prepareGetUsers(String ... usernames) {
        return new GetUsersRequestBuilder(this.client).usernames(usernames);
    }

    public void getUsers(GetUsersRequest request, ActionListener<GetUsersResponse> listener) {
        this.client.execute((Action)GetUsersAction.INSTANCE, (ActionRequest)request, listener);
    }

    public DeleteUserRequestBuilder prepareDeleteUser(String username) {
        return new DeleteUserRequestBuilder(this.client).username(username);
    }

    public void deleteUser(DeleteUserRequest request, ActionListener<DeleteUserResponse> listener) {
        this.client.execute((Action)DeleteUserAction.INSTANCE, (ActionRequest)request, listener);
    }

    public PutUserRequestBuilder preparePutUser(String username, BytesReference source) throws IOException {
        return new PutUserRequestBuilder(this.client).source(username, source);
    }

    public PutUserRequestBuilder preparePutUser(String username, char[] password, String ... roles) {
        return new PutUserRequestBuilder(this.client).username(username).password(password).roles(roles);
    }

    public void putUser(PutUserRequest request, ActionListener<PutUserResponse> listener) {
        this.client.execute((Action)PutUserAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetRolesRequestBuilder prepareGetRoles(String ... names) {
        return new GetRolesRequestBuilder(this.client).names(names);
    }

    public void getRoles(GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        this.client.execute((Action)GetRolesAction.INSTANCE, (ActionRequest)request, listener);
    }

    public DeleteRoleRequestBuilder prepareDeleteRole(String name) {
        return new DeleteRoleRequestBuilder(this.client).name(name);
    }

    public void deleteRole(DeleteRoleRequest request, ActionListener<DeleteRoleResponse> listener) {
        this.client.execute((Action)DeleteRoleAction.INSTANCE, (ActionRequest)request, listener);
    }

    public PutRoleRequestBuilder preparePutRole(String name) {
        return new PutRoleRequestBuilder(this.client).name(name);
    }

    public PutRoleRequestBuilder preparePutRole(String name, BytesReference source) throws Exception {
        return new PutRoleRequestBuilder(this.client).source(name, source);
    }

    public void putRole(PutRoleRequest request, ActionListener<PutRoleResponse> listener) {
        this.client.execute((Action)PutRoleAction.INSTANCE, (ActionRequest)request, listener);
    }
}

