/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action;

import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.ShieldBuild;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.license.ShieldLicenseState;

public class RestShieldInfoAction
extends BaseRestHandler {
    private final ClusterName clusterName;
    private final ShieldLicenseState shieldLicenseState;
    private final boolean shieldEnabled;

    @Inject
    public RestShieldInfoAction(Settings settings, RestController controller, Client client, ClusterName clusterName, @Nullable ShieldLicenseState licenseState) {
        super(settings, controller, client);
        this.clusterName = clusterName;
        this.shieldLicenseState = licenseState;
        this.shieldEnabled = ShieldPlugin.shieldEnabled(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_shield", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.HEAD, "/_shield", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        if (request.method() == RestRequest.Method.HEAD) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK));
            return;
        }
        XContentBuilder builder = channel.newBuilder();
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.startObject();
        builder.field("status", (Object)this.resolveStatus());
        if (this.settings.get("name") != null) {
            builder.field("name", this.settings.get("name"));
        }
        builder.field("cluster_name", this.clusterName.value());
        builder.startObject("version").field("number", Version.CURRENT.number()).field("build_hash", ShieldBuild.CURRENT.hash()).field("build_timestamp", ShieldBuild.CURRENT.timestamp()).field("build_snapshot", (Object)Version.CURRENT.snapshot).endObject();
        builder.field("tagline", "You Know, for Security");
        builder.endObject();
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }

    private Status resolveStatus() {
        if (this.shieldEnabled) {
            assert (this.shieldLicenseState != null);
            if (this.shieldLicenseState.securityEnabled() && this.shieldLicenseState.statsAndHealthEnabled()) {
                return Status.ENABLED;
            }
            return Status.UNLICENSED;
        }
        return Status.DISABLED;
    }

    private static enum Status {
        ENABLED("enabled"),
        DISABLED("disabled"),
        UNLICENSED("unlicensed");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

